/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.text.Editable;
import android.text.TextWatcher;
import android.util.Patterns;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.io.IOException;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractActivity;
import org.mozilla.gecko.fxa.activities.FxAccountSetupTask;

public abstract class FxAccountAbstractSetupActivity
extends FxAccountAbstractActivity
implements FxAccountSetupTask.ProgressDisplay {
    private static final String LOG_TAG = FxAccountAbstractSetupActivity.class.getSimpleName();
    protected int minimumPasswordLength = 8;
    protected EditText emailEdit;
    protected EditText passwordEdit;
    protected Button showPasswordButton;
    protected TextView remoteErrorTextView;
    protected Button button;
    protected ProgressBar progressBar;

    public FxAccountAbstractSetupActivity() {
        super(5);
    }

    protected FxAccountAbstractSetupActivity(int n) {
        super(n);
    }

    protected void createShowPasswordButton() {
        this.showPasswordButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean bl = 0 == (FxAccountAbstractSetupActivity.this.passwordEdit.getInputType() & 0x80);
                int n = FxAccountAbstractSetupActivity.this.passwordEdit.getSelectionStart();
                int n2 = FxAccountAbstractSetupActivity.this.passwordEdit.getSelectionEnd();
                FxAccountAbstractSetupActivity.this.passwordEdit.setInputType(FxAccountAbstractSetupActivity.this.passwordEdit.getInputType() ^ 0x80);
                FxAccountAbstractSetupActivity.this.passwordEdit.setSelection(n, n2);
                if (bl) {
                    FxAccountAbstractSetupActivity.this.showPasswordButton.setText(R.string.fxaccount_password_show);
                } else {
                    FxAccountAbstractSetupActivity.this.showPasswordButton.setText(R.string.fxaccount_password_hide);
                }
            }
        });
    }

    protected void hideRemoteError() {
        this.remoteErrorTextView.setVisibility(4);
    }

    protected void showRemoteError(Exception exception, int n) {
        if (exception instanceof IOException) {
            this.remoteErrorTextView.setText(R.string.fxaccount_remote_error_COULD_NOT_CONNECT);
        } else if (exception instanceof FxAccountClientException.FxAccountClientRemoteException) {
            this.remoteErrorTextView.setText(((FxAccountClientException.FxAccountClientRemoteException)exception).getErrorMessageStringResource());
        } else {
            this.remoteErrorTextView.setText(n);
        }
        Logger.warn(LOG_TAG, "Got exception; showing error message: " + ((Object)this.remoteErrorTextView.getText()).toString(), exception);
        this.remoteErrorTextView.setVisibility(0);
    }

    protected void addListeners() {
        TextChangedListener textChangedListener = new TextChangedListener();
        EditorActionListener editorActionListener = new EditorActionListener();
        FocusChangeListener focusChangeListener = new FocusChangeListener();
        this.emailEdit.addTextChangedListener((TextWatcher)textChangedListener);
        this.emailEdit.setOnEditorActionListener((TextView.OnEditorActionListener)editorActionListener);
        this.emailEdit.setOnFocusChangeListener((View.OnFocusChangeListener)focusChangeListener);
        this.passwordEdit.addTextChangedListener((TextWatcher)textChangedListener);
        this.passwordEdit.setOnEditorActionListener((TextView.OnEditorActionListener)editorActionListener);
        this.passwordEdit.setOnFocusChangeListener((View.OnFocusChangeListener)focusChangeListener);
    }

    protected boolean shouldButtonBeEnabled() {
        String string2 = this.emailEdit.getText().toString();
        String string3 = this.passwordEdit.getText().toString();
        boolean bl = string2.length() > 0 && Patterns.EMAIL_ADDRESS.matcher(string2).matches() && string3.length() >= this.minimumPasswordLength;
        return bl;
    }

    protected boolean updateButtonState() {
        boolean bl = this.shouldButtonBeEnabled();
        if (!bl) {
            this.hideRemoteError();
        }
        if (bl != this.button.isEnabled()) {
            Logger.debug(LOG_TAG, (bl ? "En" : "Dis") + "abling button.");
            this.button.setEnabled(bl);
        }
        return bl;
    }

    public void showProgress() {
        this.progressBar.setVisibility(0);
        this.button.setVisibility(4);
    }

    public void dismissProgress() {
        this.progressBar.setVisibility(4);
        this.button.setVisibility(0);
    }

    protected class TextChangedListener
    implements TextWatcher {
        protected TextChangedListener() {
        }

        public void afterTextChanged(Editable editable) {
            FxAccountAbstractSetupActivity.this.updateButtonState();
        }

        public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }

        public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        }
    }

    protected class EditorActionListener
    implements TextView.OnEditorActionListener {
        protected EditorActionListener() {
        }

        public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
            FxAccountAbstractSetupActivity.this.updateButtonState();
            return false;
        }
    }

    protected class FocusChangeListener
    implements View.OnFocusChangeListener {
        protected FocusChangeListener() {
        }

        public void onFocusChange(View view, boolean bl) {
            if (bl) {
                return;
            }
            FxAccountAbstractSetupActivity.this.updateButtonState();
        }
    }
}

