/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.content.Context;
import android.os.AsyncTask;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.util.concurrent.CountDownLatch;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class FxAccountSetupTask<T>
extends AsyncTask<Void, Void, InnerRequestDelegate<T>> {
    private static final String LOG_TAG = FxAccountSetupTask.class.getSimpleName();
    protected final Context context;
    protected final FxAccountClient20 client;
    protected final ProgressDisplay progressDisplay;
    protected byte[] quickStretchedPW;
    protected final CountDownLatch latch = new CountDownLatch(1);
    protected final InnerRequestDelegate<T> innerDelegate = new InnerRequestDelegate(this.latch);
    protected final FxAccountClient10.RequestDelegate<T> delegate;

    public FxAccountSetupTask(Context context, ProgressDisplay progressDisplay, FxAccountClient20 fxAccountClient20, FxAccountClient10.RequestDelegate<T> requestDelegate) {
        this.context = context;
        this.client = fxAccountClient20;
        this.delegate = requestDelegate;
        this.progressDisplay = progressDisplay;
    }

    protected void onPreExecute() {
        if (this.progressDisplay != null) {
            this.progressDisplay.showProgress();
        }
    }

    protected void onPostExecute(InnerRequestDelegate<T> innerRequestDelegate) {
        if (this.progressDisplay != null) {
            this.progressDisplay.dismissProgress();
        }
        if (this.innerDelegate.failure != null) {
            this.delegate.handleFailure(this.innerDelegate.failure);
        } else if (this.innerDelegate.exception != null) {
            this.delegate.handleError(this.innerDelegate.exception);
        } else {
            this.delegate.handleSuccess(innerRequestDelegate.response);
        }
    }

    protected void onCancelled(InnerRequestDelegate<T> innerRequestDelegate) {
        if (this.progressDisplay != null) {
            this.progressDisplay.dismissProgress();
        }
        this.delegate.handleError(new IllegalStateException("Task was cancelled."));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FxAccountSignInTask
    extends FxAccountSetupTask<FxAccountClient20.LoginResponse> {
        protected static final String LOG_TAG = FxAccountSignInTask.class.getSimpleName();
        protected final byte[] emailUTF8;
        protected final byte[] passwordUTF8;

        public FxAccountSignInTask(Context context, ProgressDisplay progressDisplay, String string2, String string3, FxAccountClient20 fxAccountClient20, FxAccountClient10.RequestDelegate<FxAccountClient20.LoginResponse> requestDelegate) throws UnsupportedEncodingException {
            super(context, progressDisplay, fxAccountClient20, requestDelegate);
            this.emailUTF8 = string2.getBytes("UTF-8");
            this.passwordUTF8 = string3.getBytes("UTF-8");
        }

        public byte[] generateQuickStretchedPW() throws UnsupportedEncodingException, GeneralSecurityException {
            if (this.quickStretchedPW == null) {
                this.quickStretchedPW = FxAccountUtils.generateQuickStretchedPW(this.emailUTF8, this.passwordUTF8);
            }
            return this.quickStretchedPW;
        }

        protected InnerRequestDelegate<FxAccountClient20.LoginResponse> doInBackground(Void ... voidArray) {
            try {
                this.client.loginAndGetKeys(this.emailUTF8, this.generateQuickStretchedPW(), this.innerDelegate);
                this.latch.await();
                return this.innerDelegate;
            }
            catch (Exception exception) {
                Logger.error(LOG_TAG, "Got exception signing in.", exception);
                this.delegate.handleError(exception);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FxAccountCreateAccountTask
    extends FxAccountSetupTask<String> {
        private static final String LOG_TAG = FxAccountCreateAccountTask.class.getSimpleName();
        protected final byte[] emailUTF8;
        protected final byte[] passwordUTF8;

        public FxAccountCreateAccountTask(Context context, ProgressDisplay progressDisplay, String string2, String string3, FxAccountClient20 fxAccountClient20, FxAccountClient10.RequestDelegate<String> requestDelegate) throws UnsupportedEncodingException {
            super(context, progressDisplay, fxAccountClient20, requestDelegate);
            this.emailUTF8 = string2.getBytes("UTF-8");
            this.passwordUTF8 = string3.getBytes("UTF-8");
        }

        public byte[] generateQuickStretchedPW() throws UnsupportedEncodingException, GeneralSecurityException {
            if (this.quickStretchedPW == null) {
                this.quickStretchedPW = FxAccountUtils.generateQuickStretchedPW(this.emailUTF8, this.passwordUTF8);
            }
            return this.quickStretchedPW;
        }

        protected InnerRequestDelegate<String> doInBackground(Void ... voidArray) {
            try {
                this.client.createAccount(this.emailUTF8, this.generateQuickStretchedPW(), false, this.innerDelegate);
                this.latch.await();
                return this.innerDelegate;
            }
            catch (Exception exception) {
                Logger.error(LOG_TAG, "Got exception logging in.", exception);
                this.delegate.handleError(exception);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class InnerRequestDelegate<T>
    implements FxAccountClient10.RequestDelegate<T> {
        protected final CountDownLatch latch;
        public T response = null;
        public Exception exception = null;
        public FxAccountClientException.FxAccountClientRemoteException failure = null;

        protected InnerRequestDelegate(CountDownLatch countDownLatch) {
            this.latch = countDownLatch;
        }

        @Override
        public void handleError(Exception exception) {
            Logger.error(LOG_TAG, "Got exception.");
            this.exception = exception;
            this.latch.countDown();
        }

        @Override
        public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
            Logger.warn(LOG_TAG, "Got failure.");
            this.failure = fxAccountClientRemoteException;
            this.latch.countDown();
        }

        @Override
        public void handleSuccess(T t) {
            Logger.info(LOG_TAG, "Got success.");
            this.response = t;
            this.latch.countDown();
        }
    }

    public static interface ProgressDisplay {
        public void showProgress();

        public void dismissProgress();
    }
}

