/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.os.SystemClock;
import org.mozilla.gecko.gfx.DisplayPortMetrics;

final class DrawTimingQueue {
    private static final String LOGTAG = "GeckoDrawTimingQueue";
    private static final int BUFFER_SIZE = 16;
    private final DisplayPortMetrics[] mMetrics = new DisplayPortMetrics[16];
    private final long[] mTimestamps = new long[16];
    private int mHead = 15;
    private int mTail = 0;

    DrawTimingQueue() {
    }

    boolean add(DisplayPortMetrics displayPortMetrics) {
        if (this.mHead == this.mTail) {
            return false;
        }
        this.mMetrics[this.mTail] = displayPortMetrics;
        this.mTimestamps[this.mTail] = SystemClock.uptimeMillis();
        this.mTail = (this.mTail + 1) % 16;
        return true;
    }

    long findTimeFor(DisplayPortMetrics displayPortMetrics) {
        int n = this.mTail;
        int n2 = (this.mHead + 1) % 16;
        while (n2 != n) {
            if (this.mMetrics[n2].fuzzyEquals(displayPortMetrics)) {
                long l = this.mTimestamps[n2];
                this.mHead = n2;
                return l;
            }
            n2 = (n2 + 1) % 16;
        }
        return -1L;
    }

    void reset() {
        this.mHead = (this.mTail + 16 - 1) % 16;
    }
}

