/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.gfx;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Build;
import android.view.View;
import android.widget.EdgeEffect;
import org.mozilla.gecko.gfx.ImmutableViewportMetrics;
import org.mozilla.gecko.gfx.Overscroll;

public class OverscrollEdgeEffect
implements Overscroll {
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private final EdgeEffect[] mEdges = new EdgeEffect[4];
    private final View mView;

    public OverscrollEdgeEffect(View view) {
        this.mView = view;
        Context context = view.getContext();
        for (int i = 0; i < 4; ++i) {
            this.mEdges[i] = new EdgeEffect(context);
        }
    }

    public void setSize(int n, int n2) {
        this.mEdges[2].setSize(n2, n);
        this.mEdges[3].setSize(n2, n);
        this.mEdges[0].setSize(n, n2);
        this.mEdges[1].setSize(n, n2);
    }

    private EdgeEffect getEdgeForAxisAndSide(Overscroll.Axis axis, float f) {
        if (axis == Overscroll.Axis.Y) {
            if (f < 0.0f) {
                return this.mEdges[0];
            }
            return this.mEdges[1];
        }
        if (f < 0.0f) {
            return this.mEdges[2];
        }
        return this.mEdges[3];
    }

    private void invalidate() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mView.postInvalidateOnAnimation();
        } else {
            this.mView.postInvalidateDelayed(10L);
        }
    }

    public void setVelocity(float f, Overscroll.Axis axis) {
        EdgeEffect edgeEffect = this.getEdgeForAxisAndSide(axis, f);
        if (!edgeEffect.isFinished()) {
            edgeEffect.onRelease();
        } else {
            edgeEffect.onAbsorb((int)f);
        }
        this.invalidate();
    }

    public void setDistance(float f, Overscroll.Axis axis) {
        if (f == 0.0f) {
            return;
        }
        EdgeEffect edgeEffect = this.getEdgeForAxisAndSide(axis, (int)f);
        edgeEffect.onPull(f / (float)(axis == Overscroll.Axis.X ? this.mView.getWidth() : this.mView.getHeight()));
        this.invalidate();
    }

    public void draw(Canvas canvas, ImmutableViewportMetrics immutableViewportMetrics) {
        if (immutableViewportMetrics == null) {
            return;
        }
        boolean bl = false;
        if (!this.mEdges[0].isFinished()) {
            bl |= this.draw(this.mEdges[0], canvas, immutableViewportMetrics.marginLeft, immutableViewportMetrics.marginTop, 0.0f);
        }
        if (!this.mEdges[1].isFinished()) {
            bl |= this.draw(this.mEdges[1], canvas, this.mView.getWidth(), this.mView.getHeight(), 180.0f);
        }
        if (!this.mEdges[2].isFinished()) {
            bl |= this.draw(this.mEdges[2], canvas, immutableViewportMetrics.marginLeft, this.mView.getHeight(), 270.0f);
        }
        if (!this.mEdges[3].isFinished()) {
            bl |= this.draw(this.mEdges[3], canvas, this.mView.getWidth(), immutableViewportMetrics.marginTop, 90.0f);
        }
        if (bl) {
            this.invalidate();
        }
    }

    public boolean draw(EdgeEffect edgeEffect, Canvas canvas, float f, float f2, float f3) {
        int n = canvas.save();
        canvas.translate(f, f2);
        canvas.rotate(f3);
        boolean bl = edgeEffect.draw(canvas);
        canvas.restoreToCount(n);
        return bl;
    }
}

