/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.home.FramePanelLayout;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.HomeFragment;
import org.mozilla.gecko.home.HomePager;
import org.mozilla.gecko.home.PanelLayout;
import org.mozilla.gecko.home.SimpleCursorLoader;

public class DynamicPanel
extends HomeFragment {
    private static final String LOGTAG = "GeckoDynamicPanel";
    private static final String DATASET_ID = "dataset_id";
    private PanelLayout mLayout;
    private HomeConfig.PanelConfig mPanelConfig;
    private PanelLoaderCallbacks mLoaderCallbacks;
    private HomePager.OnUrlOpenListener mUrlOpenListener;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.mUrlOpenListener = (HomePager.OnUrlOpenListener)activity;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(activity.toString() + " must implement HomePager.OnUrlOpenListener");
        }
    }

    public void onDetach() {
        super.onDetach();
        this.mUrlOpenListener = null;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        Bundle bundle2 = this.getArguments();
        if (bundle2 != null) {
            this.mPanelConfig = (HomeConfig.PanelConfig)bundle2.getParcelable("panelConfig");
        }
        if (this.mPanelConfig == null) {
            throw new IllegalStateException("Can't create a DynamicPanel without a PanelConfig");
        }
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        switch (this.mPanelConfig.getLayoutType()) {
            case FRAME: {
                PanelDatasetHandler panelDatasetHandler = new PanelDatasetHandler();
                this.mLayout = new FramePanelLayout((Context)this.getActivity(), this.mPanelConfig, panelDatasetHandler);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized layout type in DynamicPanel");
            }
        }
        Log.d((String)LOGTAG, (String)("Created layout of type: " + (Object)((Object)this.mPanelConfig.getLayoutType())));
        return this.mLayout;
    }

    public void onViewCreated(View view, Bundle bundle) {
        super.onViewCreated(view, bundle);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.mLayout = null;
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isVisible()) {
            this.getFragmentManager().beginTransaction().detach((Fragment)this).attach((Fragment)this).commitAllowingStateLoss();
        }
    }

    public void onActivityCreated(Bundle bundle) {
        super.onActivityCreated(bundle);
        this.mLoaderCallbacks = new PanelLoaderCallbacks();
        this.loadIfVisible();
    }

    protected void load() {
        Log.d((String)LOGTAG, (String)"Loading layout");
        this.mLayout.load();
    }

    private static int generateLoaderId(String string2) {
        return string2.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PanelLoaderCallbacks
    implements LoaderManager.LoaderCallbacks<Cursor> {
        private PanelLoaderCallbacks() {
        }

        public Loader<Cursor> onCreateLoader(int n, Bundle bundle) {
            String string2 = bundle.getString(DynamicPanel.DATASET_ID);
            Log.d((String)DynamicPanel.LOGTAG, (String)("Creating loader for dataset: " + string2));
            return new PanelDatasetLoader((Context)DynamicPanel.this.getActivity(), string2);
        }

        public void onLoadFinished(Loader<Cursor> loader, Cursor cursor) {
            PanelDatasetLoader panelDatasetLoader = (PanelDatasetLoader)loader;
            Log.d((String)DynamicPanel.LOGTAG, (String)("Finished loader for dataset: " + panelDatasetLoader.getDatasetId()));
            DynamicPanel.this.mLayout.deliverDataset(panelDatasetLoader.getDatasetId(), cursor);
        }

        public void onLoaderReset(Loader<Cursor> loader) {
            PanelDatasetLoader panelDatasetLoader = (PanelDatasetLoader)loader;
            Log.d((String)DynamicPanel.LOGTAG, (String)("Resetting loader for dataset: " + panelDatasetLoader.getDatasetId()));
            if (DynamicPanel.this.mLayout != null) {
                DynamicPanel.this.mLayout.releaseDataset(panelDatasetLoader.getDatasetId());
            }
        }
    }

    private static class PanelDatasetLoader
    extends SimpleCursorLoader {
        private final String mDatasetId;

        public PanelDatasetLoader(Context context, String string2) {
            super(context);
            this.mDatasetId = string2;
        }

        public String getDatasetId() {
            return this.mDatasetId;
        }

        public Cursor loadCursor() {
            ContentResolver contentResolver = this.getContext().getContentResolver();
            String[] stringArray = new String[]{this.mDatasetId};
            return contentResolver.query(BrowserContract.HomeItems.CONTENT_URI, null, "dataset_id = ?", stringArray, null);
        }
    }

    private class PanelDatasetHandler
    implements PanelLayout.DatasetHandler {
        private PanelDatasetHandler() {
        }

        public void requestDataset(String string2) {
            Log.d((String)DynamicPanel.LOGTAG, (String)("Requesting dataset: " + string2));
            if (!DynamicPanel.this.getCanLoadHint()) {
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString(DynamicPanel.DATASET_ID, string2);
            int n = DynamicPanel.generateLoaderId(string2);
            DynamicPanel.this.getLoaderManager().restartLoader(n, bundle, (LoaderManager.LoaderCallbacks)DynamicPanel.this.mLoaderCallbacks);
        }

        public void resetDataset(String string2) {
            Log.d((String)DynamicPanel.LOGTAG, (String)("Resetting dataset: " + string2));
            LoaderManager loaderManager = DynamicPanel.this.getLoaderManager();
            int n = DynamicPanel.generateLoaderId(string2);
            Loader loader = loaderManager.getLoader(n);
            if (loader != null) {
                loader.reset();
            }
        }
    }
}

