/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.home.BookmarksPanel;
import org.mozilla.gecko.home.DynamicPanel;
import org.mozilla.gecko.home.HistoryPanel;
import org.mozilla.gecko.home.HomeConfigPrefsBackend;
import org.mozilla.gecko.home.ReadingListPanel;
import org.mozilla.gecko.home.TopSitesPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HomeConfig {
    private final HomeConfigBackend mBackend;

    public HomeConfig(HomeConfigBackend homeConfigBackend) {
        this.mBackend = homeConfigBackend;
    }

    public List<PanelConfig> load() {
        return this.mBackend.load();
    }

    public void save(List<PanelConfig> list) {
        this.mBackend.save(list);
    }

    public void setOnChangeListener(OnChangeListener onChangeListener) {
        this.mBackend.setOnChangeListener(onChangeListener);
    }

    public static HomeConfig getDefault(Context context) {
        return new HomeConfig(new HomeConfigPrefsBackend(context));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface HomeConfigBackend {
        public List<PanelConfig> load();

        public void save(List<PanelConfig> var1);

        public void setOnChangeListener(OnChangeListener var1);
    }

    public static interface OnChangeListener {
        public void onChange();
    }

    public static class ViewConfig
    implements Parcelable {
        private final ViewType mType;
        private final String mDatasetId;
        private static final String JSON_KEY_TYPE = "type";
        private static final String JSON_KEY_DATASET = "dataset";
        public static final Parcelable.Creator<ViewConfig> CREATOR = new Parcelable.Creator<ViewConfig>(){

            public ViewConfig createFromParcel(Parcel parcel) {
                return new ViewConfig(parcel);
            }

            public ViewConfig[] newArray(int n) {
                return new ViewConfig[n];
            }
        };

        public ViewConfig(JSONObject jSONObject) throws JSONException, IllegalArgumentException {
            this.mType = ViewType.fromId(jSONObject.getString(JSON_KEY_TYPE));
            this.mDatasetId = jSONObject.getString(JSON_KEY_DATASET);
            this.validate();
        }

        public ViewConfig(Parcel parcel) {
            this.mType = (ViewType)parcel.readParcelable(this.getClass().getClassLoader());
            this.mDatasetId = parcel.readString();
            this.validate();
        }

        public ViewConfig(ViewConfig viewConfig) {
            this.mType = viewConfig.mType;
            this.mDatasetId = viewConfig.mDatasetId;
            this.validate();
        }

        public ViewConfig(ViewType viewType, String string2) {
            this.mType = viewType;
            this.mDatasetId = string2;
            this.validate();
        }

        private void validate() {
            if (this.mType == null) {
                throw new IllegalArgumentException("Can't create ViewConfig with null type");
            }
            if (TextUtils.isEmpty((CharSequence)this.mDatasetId)) {
                throw new IllegalArgumentException("Can't create ViewConfig with empty dataset ID");
            }
        }

        public ViewType getType() {
            return this.mType;
        }

        public String getDatasetId() {
            return this.mDatasetId;
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(JSON_KEY_TYPE, (Object)this.mType.toString());
            jSONObject.put(JSON_KEY_DATASET, (Object)this.mDatasetId);
            return jSONObject;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeParcelable((Parcelable)this.mType, 0);
            parcel.writeString(this.mDatasetId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ViewType implements Parcelable
    {
        LIST("list");

        private final String mId;
        public static final Parcelable.Creator<ViewType> CREATOR;

        private ViewType(String string3) {
            this.mId = string3;
        }

        public static ViewType fromId(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Could not convert null String to ViewType");
            }
            for (ViewType viewType : ViewType.values()) {
                if (!TextUtils.equals((CharSequence)viewType.mId, (CharSequence)string2.toLowerCase())) continue;
                return viewType;
            }
            throw new IllegalArgumentException("Could not convert String id to ViewType");
        }

        public String toString() {
            return this.mId;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<ViewType>(){

                public ViewType createFromParcel(Parcel parcel) {
                    return ViewType.values()[parcel.readInt()];
                }

                public ViewType[] newArray(int n) {
                    return new ViewType[n];
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LayoutType implements Parcelable
    {
        FRAME("frame");

        private final String mId;
        public static final Parcelable.Creator<LayoutType> CREATOR;

        private LayoutType(String string3) {
            this.mId = string3;
        }

        public static LayoutType fromId(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Could not convert null String to LayoutType");
            }
            for (LayoutType layoutType : LayoutType.values()) {
                if (!TextUtils.equals((CharSequence)layoutType.mId, (CharSequence)string2.toLowerCase())) continue;
                return layoutType;
            }
            throw new IllegalArgumentException("Could not convert String id to LayoutType");
        }

        public String toString() {
            return this.mId;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<LayoutType>(){

                public LayoutType createFromParcel(Parcel parcel) {
                    return LayoutType.values()[parcel.readInt()];
                }

                public LayoutType[] newArray(int n) {
                    return new LayoutType[n];
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PanelConfig
    implements Parcelable {
        private final PanelType mType;
        private final String mTitle;
        private final String mId;
        private final LayoutType mLayoutType;
        private final List<ViewConfig> mViews;
        private final EnumSet<Flags> mFlags;
        private static final String JSON_KEY_TYPE = "type";
        private static final String JSON_KEY_TITLE = "title";
        private static final String JSON_KEY_ID = "id";
        private static final String JSON_KEY_LAYOUT = "layout";
        private static final String JSON_KEY_VIEWS = "views";
        private static final String JSON_KEY_DEFAULT = "default";
        private static final String JSON_KEY_DISABLED = "disabled";
        public static final Parcelable.Creator<PanelConfig> CREATOR = new Parcelable.Creator<PanelConfig>(){

            public PanelConfig createFromParcel(Parcel parcel) {
                return new PanelConfig(parcel);
            }

            public PanelConfig[] newArray(int n) {
                return new PanelConfig[n];
            }
        };

        public PanelConfig(JSONObject jSONObject) throws JSONException, IllegalArgumentException {
            this.mType = PanelType.fromId(jSONObject.getString(JSON_KEY_TYPE));
            this.mTitle = jSONObject.getString(JSON_KEY_TITLE);
            this.mId = jSONObject.getString(JSON_KEY_ID);
            String string2 = jSONObject.optString(JSON_KEY_LAYOUT, null);
            this.mLayoutType = string2 != null ? LayoutType.fromId(string2) : null;
            JSONArray jSONArray = jSONObject.optJSONArray(JSON_KEY_VIEWS);
            if (jSONArray != null) {
                this.mViews = new ArrayList<ViewConfig>();
                int n = jSONArray.length();
                for (int i = 0; i < n; ++i) {
                    JSONObject jSONObject2 = (JSONObject)jSONArray.get(i);
                    ViewConfig viewConfig = new ViewConfig(jSONObject2);
                    this.mViews.add(viewConfig);
                }
            } else {
                this.mViews = null;
            }
            this.mFlags = EnumSet.noneOf(Flags.class);
            if (jSONObject.optBoolean(JSON_KEY_DEFAULT, false)) {
                this.mFlags.add(Flags.DEFAULT_PANEL);
            }
            if (jSONObject.optBoolean(JSON_KEY_DISABLED, false)) {
                this.mFlags.add(Flags.DISABLED_PANEL);
            }
            this.validate();
        }

        public PanelConfig(Parcel parcel) {
            this.mType = (PanelType)parcel.readParcelable(this.getClass().getClassLoader());
            this.mTitle = parcel.readString();
            this.mId = parcel.readString();
            this.mLayoutType = (LayoutType)parcel.readParcelable(this.getClass().getClassLoader());
            this.mViews = new ArrayList<ViewConfig>();
            parcel.readTypedList(this.mViews, ViewConfig.CREATOR);
            this.mFlags = (EnumSet)parcel.readSerializable();
            this.validate();
        }

        public PanelConfig(PanelConfig panelConfig) {
            this.mType = panelConfig.mType;
            this.mTitle = panelConfig.mTitle;
            this.mId = panelConfig.mId;
            this.mLayoutType = panelConfig.mLayoutType;
            this.mViews = new ArrayList<ViewConfig>();
            List<ViewConfig> list = panelConfig.mViews;
            if (list != null) {
                for (ViewConfig viewConfig : list) {
                    this.mViews.add(new ViewConfig(viewConfig));
                }
            }
            this.mFlags = panelConfig.mFlags.clone();
            this.validate();
        }

        public PanelConfig(PanelType panelType, String string2, String string3) {
            this(panelType, string2, string3, EnumSet.noneOf(Flags.class));
        }

        public PanelConfig(PanelType panelType, String string2, String string3, EnumSet<Flags> enumSet) {
            this(panelType, string2, string3, null, null, enumSet);
        }

        public PanelConfig(PanelType panelType, String string2, String string3, LayoutType layoutType, List<ViewConfig> list, EnumSet<Flags> enumSet) {
            this.mType = panelType;
            this.mTitle = string2;
            this.mId = string3;
            this.mLayoutType = layoutType;
            this.mViews = list;
            this.mFlags = enumSet;
            this.validate();
        }

        private void validate() {
            if (this.mType == null) {
                throw new IllegalArgumentException("Can't create PanelConfig with null type");
            }
            if (TextUtils.isEmpty((CharSequence)this.mTitle)) {
                throw new IllegalArgumentException("Can't create PanelConfig with empty title");
            }
            if (TextUtils.isEmpty((CharSequence)this.mId)) {
                throw new IllegalArgumentException("Can't create PanelConfig with empty id");
            }
            if (this.mLayoutType == null && this.mType == PanelType.DYNAMIC) {
                throw new IllegalArgumentException("Can't create a dynamic PanelConfig with null layout type");
            }
            if ((this.mViews == null || this.mViews.size() == 0) && this.mType == PanelType.DYNAMIC) {
                throw new IllegalArgumentException("Can't create a dynamic PanelConfig with no views");
            }
            if (this.mFlags == null) {
                throw new IllegalArgumentException("Can't create PanelConfig with null flags");
            }
        }

        public PanelType getType() {
            return this.mType;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String getId() {
            return this.mId;
        }

        public LayoutType getLayoutType() {
            return this.mLayoutType;
        }

        public int getViewCount() {
            return this.mViews != null ? this.mViews.size() : 0;
        }

        public ViewConfig getViewAt(int n) {
            return this.mViews != null ? this.mViews.get(n) : null;
        }

        public boolean isDefault() {
            return this.mFlags.contains((Object)Flags.DEFAULT_PANEL);
        }

        public void setIsDefault(boolean bl) {
            if (bl) {
                this.mFlags.add(Flags.DEFAULT_PANEL);
            } else {
                this.mFlags.remove((Object)Flags.DEFAULT_PANEL);
            }
        }

        public boolean isDisabled() {
            return this.mFlags.contains((Object)Flags.DISABLED_PANEL);
        }

        public void setIsDisabled(boolean bl) {
            if (bl) {
                this.mFlags.add(Flags.DISABLED_PANEL);
            } else {
                this.mFlags.remove((Object)Flags.DISABLED_PANEL);
            }
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(JSON_KEY_TYPE, (Object)this.mType.toString());
            jSONObject.put(JSON_KEY_TITLE, (Object)this.mTitle);
            jSONObject.put(JSON_KEY_ID, (Object)this.mId);
            if (this.mLayoutType != null) {
                jSONObject.put(JSON_KEY_LAYOUT, (Object)this.mLayoutType.toString());
            }
            if (this.mViews != null) {
                JSONArray jSONArray = new JSONArray();
                int n = this.mViews.size();
                for (int i = 0; i < n; ++i) {
                    ViewConfig viewConfig = this.mViews.get(i);
                    JSONObject jSONObject2 = viewConfig.toJSON();
                    jSONArray.put((Object)jSONObject2);
                }
                jSONObject.put(JSON_KEY_VIEWS, (Object)jSONArray);
            }
            if (this.mFlags.contains((Object)Flags.DEFAULT_PANEL)) {
                jSONObject.put(JSON_KEY_DEFAULT, true);
            }
            if (this.mFlags.contains((Object)Flags.DISABLED_PANEL)) {
                jSONObject.put(JSON_KEY_DISABLED, true);
            }
            return jSONObject;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeParcelable((Parcelable)this.mType, 0);
            parcel.writeString(this.mTitle);
            parcel.writeString(this.mId);
            parcel.writeParcelable((Parcelable)this.mLayoutType, 0);
            parcel.writeTypedList(this.mViews);
            parcel.writeSerializable(this.mFlags);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Flags {
            DEFAULT_PANEL,
            DISABLED_PANEL;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PanelType implements Parcelable
    {
        TOP_SITES("top_sites", TopSitesPanel.class),
        BOOKMARKS("bookmarks", BookmarksPanel.class),
        HISTORY("history", HistoryPanel.class),
        READING_LIST("reading_list", ReadingListPanel.class),
        DYNAMIC("dynamic", DynamicPanel.class);

        private final String mId;
        private final Class<?> mPanelClass;
        public static final Parcelable.Creator<PanelType> CREATOR;

        private PanelType(String string3, Class<?> clazz) {
            this.mId = string3;
            this.mPanelClass = clazz;
        }

        public static PanelType fromId(String string2) {
            if (string2 == null) {
                throw new IllegalArgumentException("Could not convert null String to PanelType");
            }
            for (PanelType panelType : PanelType.values()) {
                if (!TextUtils.equals((CharSequence)panelType.mId, (CharSequence)string2.toLowerCase())) continue;
                return panelType;
            }
            throw new IllegalArgumentException("Could not convert String id to PanelType");
        }

        public String toString() {
            return this.mId;
        }

        public Class<?> getPanelClass() {
            return this.mPanelClass;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.ordinal());
        }

        static {
            CREATOR = new Parcelable.Creator<PanelType>(){

                public PanelType createFromParcel(Parcel parcel) {
                    return PanelType.values()[parcel.readInt()];
                }

                public PanelType[] newArray(int n) {
                    return new PanelType[n];
                }
            };
        }
    }
}

