/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.home.PanelListView;

abstract class PanelLayout
extends FrameLayout {
    private static final String LOGTAG = "GeckoPanelLayout";
    private final List<ViewEntry> mViewEntries = new ArrayList<ViewEntry>();
    private final DatasetHandler mDatasetHandler;

    public PanelLayout(Context context, HomeConfig.PanelConfig panelConfig, DatasetHandler datasetHandler) {
        super(context);
        this.mDatasetHandler = datasetHandler;
    }

    public final void deliverDataset(String string2, Cursor cursor) {
        Log.d((String)LOGTAG, (String)("Delivering dataset: " + string2));
        this.updateViewsWithDataset(string2, cursor);
    }

    public final void releaseDataset(String string2) {
        Log.d((String)LOGTAG, (String)("Resetting dataset: " + string2));
        this.updateViewsWithDataset(string2, null);
    }

    protected final void requestDataset(String string2) {
        Log.d((String)LOGTAG, (String)("Requesting dataset: " + string2));
        this.mDatasetHandler.requestDataset(string2);
    }

    protected final void resetDataset(String string2) {
        this.mDatasetHandler.resetDataset(string2);
    }

    protected final View createPanelView(HomeConfig.ViewConfig viewConfig) {
        PanelListView panelListView;
        Log.d((String)LOGTAG, (String)("Creating panel view: " + (Object)((Object)viewConfig.getType())));
        switch (viewConfig.getType()) {
            case LIST: {
                panelListView = new PanelListView(this.getContext(), viewConfig);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized view type in " + ((Object)((Object)this)).getClass().getSimpleName());
            }
        }
        ViewEntry viewEntry = new ViewEntry((View)panelListView, viewConfig);
        this.mViewEntries.add(viewEntry);
        return panelListView;
    }

    protected final void disposePanelView(View view) {
        Log.d((String)LOGTAG, (String)"Disposing panel view");
        int n = this.mViewEntries.size();
        for (int i = 0; i < n; ++i) {
            View view2 = this.mViewEntries.get(i).getView();
            if (view != view2) continue;
            this.maybeSetDataset(view2, null);
            this.mViewEntries.remove(i);
            break;
        }
    }

    private void updateViewsWithDataset(String string2, Cursor cursor) {
        int n = this.mViewEntries.size();
        for (int i = 0; i < n; ++i) {
            ViewEntry viewEntry = this.mViewEntries.get(i);
            if (!TextUtils.equals((CharSequence)viewEntry.getDatasetId(), (CharSequence)string2)) continue;
            View view = viewEntry.getView();
            this.maybeSetDataset(view, cursor);
        }
    }

    private void maybeSetDataset(View view, Cursor cursor) {
        if (view instanceof DatasetBacked) {
            DatasetBacked datasetBacked = (DatasetBacked)view;
            datasetBacked.setDataset(cursor);
        }
    }

    public abstract void load();

    private static class ViewEntry {
        private final View mView;
        private final HomeConfig.ViewConfig mViewConfig;

        public ViewEntry(View view, HomeConfig.ViewConfig viewConfig) {
            this.mView = view;
            this.mViewConfig = viewConfig;
        }

        public View getView() {
            return this.mView;
        }

        public String getDatasetId() {
            return this.mViewConfig.getDatasetId();
        }
    }

    public static interface DatasetHandler {
        public void requestDataset(String var1);

        public void resetDataset(String var1);
    }

    public static interface DatasetBacked {
        public void setDataset(Cursor var1);
    }
}

