/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import java.lang.ref.WeakReference;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.OnFaviconLoadedListener;
import org.mozilla.gecko.home.TwoLineRow;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.FaviconView;

public class TwoLinePageRow
extends TwoLineRow
implements Tabs.OnTabsChangedListener {
    private final FaviconView mFavicon = (FaviconView)this.findViewById(R.id.icon);
    private boolean mShowIcons = true;
    private int mLoadFaviconJobId = 0;
    private final OnFaviconLoadedListener mFaviconListener = new UpdateViewFaviconLoadedListener(this.mFavicon);
    private String mPageUrl;

    public TwoLinePageRow(Context context) {
        this(context, null);
    }

    public TwoLinePageRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    protected void onAttachedToWindow() {
        Tabs.registerOnTabsChangedListener(this);
    }

    protected void onDetachedFromWindow() {
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                Tabs.unregisterOnTabsChangedListener(TwoLinePageRow.this);
            }
        });
    }

    public void onTabChanged(Tab tab, Tabs.TabEvents tabEvents, Object object) {
        switch (tabEvents) {
            case ADDED: 
            case CLOSED: 
            case LOCATION_CHANGE: {
                this.updateDisplayedUrl();
            }
        }
    }

    private void updateDisplayedUrl(String string2) {
        this.mPageUrl = string2;
        this.updateDisplayedUrl();
    }

    private void updateDisplayedUrl() {
        boolean bl = Tabs.getInstance().getSelectedTab().isPrivate();
        Tab tab = Tabs.getInstance().getFirstTabForUrl(this.mPageUrl, bl);
        if (!this.mShowIcons || tab == null) {
            this.setSecondaryText(this.mPageUrl);
            this.setSecondaryIcon(0);
        } else {
            this.setSecondaryText(R.string.switch_to_tab);
            this.setSecondaryIcon(R.drawable.ic_url_bar_tab);
        }
    }

    public void setShowIcons(boolean bl) {
        this.mShowIcons = bl;
    }

    public void updateFromCursor(Cursor cursor) {
        if (cursor == null) {
            return;
        }
        int n = cursor.getColumnIndexOrThrow("title");
        String string2 = cursor.getString(n);
        int n2 = cursor.getColumnIndexOrThrow("url");
        String string3 = cursor.getString(n2);
        if (this.mShowIcons) {
            int n3 = cursor.getColumnIndex("bookmark_id");
            if (n3 != -1) {
                long l = cursor.getLong(n3);
                int n4 = cursor.getColumnIndex("display");
                int n5 = n4 != -1 ? cursor.getInt(n4) : 0;
                if (l == 0L) {
                    this.setPrimaryIcon(0);
                } else if (n5 == 1) {
                    this.setPrimaryIcon(R.drawable.ic_url_bar_reader);
                } else {
                    this.setPrimaryIcon(R.drawable.ic_url_bar_star);
                }
            } else {
                this.setPrimaryIcon(0);
            }
        }
        this.setPrimaryText(TextUtils.isEmpty((CharSequence)string2) ? string3 : string2);
        if (string3.equals(this.mPageUrl)) {
            return;
        }
        this.mFavicon.clearImage();
        this.mLoadFaviconJobId = Favicons.getSizedFaviconForPageFromLocal(string3, this.mFaviconListener);
        this.updateDisplayedUrl(string3);
    }

    private static class UpdateViewFaviconLoadedListener
    implements OnFaviconLoadedListener {
        private final WeakReference<FaviconView> view;

        public UpdateViewFaviconLoadedListener(FaviconView faviconView) {
            this.view = new WeakReference<FaviconView>(faviconView);
        }

        public void onFaviconLoaded(String string2, String string3, Bitmap bitmap) {
            FaviconView faviconView = (FaviconView)((Object)this.view.get());
            if (faviconView == null) {
                return;
            }
            if (bitmap == null) {
                faviconView.showDefaultFavicon();
                return;
            }
            faviconView.updateImage(bitmap, string3);
        }
    }
}

