/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import java.io.IOException;
import org.mozilla.gecko.R;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GeckoMenuInflater
extends MenuInflater {
    private static final String LOGTAG = "GeckoMenuInflater";
    private static final String TAG_MENU = "menu";
    private static final String TAG_ITEM = "item";
    private static final int NO_ID = 0;
    private Context mContext;

    public GeckoMenuInflater(Context context) {
        super(context);
        this.mContext = context;
    }

    public void inflate(int n, Menu menu2) {
        XmlResourceParser xmlResourceParser = null;
        try {
            xmlResourceParser = this.mContext.getResources().getXml(n);
            AttributeSet attributeSet = Xml.asAttributeSet((XmlPullParser)xmlResourceParser);
            this.parseMenu(xmlResourceParser, attributeSet, menu2);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new InflateException("Error inflating menu XML", (Throwable)xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new InflateException("Error inflating menu XML", (Throwable)iOException);
        }
        finally {
            if (xmlResourceParser != null) {
                xmlResourceParser.close();
            }
        }
    }

    private void parseMenu(XmlResourceParser xmlResourceParser, AttributeSet attributeSet, Menu menu2) throws XmlPullParserException, IOException {
        ParsedItem parsedItem = null;
        int n = xmlResourceParser.getEventType();
        block4: do {
            String string2 = xmlResourceParser.getName();
            switch (n) {
                case 2: {
                    if (string2.equals(TAG_ITEM)) {
                        parsedItem = new ParsedItem();
                        this.parseItem(parsedItem, attributeSet);
                        break;
                    }
                    if (!string2.equals(TAG_MENU) || parsedItem == null) continue block4;
                    MenuItem menuItem = menu2.addSubMenu(0, parsedItem.id, parsedItem.order, parsedItem.title);
                    parsedItem.hasSubMenu = true;
                    MenuItem menuItem2 = menuItem.getItem();
                    this.setValues(parsedItem, menuItem2);
                    this.parseMenu(xmlResourceParser, attributeSet, (Menu)menuItem);
                    break;
                }
                case 3: {
                    MenuItem menuItem;
                    if (xmlResourceParser.getName().equals(TAG_ITEM)) {
                        if (parsedItem.hasSubMenu) break;
                        menuItem = menu2.add(0, parsedItem.id, parsedItem.order, parsedItem.title);
                        this.setValues(parsedItem, menuItem);
                        break;
                    }
                    if (!string2.equals(TAG_MENU)) break;
                    return;
                }
            }
        } while ((n = xmlResourceParser.next()) != 1);
    }

    public void parseItem(ParsedItem parsedItem, AttributeSet attributeSet) {
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attributeSet, R.styleable.MenuItem);
        parsedItem.id = typedArray.getResourceId(2, 0);
        parsedItem.order = typedArray.getInt(5, 0);
        parsedItem.title = typedArray.getText(6);
        parsedItem.iconRes = typedArray.getResourceId(0, 0);
        parsedItem.checkable = typedArray.getBoolean(7, false);
        parsedItem.checked = typedArray.getBoolean(3, false);
        parsedItem.visible = typedArray.getBoolean(4, true);
        parsedItem.enabled = typedArray.getBoolean(1, true);
        parsedItem.hasSubMenu = false;
        if (Build.VERSION.SDK_INT >= 11) {
            parsedItem.showAsAction = typedArray.getInt(8, 0);
        }
        typedArray.recycle();
    }

    public void setValues(ParsedItem parsedItem, MenuItem menuItem) {
        menuItem.setChecked(parsedItem.checked).setVisible(parsedItem.visible).setEnabled(parsedItem.enabled).setCheckable(parsedItem.checkable).setIcon(parsedItem.iconRes);
        if (Build.VERSION.SDK_INT >= 11) {
            menuItem.setShowAsAction(parsedItem.showAsAction);
        }
    }

    private class ParsedItem {
        public int id;
        public int order;
        public CharSequence title;
        public int iconRes;
        public boolean checkable;
        public boolean checked;
        public boolean visible;
        public boolean enabled;
        public int showAsAction;
        public boolean hasSubMenu;

        private ParsedItem() {
        }
    }
}

