/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.parser.ParseException;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NoCollectionKeysSetException;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.crypto.CryptoException;
import org.mozilla.gecko.sync.crypto.KeyBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionKeys {
    private KeyBundle defaultKeyBundle = null;
    private final HashMap<String, KeyBundle> collectionKeyBundles = new HashMap();

    public static CollectionKeys generateCollectionKeys() throws CryptoException {
        CollectionKeys collectionKeys = new CollectionKeys();
        collectionKeys.clear();
        collectionKeys.defaultKeyBundle = KeyBundle.withRandomKeys();
        return collectionKeys;
    }

    public KeyBundle defaultKeyBundle() throws NoCollectionKeysSetException {
        if (this.defaultKeyBundle == null) {
            throw new NoCollectionKeysSetException();
        }
        return this.defaultKeyBundle;
    }

    public boolean keyBundleForCollectionIsNotDefault(String string2) {
        return this.collectionKeyBundles.containsKey(string2);
    }

    public KeyBundle keyBundleForCollection(String string2) throws NoCollectionKeysSetException {
        if (this.defaultKeyBundle == null) {
            throw new NoCollectionKeysSetException();
        }
        if (this.keyBundleForCollectionIsNotDefault(string2)) {
            return this.collectionKeyBundles.get(string2);
        }
        return this.defaultKeyBundle;
    }

    private static KeyBundle arrayToKeyBundle(JSONArray jSONArray) throws UnsupportedEncodingException {
        String string2 = (String)jSONArray.get(0);
        String string3 = (String)jSONArray.get(1);
        return KeyBundle.fromBase64EncodedKeys(string2, string3);
    }

    private static JSONArray keyBundleToArray(KeyBundle keyBundle) {
        JSONArray jSONArray = new JSONArray();
        jSONArray.add((Object)new String(Base64.encodeBase64((byte[])keyBundle.getEncryptionKey())));
        jSONArray.add((Object)new String(Base64.encodeBase64((byte[])keyBundle.getHMACKey())));
        return jSONArray;
    }

    private ExtendedJSONObject asRecordContents() throws NoCollectionKeysSetException {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put("id", "keys");
        extendedJSONObject.put("collection", "crypto");
        extendedJSONObject.put("default", CollectionKeys.keyBundleToArray(this.defaultKeyBundle()));
        ExtendedJSONObject extendedJSONObject2 = new ExtendedJSONObject();
        for (Map.Entry<String, KeyBundle> entry : this.collectionKeyBundles.entrySet()) {
            extendedJSONObject2.put(entry.getKey(), CollectionKeys.keyBundleToArray(entry.getValue()));
        }
        extendedJSONObject.put("collections", extendedJSONObject2);
        return extendedJSONObject;
    }

    public CryptoRecord asCryptoRecord() throws NoCollectionKeysSetException {
        ExtendedJSONObject extendedJSONObject = this.asRecordContents();
        CryptoRecord cryptoRecord = new CryptoRecord(extendedJSONObject);
        cryptoRecord.collection = "crypto";
        cryptoRecord.guid = "keys";
        cryptoRecord.deleted = false;
        return cryptoRecord;
    }

    public void setKeyPairsFromWBO(CryptoRecord cryptoRecord, KeyBundle keyBundle) throws CryptoException, IOException, ParseException, NonObjectJSONException {
        if (cryptoRecord == null) {
            throw new IllegalArgumentException("cannot set key pairs from null record");
        }
        if (keyBundle != null) {
            cryptoRecord.keyBundle = keyBundle;
            cryptoRecord.decrypt();
        }
        ExtendedJSONObject extendedJSONObject = cryptoRecord.payload;
        KeyBundle keyBundle2 = CollectionKeys.arrayToKeyBundle((JSONArray)extendedJSONObject.get("default"));
        ExtendedJSONObject extendedJSONObject2 = extendedJSONObject.getObject("collections");
        HashMap<String, KeyBundle> hashMap = new HashMap<String, KeyBundle>();
        for (Map.Entry<String, Object> entry : extendedJSONObject2.entrySet()) {
            KeyBundle keyBundle3 = CollectionKeys.arrayToKeyBundle((JSONArray)entry.getValue());
            hashMap.put(entry.getKey(), keyBundle3);
        }
        this.collectionKeyBundles.clear();
        this.collectionKeyBundles.putAll(hashMap);
        this.defaultKeyBundle = keyBundle2;
    }

    public void setKeyBundleForCollection(String string2, KeyBundle keyBundle) {
        this.collectionKeyBundles.put(string2, keyBundle);
    }

    public void setDefaultKeyBundle(KeyBundle keyBundle) {
        this.defaultKeyBundle = keyBundle;
    }

    public void clear() {
        this.defaultKeyBundle = null;
        this.collectionKeyBundles.clear();
    }

    public static Set<String> differences(CollectionKeys collectionKeys, CollectionKeys collectionKeys2) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>(collectionKeys.collectionKeyBundles.keySet());
        hashSet2.addAll(collectionKeys2.collectionKeyBundles.keySet());
        for (String string2 : hashSet2) {
            KeyBundle keyBundle;
            KeyBundle keyBundle2;
            try {
                keyBundle2 = collectionKeys.keyBundleForCollection(string2);
                keyBundle = collectionKeys2.keyBundleForCollection(string2);
            }
            catch (NoCollectionKeysSetException noCollectionKeysSetException) {
                hashSet.add(string2);
                continue;
            }
            if (keyBundle2.equals(keyBundle)) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CollectionKeys)) {
            return false;
        }
        CollectionKeys collectionKeys = (CollectionKeys)object;
        try {
            return this.defaultKeyBundle().equals(collectionKeys.defaultKeyBundle()) && CollectionKeys.differences(this, collectionKeys).isEmpty();
        }
        catch (NoCollectionKeysSetException noCollectionKeysSetException) {
            return false;
        }
    }
}

