/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.HTTPFailureException;
import org.mozilla.gecko.sync.delegates.JSONRecordFetchDelegate;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.SyncStorageRecordRequest;
import org.mozilla.gecko.sync.net.SyncStorageRequestDelegate;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

public class JSONRecordFetcher {
    private static final long DEFAULT_AWAIT_TIMEOUT_MSEC = 120000L;
    private static final String LOG_TAG = "JSONRecordFetcher";
    protected final AuthHeaderProvider authHeaderProvider;
    protected final String uri;
    protected JSONRecordFetchDelegate delegate;

    public JSONRecordFetcher(String string2, AuthHeaderProvider authHeaderProvider) {
        if (string2 == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        this.uri = string2;
        this.authHeaderProvider = authHeaderProvider;
    }

    protected String getURI() {
        return this.uri;
    }

    public void fetch(JSONRecordFetchDelegate jSONRecordFetchDelegate) {
        this.delegate = jSONRecordFetchDelegate;
        try {
            SyncStorageRecordRequest syncStorageRecordRequest = new SyncStorageRecordRequest(this.getURI());
            syncStorageRecordRequest.delegate = new JSONFetchHandler();
            syncStorageRecordRequest.get();
        }
        catch (Exception exception) {
            jSONRecordFetchDelegate.handleError(exception);
        }
    }

    public ExtendedJSONObject fetchBlocking() throws HTTPFailureException, Exception {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        LatchedJSONRecordFetchDelegate latchedJSONRecordFetchDelegate = new LatchedJSONRecordFetchDelegate(countDownLatch);
        this.delegate = latchedJSONRecordFetchDelegate;
        this.fetch(latchedJSONRecordFetchDelegate);
        if (!countDownLatch.await(120000L, TimeUnit.MILLISECONDS)) {
            Logger.warn(LOG_TAG, "Interrupted fetching info record.");
            throw new InterruptedException("info fetch timed out.");
        }
        if (latchedJSONRecordFetchDelegate.body != null) {
            return latchedJSONRecordFetchDelegate.body;
        }
        if (latchedJSONRecordFetchDelegate.exception != null) {
            throw latchedJSONRecordFetchDelegate.exception;
        }
        throw new Exception("Unknown error.");
    }

    private class LatchedJSONRecordFetchDelegate
    implements JSONRecordFetchDelegate {
        public ExtendedJSONObject body = null;
        public Exception exception = null;
        private CountDownLatch latch;

        public LatchedJSONRecordFetchDelegate(CountDownLatch countDownLatch) {
            this.latch = countDownLatch;
        }

        public void handleFailure(SyncStorageResponse syncStorageResponse) {
            this.exception = new HTTPFailureException(syncStorageResponse);
            this.latch.countDown();
        }

        public void handleError(Exception exception) {
            this.exception = exception;
            this.latch.countDown();
        }

        public void handleSuccess(ExtendedJSONObject extendedJSONObject) {
            this.body = extendedJSONObject;
            this.latch.countDown();
        }
    }

    private class JSONFetchHandler
    implements SyncStorageRequestDelegate {
        private JSONFetchHandler() {
        }

        public AuthHeaderProvider getAuthHeaderProvider() {
            return JSONRecordFetcher.this.authHeaderProvider;
        }

        public String ifUnmodifiedSince() {
            return null;
        }

        public void handleRequestSuccess(SyncStorageResponse syncStorageResponse) {
            if (syncStorageResponse.wasSuccessful()) {
                try {
                    JSONRecordFetcher.this.delegate.handleSuccess(syncStorageResponse.jsonObjectBody());
                }
                catch (Exception exception) {
                    this.handleRequestError(exception);
                }
                return;
            }
            this.handleRequestFailure(syncStorageResponse);
        }

        public void handleRequestFailure(SyncStorageResponse syncStorageResponse) {
            JSONRecordFetcher.this.delegate.handleFailure(syncStorageResponse);
        }

        public void handleRequestError(Exception exception) {
            JSONRecordFetcher.this.delegate.handleError(exception);
        }
    }
}

