/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.SharedPreferences;
import android.os.Build;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.delegates.ClientsDataDelegate;

public class SharedPreferencesClientsDataDelegate
implements ClientsDataDelegate {
    protected final SharedPreferences sharedPreferences;

    public SharedPreferencesClientsDataDelegate(SharedPreferences sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    public synchronized String getAccountGUID() {
        String string2 = this.sharedPreferences.getString("account.guid", null);
        if (string2 == null) {
            string2 = Utils.generateGuid();
            this.sharedPreferences.edit().putString("account.guid", string2).commit();
        }
        return string2;
    }

    public synchronized String getClientName() {
        String string2 = this.sharedPreferences.getString("account.clientName", null);
        if (string2 == null) {
            string2 = "Nightly on " + Build.MODEL;
            this.sharedPreferences.edit().putString("account.clientName", string2).commit();
        }
        return string2;
    }

    public synchronized void setClientsCount(int n) {
        this.sharedPreferences.edit().putLong("account.numClients", (long)n).commit();
    }

    public boolean isLocalGUID(String string2) {
        return this.getAccountGUID().equals(string2);
    }

    public synchronized int getClientsCount() {
        return (int)this.sharedPreferences.getLong("account.numClients", 0L);
    }
}

