/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.SharedPreferences;
import java.net.URI;
import java.net.URISyntaxException;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.SyncConfigurationException;
import org.mozilla.gecko.sync.delegates.NodeAssignmentCallback;

public class SharedPreferencesNodeAssignmentCallback
implements NodeAssignmentCallback {
    protected final SharedPreferences sharedPreferences;
    protected final String nodeWeaveURL;

    public SharedPreferencesNodeAssignmentCallback(SharedPreferences sharedPreferences, String string2) throws SyncConfigurationException {
        this.sharedPreferences = sharedPreferences;
        if (string2 == null) {
            throw new IllegalArgumentException("nodeWeaveURL must not be null");
        }
        try {
            new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SyncConfigurationException();
        }
        this.nodeWeaveURL = string2;
    }

    public synchronized boolean getClusterURLIsStale() {
        return this.sharedPreferences.getBoolean("clusterurlisstale", false);
    }

    public synchronized void setClusterURLIsStale(boolean bl) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putBoolean("clusterurlisstale", bl);
        editor.commit();
    }

    public boolean wantNodeAssignment() {
        return this.getClusterURLIsStale();
    }

    public void informNodeAuthenticationFailed(GlobalSession globalSession, URI uRI) {
        this.setClusterURLIsStale(false);
    }

    public void informNodeAssigned(GlobalSession globalSession, URI uRI, URI uRI2) {
        this.setClusterURLIsStale(false);
    }

    public String nodeWeaveURL() {
        return this.nodeWeaveURL;
    }
}

