/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.config;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.Context;
import android.content.SharedPreferences;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationMigrator {
    public static final String LOG_TAG = "ConfigMigrator";
    protected static final String V0_PREF_CLUSTER_URL_IS_STALE = "clusterurlisstale";
    protected static final String V1_PREF_CLUSTER_URL_IS_STALE = "clusterurlisstale";
    protected static final String V0_PREF_EARLIEST_NEXT_SYNC = "earliestnextsync";
    protected static final String V1_PREF_EARLIEST_NEXT_SYNC = "earliestnextsync";
    protected static final String V0_PREF_ACCOUNT_GUID = "account.guid";
    protected static final String V1_PREF_ACCOUNT_GUID = "account.guid";
    protected static final String V0_PREF_CLIENT_NAME = "account.clientName";
    protected static final String V1_PREF_CLIENT_NAME = "account.clientName";
    protected static final String V0_PREF_NUM_CLIENTS = "account.numClients";
    protected static final String V1_PREF_NUM_CLIENTS = "account.numClients";

    protected static int copyPreferences(SharedPreferences sharedPreferences, Map<String, String> map, SharedPreferences.Editor editor) {
        int n = 0;
        for (Map.Entry entry : sharedPreferences.getAll().entrySet()) {
            String string2 = (String)entry.getKey();
            String string3 = map.get(string2);
            if (string3 == null) continue;
            Object v = entry.getValue();
            if (v instanceof Boolean) {
                editor.putBoolean(string3, ((Boolean)v).booleanValue());
            } else if (v instanceof Float) {
                editor.putFloat(string3, ((Float)v).floatValue());
            } else if (v instanceof Integer) {
                editor.putInt(string3, ((Integer)v).intValue());
            } else if (v instanceof Long) {
                editor.putLong(string3, ((Long)v).longValue());
            } else if (v instanceof String) {
                editor.putString(string3, (String)v);
            }
            if (Logger.LOG_PERSONAL_INFORMATION) {
                Logger.debug(LOG_TAG, "Migrated '" + string2 + "' to '" + string3 + "' (" + v + ").");
            } else {
                Logger.debug(LOG_TAG, "Migrated '" + string2 + "' to '" + string3 + "'.");
            }
            ++n;
        }
        return n;
    }

    protected static int upgradeGlobals0to1(SharedPreferences sharedPreferences, SharedPreferences sharedPreferences2) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("clusterurlisstale", "clusterurlisstale");
        hashMap.put("earliestnextsync", "earliestnextsync");
        SharedPreferences.Editor editor = sharedPreferences2.edit();
        int n = ConfigurationMigrator.copyPreferences(sharedPreferences, hashMap, editor);
        if (n > 0) {
            editor.commit();
        }
        return n;
    }

    protected static int downgradeGlobals1to0(SharedPreferences sharedPreferences, SharedPreferences sharedPreferences2) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("clusterurlisstale", "clusterurlisstale");
        hashMap.put("earliestnextsync", "earliestnextsync");
        SharedPreferences.Editor editor = sharedPreferences2.edit();
        int n = ConfigurationMigrator.copyPreferences(sharedPreferences, hashMap, editor);
        if (n > 0) {
            editor.commit();
        }
        return n;
    }

    protected static int upgradeAndroidAccount0to1(AccountManager accountManager, Account account, SharedPreferences sharedPreferences) throws Exception {
        String string2 = null;
        String string3 = null;
        long l = -1L;
        try {
            string2 = accountManager.getUserData(account, "account.guid");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            string3 = accountManager.getUserData(account, "account.clientName");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            l = Long.parseLong(accountManager.getUserData(account, "account.numClients"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        SharedPreferences.Editor editor = sharedPreferences.edit();
        int n = 0;
        if (string2 != null) {
            if (Logger.LOG_PERSONAL_INFORMATION) {
                Logger.debug(LOG_TAG, "Migrated 'account.guid' to 'account.guid' (" + string2 + ").");
            } else {
                Logger.debug(LOG_TAG, "Migrated 'account.guid' to 'account.guid'.");
            }
            editor.putString("account.guid", string2);
            ++n;
        }
        if (string3 != null) {
            if (Logger.LOG_PERSONAL_INFORMATION) {
                Logger.debug(LOG_TAG, "Migrated 'account.clientName' to 'account.clientName' (" + string3 + ").");
            } else {
                Logger.debug(LOG_TAG, "Migrated 'account.clientName' to 'account.clientName'.");
            }
            editor.putString("account.clientName", string3);
            ++n;
        }
        if (l > -1L) {
            if (Logger.LOG_PERSONAL_INFORMATION) {
                Logger.debug(LOG_TAG, "Migrated 'account.numClients' to 'account.numClients' (" + l + ").");
            } else {
                Logger.debug(LOG_TAG, "Migrated 'account.numClients' to 'account.numClients'.");
            }
            editor.putLong("account.numClients", l);
            ++n;
        }
        if (n > 0) {
            editor.commit();
        }
        return n;
    }

    protected static int downgradeAndroidAccount1to0(SharedPreferences sharedPreferences, AccountManager accountManager, Account account) throws Exception {
        String string2 = sharedPreferences.getString("account.guid", null);
        String string3 = sharedPreferences.getString("account.clientName", null);
        long l = sharedPreferences.getLong("account.numClients", -1L);
        int n = 0;
        if (string2 != null) {
            Logger.debug(LOG_TAG, "Migrated account GUID.");
            accountManager.setUserData(account, "account.guid", string2);
            ++n;
        }
        if (string3 != null) {
            Logger.debug(LOG_TAG, "Migrated client name.");
            accountManager.setUserData(account, "account.clientName", string3);
            ++n;
        }
        if (l > -1L) {
            Logger.debug(LOG_TAG, "Migrated clients count.");
            accountManager.setUserData(account, "account.numClients", new Long(l).toString());
            ++n;
        }
        return n;
    }

    protected static int upgradeShared0to1(SharedPreferences sharedPreferences, SharedPreferences sharedPreferences2) {
        SharedPreferences.Editor editor;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : editor = new SharedPreferences.Editor[]{"syncID", "clusterURL", "enabledEngineNames", "metaGlobalLastModified", "metaGlobalServerResponseBody", "crypto5KeysLastModified", "crypto5KeysServerResponseBody", "serverClientsTimestamp", "serverClientRecordTimestamp", "forms.remote", "forms.local", "forms.syncID", "tabs.remote", "tabs.local", "tabs.syncID", "passwords.remote", "passwords.local", "passwords.syncID", "history.remote", "history.local", "history.syncID", "bookmarks.remote", "bookmarks.local", "bookmarks.syncID"}) {
            hashMap.put(string2, string2);
        }
        SharedPreferences.Editor editor2 = sharedPreferences2.edit();
        int n = ConfigurationMigrator.copyPreferences(sharedPreferences, hashMap, editor2);
        if (n > 0) {
            editor2.commit();
        }
        return n;
    }

    protected static int downgradeShared1to0(SharedPreferences sharedPreferences, SharedPreferences sharedPreferences2) {
        return ConfigurationMigrator.upgradeShared0to1(sharedPreferences, sharedPreferences2);
    }

    public static void upgrade0to1(Context context, AccountManager accountManager, Account account, String string2, String string3, String string4, String string5) throws Exception {
        SharedPreferences sharedPreferences = context.getSharedPreferences("sync.prefs.global", 0);
        SharedPreferences sharedPreferences2 = Utils.getSharedPreferences(context, string2, string3, string4, string5, 0L);
        SharedPreferences sharedPreferences3 = Utils.getSharedPreferences(context, string2, string3, string4, string5, 1L);
        ConfigurationMigrator.upgradeGlobals0to1(sharedPreferences, sharedPreferences3);
        ConfigurationMigrator.upgradeAndroidAccount0to1(accountManager, account, sharedPreferences3);
        ConfigurationMigrator.upgradeShared0to1(sharedPreferences2, sharedPreferences3);
    }

    public static void downgrade1to0(Context context, AccountManager accountManager, Account account, String string2, String string3, String string4, String string5) throws Exception {
        SharedPreferences sharedPreferences = context.getSharedPreferences("sync.prefs.global", 0);
        SharedPreferences sharedPreferences2 = Utils.getSharedPreferences(context, string2, string3, string4, string5, 0L);
        SharedPreferences sharedPreferences3 = Utils.getSharedPreferences(context, string2, string3, string4, string5, 1L);
        ConfigurationMigrator.downgradeGlobals1to0(sharedPreferences3, sharedPreferences);
        ConfigurationMigrator.downgradeAndroidAccount1to0(sharedPreferences3, accountManager, account);
        ConfigurationMigrator.downgradeShared1to0(sharedPreferences3, sharedPreferences2);
    }

    public static void ensurePrefsAreVersion(long l, Context context, AccountManager accountManager, Account account, String string2, String string3, String string4, String string5) throws Exception {
        if (l < 0L || l > 1L) {
            throw new IllegalArgumentException("Cannot migrate to unknown version " + l + ".");
        }
        SharedPreferences sharedPreferences = context.getSharedPreferences("sync.prefs.version", 0);
        long l2 = sharedPreferences.getLong("prefs.version", 0L);
        if (l2 == l) {
            Logger.info(LOG_TAG, "Current version (" + l2 + ") is desired version; no need to migrate.");
            return;
        }
        if (l2 < 0L || l2 > 1L) {
            throw new IllegalStateException("Cannot migrate from unknown version " + l2 + ".");
        }
        if (l2 == 0L && l == 1L) {
            Logger.info(LOG_TAG, "Upgrading from version 0 to version 1.");
            ConfigurationMigrator.upgrade0to1(context, accountManager, account, string2, string3, string4, string5);
        } else if (l2 == 1L && l == 0L) {
            Logger.info(LOG_TAG, "Upgrading from version 0 to version 1.");
            ConfigurationMigrator.upgrade0to1(context, accountManager, account, string2, string3, string4, string5);
        } else {
            Logger.warn(LOG_TAG, "Don't know how to migrate from version " + l2 + " to " + l + ".");
        }
        Logger.info(LOG_TAG, "Migrated from version " + l2 + " to version " + l + ".");
        sharedPreferences.edit().putLong("prefs.version", l).commit();
    }
}

