/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.jpake.stage;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.jpake.BigIntegerHelper;
import org.mozilla.gecko.sync.jpake.JPakeClient;
import org.mozilla.gecko.sync.jpake.JPakeCrypto;
import org.mozilla.gecko.sync.jpake.JPakeJson;
import org.mozilla.gecko.sync.jpake.JPakeParty;
import org.mozilla.gecko.sync.jpake.Zkp;
import org.mozilla.gecko.sync.jpake.stage.JPakeStage;

public class ComputeStepOneStage
extends JPakeStage {
    public void execute(JPakeClient jPakeClient) {
        Logger.debug("SyncJPakeStage", "Computing round 1.");
        JPakeParty jPakeParty = jPakeClient.jParty;
        try {
            JPakeCrypto.round1(jPakeParty, jPakeClient.numGen);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Logger.error("SyncJPakeStage", "No such algorithm.", noSuchAlgorithmException);
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.error("SyncJPakeStage", "Unsupported encoding.", unsupportedEncodingException);
            jPakeClient.abort("jpake.error.invalid");
            return;
        }
        catch (Exception exception) {
            Logger.error("SyncJPakeStage", "Unexpected exception.", exception);
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put("gx1", BigIntegerHelper.toEvenLengthHex(jPakeParty.gx1));
        extendedJSONObject.put("gx2", BigIntegerHelper.toEvenLengthHex(jPakeParty.gx2));
        Zkp zkp = jPakeParty.zkp1;
        Zkp zkp2 = jPakeParty.zkp2;
        ExtendedJSONObject extendedJSONObject2 = JPakeJson.makeJZkp(zkp.gr, zkp.b, jPakeClient.mySignerId);
        ExtendedJSONObject extendedJSONObject3 = JPakeJson.makeJZkp(zkp2.gr, zkp2.b, jPakeClient.mySignerId);
        extendedJSONObject.put("zkp_x1", extendedJSONObject2);
        extendedJSONObject.put("zkp_x2", extendedJSONObject3);
        jPakeClient.jOutgoing = new ExtendedJSONObject();
        jPakeClient.jOutgoing.put("type", jPakeClient.mySignerId + "1");
        jPakeClient.jOutgoing.put("payload", extendedJSONObject);
        jPakeClient.jOutgoing.put("version", 3);
        Logger.debug("SyncJPakeStage", "Sending: " + jPakeClient.jOutgoing.toJSONString());
        jPakeClient.runNextStage();
    }
}

