/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.domain;

import java.io.UnsupportedEncodingException;
import org.mozilla.gecko.sync.CryptoRecord;
import org.mozilla.gecko.sync.ExtendedJSONObject;

public abstract class Record {
    public String guid;
    public String collection;
    public long lastModified;
    public boolean deleted;
    public long androidID;
    public long sortIndex;
    public long ttl;

    public Record(String string2, String string3, long l, boolean bl) {
        this.guid = string2;
        this.collection = string3;
        this.lastModified = l;
        this.deleted = bl;
        this.sortIndex = 0L;
        this.ttl = 31536000L;
        this.androidID = -1L;
    }

    public boolean equalIdentifiers(Object object) {
        if (object == null || !(object instanceof Record)) {
            return false;
        }
        Record record = (Record)object;
        if (this.guid == null ? record.guid != null : !this.guid.equals(record.guid)) {
            return false;
        }
        return !(this.collection == null ? record.collection != null : !this.collection.equals(record.collection));
    }

    public boolean equalPayloads(Object object) {
        if (!this.equalIdentifiers(object)) {
            return false;
        }
        Record record = (Record)object;
        return this.deleted == record.deleted;
    }

    public boolean congruentWith(Object object) {
        if (!this.equalIdentifiers(object)) {
            return false;
        }
        Record record = (Record)object;
        return this.congruentAndroidIDs(record) && this.deleted == record.deleted;
    }

    public boolean congruentAndroidIDs(Record record) {
        return this.androidID == -1L || record.androidID == -1L || this.androidID == record.androidID;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Record)) {
            return false;
        }
        Record record = (Record)object;
        return this.equalTimestamps(record) && this.equalSortIndices(record) && this.equalAndroidIDs(record) && this.equalPayloads(object);
    }

    public boolean equalAndroidIDs(Record record) {
        return this.androidID == record.androidID;
    }

    public boolean equalSortIndices(Record record) {
        return this.sortIndex == record.sortIndex;
    }

    public boolean equalTimestamps(Object object) {
        if (object == null || !(object instanceof Record)) {
            return false;
        }
        return ((Record)object).lastModified == this.lastModified;
    }

    protected abstract void populatePayload(ExtendedJSONObject var1);

    protected abstract void initFromPayload(ExtendedJSONObject var1);

    public void initFromEnvelope(CryptoRecord cryptoRecord) {
        ExtendedJSONObject extendedJSONObject = cryptoRecord.payload;
        this.guid = cryptoRecord.guid;
        this.checkGUIDs(extendedJSONObject);
        this.collection = cryptoRecord.collection;
        this.lastModified = cryptoRecord.lastModified;
        Object object = extendedJSONObject.get("deleted");
        if (object instanceof Boolean) {
            this.deleted = (Boolean)object;
        } else {
            this.initFromPayload(extendedJSONObject);
        }
    }

    public CryptoRecord getEnvelope() {
        CryptoRecord cryptoRecord = new CryptoRecord(this);
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put("id", this.guid);
        if (this.deleted) {
            extendedJSONObject.put("deleted", true);
        } else {
            this.populatePayload(extendedJSONObject);
        }
        cryptoRecord.payload = extendedJSONObject;
        return cryptoRecord;
    }

    public String toJSONString() {
        throw new RuntimeException("Cannot JSONify non-CryptoRecord Records.");
    }

    public byte[] toJSONBytes() {
        try {
            return this.toJSONString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    protected void putPayload(CryptoRecord cryptoRecord, String string2, String string3) {
        if (string3 == null) {
            return;
        }
        cryptoRecord.payload.put(string2, string3);
    }

    protected void putPayload(ExtendedJSONObject extendedJSONObject, String string2, String string3) {
        this.putPayload(extendedJSONObject, string2, string3, false);
    }

    protected void putPayload(ExtendedJSONObject extendedJSONObject, String string2, String string3, boolean bl) {
        if (string3 == null) {
            return;
        }
        if (bl && string3.equals("")) {
            return;
        }
        extendedJSONObject.put(string2, string3);
    }

    protected void checkGUIDs(ExtendedJSONObject extendedJSONObject) {
        String string2 = (String)extendedJSONObject.get("id");
        if (this.guid == null || string2 == null) {
            String string3 = "Inconsistency: either envelope or payload GUID missing.";
            throw new IllegalStateException(string3);
        }
        if (!this.guid.equals(string2)) {
            String string4 = "Inconsistency: record has envelope ID " + this.guid + ", payload ID " + string2;
            throw new IllegalStateException(string4);
        }
    }

    public abstract Record copyWithIDs(String var1, long var2);
}

