/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.activities;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorActivity;
import android.accounts.AccountManager;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Toast;
import java.util.Locale;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ThreadPool;
import org.mozilla.gecko.sync.setup.InvalidSyncKeyException;
import org.mozilla.gecko.sync.setup.SyncAccounts;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;
import org.mozilla.gecko.sync.setup.activities.SetupFailureActivity;
import org.mozilla.gecko.sync.setup.activities.SetupSuccessActivity;
import org.mozilla.gecko.sync.setup.auth.AccountAuthenticator;
import org.mozilla.gecko.sync.setup.auth.AuthenticationResult;

public class AccountActivity
extends AccountAuthenticatorActivity {
    private static final String LOG_TAG = "AccountActivity";
    private AccountManager mAccountManager;
    private Context mContext;
    private String username;
    private String password;
    private String key;
    private String server = "https://auth.services.mozilla.com/";
    private EditText serverInput;
    private EditText usernameInput;
    private EditText passwordInput;
    private EditText synckeyInput;
    private CheckBox serverCheckbox;
    private Button connectButton;
    private Button cancelButton;
    private ProgressDialog progressDialog;
    private AccountAuthenticator accountAuthenticator;

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.sync_account);
        ActivityUtils.prepareLogging();
        this.mContext = this.getApplicationContext();
        Logger.debug(LOG_TAG, "AccountManager.get(" + this.mContext + ")");
        this.mAccountManager = AccountManager.get((Context)this.mContext);
        Logger.debug(LOG_TAG, "Setting screen-on flag.");
        Window window = this.getWindow();
        window.addFlags(128);
        this.usernameInput = (EditText)this.findViewById(R.id.usernameInput);
        this.passwordInput = (EditText)this.findViewById(R.id.passwordInput);
        this.synckeyInput = (EditText)this.findViewById(R.id.keyInput);
        this.serverInput = (EditText)this.findViewById(R.id.serverInput);
        TextWatcher textWatcher = this.makeInputValidator();
        this.usernameInput.addTextChangedListener(textWatcher);
        this.passwordInput.addTextChangedListener(textWatcher);
        this.synckeyInput.addTextChangedListener(textWatcher);
        this.serverInput.addTextChangedListener(textWatcher);
        this.connectButton = (Button)this.findViewById(R.id.accountConnectButton);
        this.cancelButton = (Button)this.findViewById(R.id.accountCancelButton);
        this.serverCheckbox = (CheckBox)this.findViewById(R.id.checkbox_server);
        this.serverCheckbox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                Logger.info(AccountActivity.LOG_TAG, "Toggling checkbox: " + bl);
                if (!bl) {
                    AccountActivity.this.serverInput.setVisibility(8);
                    AccountActivity.this.findViewById(R.id.server_error).setVisibility(8);
                    AccountActivity.this.serverInput.setText((CharSequence)"");
                } else {
                    AccountActivity.this.serverInput.setVisibility(0);
                    AccountActivity.this.serverInput.setEnabled(true);
                }
                AccountActivity.this.activateView((View)AccountActivity.this.connectButton, AccountActivity.this.validateInputs());
            }
        });
    }

    public void onResume() {
        super.onResume();
        ActivityUtils.prepareLogging();
        this.clearCredentials();
        this.usernameInput.requestFocus();
        this.cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AccountActivity.this.cancelClickHandler(view);
            }
        });
    }

    public void cancelClickHandler(View view) {
        this.finish();
    }

    public void cancelConnectHandler(View view) {
        if (this.accountAuthenticator != null) {
            this.accountAuthenticator.isCanceled = true;
            this.accountAuthenticator = null;
        }
        this.displayVerifying(false);
        this.activateView((View)this.connectButton, true);
        this.clearCredentials();
        this.usernameInput.requestFocus();
    }

    private void clearCredentials() {
        this.passwordInput.setText((CharSequence)"");
    }

    public void connectClickHandler(View view) {
        String string2;
        Logger.debug(LOG_TAG, "connectClickHandler for view " + view);
        try {
            this.key = ActivityUtils.validateSyncKey(this.synckeyInput.getText().toString());
        }
        catch (InvalidSyncKeyException invalidSyncKeyException) {
            Toast toast = Toast.makeText((Context)this.mContext, (int)R.string.sync_new_recoverykey_status_incorrect, (int)1);
            toast.show();
            return;
        }
        this.username = this.usernameInput.getText().toString().toLowerCase(Locale.US);
        this.password = this.passwordInput.getText().toString();
        this.key = this.synckeyInput.getText().toString();
        this.server = "https://auth.services.mozilla.com/";
        if (this.serverCheckbox.isChecked() && (string2 = this.serverInput.getText().toString()) != null && (string2 = string2.trim()).length() != 0) {
            if (!string2.startsWith("https://") && !string2.startsWith("http://")) {
                string2 = "https://" + string2;
                this.serverInput.setText((CharSequence)string2);
            }
            this.server = string2;
        }
        this.clearErrors();
        this.displayVerifying(true);
        this.cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AccountActivity.this.cancelConnectHandler(view);
                AccountActivity.this.cancelButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        AccountActivity.this.cancelClickHandler(view);
                    }
                });
            }
        });
        this.accountAuthenticator = new AccountAuthenticator(this);
        this.accountAuthenticator.authenticate(this.server, this.username, this.password);
    }

    private TextWatcher makeInputValidator() {
        return new TextWatcher(){

            public void afterTextChanged(Editable editable) {
                AccountActivity.this.activateView((View)AccountActivity.this.connectButton, AccountActivity.this.validateInputs());
            }

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }
        };
    }

    private boolean validateInputs() {
        return this.usernameInput.length() != 0 && this.passwordInput.length() != 0 && this.synckeyInput.length() != 0 && (!this.serverCheckbox.isChecked() || this.serverInput.length() != 0);
    }

    public void authCallback(AuthenticationResult authenticationResult) {
        this.displayVerifying(false);
        if (authenticationResult != AuthenticationResult.SUCCESS) {
            Logger.debug(LOG_TAG, "displayFailure()");
            this.displayFailure(authenticationResult);
            return;
        }
        SyncAccounts.SyncAccountParameters syncAccountParameters = new SyncAccounts.SyncAccountParameters(this.mContext, this.mAccountManager, this.username, this.key, this.password, this.server);
        this.createAccountOnThread(syncAccountParameters);
    }

    private void createAccountOnThread(final SyncAccounts.SyncAccountParameters syncAccountParameters) {
        ThreadPool.run(new Runnable(){

            public void run() {
                boolean bl;
                Account account = SyncAccounts.createSyncAccount(syncAccountParameters);
                boolean bl2 = bl = account != null;
                if (!bl) {
                    AccountActivity.this.setResult(0);
                    AccountActivity.this.runOnUiThread(new Runnable(){

                        public void run() {
                            AccountActivity.this.displayFailure(AuthenticationResult.FAILURE_ACCOUNT);
                        }
                    });
                    return;
                }
                AccountActivity.this.clearErrors();
                Bundle bundle = new Bundle();
                bundle.putString("authAccount", syncAccountParameters.username);
                bundle.putString("accountType", "org.mozilla.fennec_sync");
                bundle.putString("authtoken", "org.mozilla.fennec_sync");
                AccountActivity.this.setAccountAuthenticatorResult(bundle);
                AccountActivity.this.setResult(-1);
                AccountActivity.this.runOnUiThread(new Runnable(){

                    public void run() {
                        AccountActivity.this.authSuccess();
                    }
                });
            }
        });
    }

    private void displayVerifying(boolean bl) {
        if (bl) {
            this.progressDialog = ProgressDialog.show((Context)this, (CharSequence)"", (CharSequence)this.getString(R.string.sync_verifying_label), (boolean)true);
        } else {
            this.progressDialog.dismiss();
        }
    }

    private void displayFailure(final AuthenticationResult authenticationResult) {
        this.runOnUiThread(new Runnable(){

            public void run() {
                switch (authenticationResult) {
                    case FAILURE_USERNAME: 
                    case FAILURE_PASSWORD: {
                        AccountActivity.this.findViewById(R.id.cred_error).setVisibility(0);
                        AccountActivity.this.usernameInput.requestFocus();
                        break;
                    }
                    case FAILURE_SERVER: {
                        AccountActivity.this.findViewById(R.id.server_error).setVisibility(0);
                        AccountActivity.this.serverInput.requestFocus();
                        break;
                    }
                    case FAILURE_ACCOUNT: {
                        Intent intent = new Intent(AccountActivity.this.mContext, SetupFailureActivity.class);
                        intent.setFlags(196608);
                        intent.putExtra("isAccountError", true);
                        AccountActivity.this.startActivity(intent);
                        break;
                    }
                    default: {
                        Logger.debug(AccountActivity.LOG_TAG, "displaying default failure.");
                        Intent intent = new Intent(AccountActivity.this.mContext, SetupFailureActivity.class);
                        intent.setFlags(196608);
                        AccountActivity.this.startActivity(intent);
                    }
                }
            }
        });
    }

    public void authSuccess() {
        Intent intent = new Intent(this.mContext, SetupSuccessActivity.class);
        intent.setFlags(196608);
        this.startActivity(intent);
        this.finish();
    }

    private void activateView(View view, boolean bl) {
        view.setEnabled(bl);
        view.setClickable(bl);
    }

    private void clearErrors() {
        this.runOnUiThread(new Runnable(){

            public void run() {
                AccountActivity.this.findViewById(R.id.cred_error).setVisibility(8);
                AccountActivity.this.findViewById(R.id.server_error).setVisibility(8);
            }
        });
    }
}

