/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.activities;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.CommandProcessor;
import org.mozilla.gecko.sync.CommandRunner;
import org.mozilla.gecko.sync.GlobalSession;
import org.mozilla.gecko.sync.repositories.NullCursorException;
import org.mozilla.gecko.sync.repositories.android.ClientsDatabaseAccessor;
import org.mozilla.gecko.sync.repositories.domain.ClientRecord;
import org.mozilla.gecko.sync.setup.SyncAccounts;
import org.mozilla.gecko.sync.setup.activities.ActivityUtils;
import org.mozilla.gecko.sync.setup.activities.ClientRecordArrayAdapter;
import org.mozilla.gecko.sync.setup.activities.RedirectToSetupActivity;
import org.mozilla.gecko.sync.setup.activities.SendTabData;
import org.mozilla.gecko.sync.syncadapter.SyncAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendTabActivity
extends Activity {
    public static final String LOG_TAG = "SendTabActivity";
    private ClientRecordArrayAdapter arrayAdapter;
    private AccountManager accountManager;
    private Account localAccount;
    private SendTabData sendTabData;

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        try {
            this.sendTabData = SendTabActivity.getSendTabData(this.getIntent());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.notifyAndFinish(false);
            return;
        }
        this.setContentView(R.layout.sync_send_tab);
        ListView listView = (ListView)this.findViewById(R.id.device_list);
        listView.setItemsCanFocus(true);
        listView.setTextFilterEnabled(true);
        listView.setChoiceMode(2);
        this.arrayAdapter = new ClientRecordArrayAdapter((Context)this, R.layout.sync_list_item);
        listView.setAdapter((ListAdapter)this.arrayAdapter);
        TextView textView = (TextView)this.findViewById(R.id.title);
        textView.setText((CharSequence)this.sendTabData.title);
        textView = (TextView)this.findViewById(R.id.uri);
        textView.setText((CharSequence)this.sendTabData.uri);
        this.enableSend(false);
        this.updateClientList();
    }

    protected static SendTabData getSendTabData(Intent intent) throws IllegalArgumentException {
        if (intent == null) {
            Logger.warn(LOG_TAG, "intent was null; aborting without sending tab.");
            throw new IllegalArgumentException();
        }
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            Logger.warn(LOG_TAG, "extras was null; aborting without sending tab.");
            throw new IllegalArgumentException();
        }
        SendTabData sendTabData = SendTabData.fromBundle(bundle);
        if (sendTabData == null) {
            Logger.warn(LOG_TAG, "send tab data was null; aborting without sending tab.");
            throw new IllegalArgumentException();
        }
        if (sendTabData.uri == null) {
            Logger.warn(LOG_TAG, "uri was null; aborting without sending tab.");
            throw new IllegalArgumentException();
        }
        if (sendTabData.title == null) {
            Logger.warn(LOG_TAG, "title was null; ignoring and sending tab anyway.");
        }
        return sendTabData;
    }

    protected synchronized void updateClientList() {
        new AsyncTask<Void, Void, Collection<ClientRecord>>(){

            protected Collection<ClientRecord> doInBackground(Void ... voidArray) {
                return SendTabActivity.this.getOtherClients();
            }

            protected void onPostExecute(Collection<ClientRecord> collection) {
                Logger.debug(SendTabActivity.LOG_TAG, "Got " + collection.size() + " clients.");
                SendTabActivity.this.arrayAdapter.setClientRecordList(collection);
                if (collection.size() == 1) {
                    SendTabActivity.this.arrayAdapter.checkItem(0, true);
                }
                SendTabActivity.this.enableSend(SendTabActivity.this.arrayAdapter.getNumCheckedGUIDs() > 0);
            }
        }.execute((Object[])new Void[0]);
    }

    public void onResume() {
        ActivityUtils.prepareLogging();
        Logger.info(LOG_TAG, "Called SendTabActivity.onResume.");
        super.onResume();
        this.redirectIfNoSyncAccount();
        SendTabActivity.registerDisplayURICommand();
    }

    private static void registerDisplayURICommand() {
        CommandProcessor commandProcessor = CommandProcessor.getProcessor();
        commandProcessor.registerCommand("displayURI", new CommandRunner(3){

            @Override
            public void executeCommand(GlobalSession globalSession, List<String> list) {
                CommandProcessor.displayURI(list, globalSession.getContext());
            }
        });
    }

    private void redirectIfNoSyncAccount() {
        this.accountManager = AccountManager.get((Context)this.getApplicationContext());
        Account[] accountArray = this.accountManager.getAccountsByType("org.mozilla.fennec_sync");
        if (accountArray.length > 0) {
            this.localAccount = accountArray[0];
            return;
        }
        Intent intent = new Intent((Context)this, RedirectToSetupActivity.class);
        intent.setFlags(196608);
        this.startActivity(intent);
        this.finish();
    }

    private String getAccountGUID() {
        if (this.localAccount == null) {
            Logger.warn(LOG_TAG, "Null local account; aborting.");
            return null;
        }
        try {
            SharedPreferences sharedPreferences = SyncAccounts.blockingPrefsFromDefaultProfileV0((Context)this, this.accountManager, this.localAccount);
            return sharedPreferences.getString("account.guid", null);
        }
        catch (Exception exception) {
            Logger.warn(LOG_TAG, "Could not get Sync account parameters or preferences; aborting.");
            return null;
        }
    }

    public void sendClickHandler(View view) {
        Logger.info(LOG_TAG, "Send was clicked.");
        final List<String> list = this.arrayAdapter.getCheckedGUIDs();
        if (list == null) {
            Logger.warn(LOG_TAG, "guids was null; aborting without sending tab.");
            this.notifyAndFinish(false);
            return;
        }
        new AsyncTask<Void, Void, Boolean>(){

            protected Boolean doInBackground(Void ... voidArray) {
                CommandProcessor commandProcessor = CommandProcessor.getProcessor();
                String string2 = SendTabActivity.this.getAccountGUID();
                Logger.debug(SendTabActivity.LOG_TAG, "Retrieved local account GUID '" + string2 + "'.");
                if (string2 == null) {
                    return false;
                }
                for (String string3 : list) {
                    commandProcessor.sendURIToClientForDisplay(((SendTabActivity)SendTabActivity.this).sendTabData.uri, string3, ((SendTabActivity)SendTabActivity.this).sendTabData.title, string2, SendTabActivity.this.getApplicationContext());
                }
                Logger.info(SendTabActivity.LOG_TAG, "Requesting immediate clients stage sync.");
                SyncAdapter.requestImmediateSync(SendTabActivity.this.localAccount, new String[]{"clients"});
                return true;
            }

            protected void onPostExecute(Boolean bl) {
                SendTabActivity.this.notifyAndFinish(bl);
            }
        }.execute((Object[])new Void[0]);
    }

    protected void notifyAndFinish(boolean bl) {
        int n = bl ? R.string.sync_text_tab_sent : R.string.sync_text_tab_not_sent;
        Toast.makeText((Context)this, (int)n, (int)1).show();
        this.finish();
    }

    public void enableSend(boolean bl) {
        View view = this.findViewById(R.id.send_button);
        view.setEnabled(bl);
        view.setClickable(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ClientRecord> getAllClients() {
        ClientsDatabaseAccessor clientsDatabaseAccessor = new ClientsDatabaseAccessor(this.getApplicationContext());
        try {
            Map<String, ClientRecord> map = clientsDatabaseAccessor.fetchAllClients();
            return map;
        }
        catch (NullCursorException nullCursorException) {
            Logger.warn(LOG_TAG, "NullCursorException while populating device list.", nullCursorException);
            Map<String, ClientRecord> map = null;
            return map;
        }
        finally {
            clientsDatabaseAccessor.close();
        }
    }

    protected Collection<ClientRecord> getOtherClients() {
        Map<String, ClientRecord> map = this.getAllClients();
        if (map == null) {
            return new ArrayList<ClientRecord>(0);
        }
        String string2 = this.getAccountGUID();
        if (string2 == null) {
            return map.values();
        }
        ArrayList<ClientRecord> arrayList = new ArrayList<ClientRecord>(map.size());
        for (Map.Entry<String, ClientRecord> entry : map.entrySet()) {
            if (string2.equals(entry.getKey())) continue;
            arrayList.add(entry.getValue());
        }
        return arrayList;
    }
}

