/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.setup.activities;

import android.util.Patterns;
import android.webkit.URLUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebURLFinder {
    public final List<String> candidates;

    public WebURLFinder(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("string must not be null");
        }
        this.candidates = WebURLFinder.candidateWebURLs(string2);
    }

    public WebURLFinder(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("strings must not be null");
        }
        this.candidates = WebURLFinder.candidateWebURLs(list);
    }

    public static boolean isWebURL(String string2) {
        try {
            new URI(string2);
        }
        catch (Exception exception) {
            return false;
        }
        return !URLUtil.isFileUrl((String)string2) && !URLUtil.isJavaScriptUrl((String)string2);
    }

    public String bestWebURL() {
        String string2 = this.firstWebURLWithScheme();
        if (string2 != null) {
            return string2;
        }
        return this.firstWebURLWithoutScheme();
    }

    protected static List<String> candidateWebURLs(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : collection) {
            if (string2 == null) continue;
            arrayList.addAll(WebURLFinder.candidateWebURLs(string2));
        }
        return arrayList;
    }

    protected static List<String> candidateWebURLs(String string2) {
        Matcher matcher = Patterns.WEB_URL.matcher(string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (matcher.find()) {
            if (!WebURLFinder.isWebURL(matcher.group()) || matcher.start() > 0 && string2.charAt(matcher.start() - 1) == '@') continue;
            linkedList.add(matcher.group());
        }
        return linkedList;
    }

    protected String firstWebURLWithScheme() {
        for (String string2 : this.candidates) {
            try {
                if (new URI(string2).getScheme() == null) continue;
                return string2;
            }
            catch (URISyntaxException uRISyntaxException) {
            }
        }
        return null;
    }

    protected String firstWebURLWithoutScheme() {
        if (!this.candidates.isEmpty()) {
            return this.candidates.get(0);
        }
        return null;
    }
}

