/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.os.Build;

public class CanvasDelegate {
    Paint mPaint;
    PorterDuffXfermode mMode;
    DrawManager mDrawManager;

    public CanvasDelegate(DrawManager drawManager, PorterDuff.Mode mode) {
        this.mDrawManager = drawManager;
        this.mMode = new PorterDuffXfermode(mode);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(-65536);
        this.mPaint.setStrokeWidth(0.0f);
    }

    public void draw(Canvas canvas, Path path, int n, int n2) {
        int n3 = canvas.saveLayer(0.0f, 0.0f, (float)n, (float)n2, null, 31);
        this.mDrawManager.defaultDraw(canvas);
        if (path != null && !path.isEmpty()) {
            if (Build.VERSION.SDK_INT >= 14) {
                this.mPaint.setXfermode((Xfermode)this.mMode);
                canvas.drawPath(path, this.mPaint);
            } else {
                Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                new Canvas(bitmap).drawPath(path, this.mPaint);
                this.mPaint.setXfermode((Xfermode)this.mMode);
                canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.mPaint);
                bitmap.recycle();
                this.mPaint.setXfermode(null);
            }
        }
        canvas.restoreToCount(n3);
    }

    public void setShader(Shader shader) {
        this.mPaint.setShader(shader);
    }

    public static interface DrawManager {
        public void defaultDraw(Canvas var1);
    }
}

