/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.GeckoPopupMenu;

public class PageActionLayout
extends LinearLayout
implements GeckoEventListener,
View.OnClickListener,
View.OnLongClickListener {
    private final String LOGTAG = "GeckoPageActionLayout";
    private final String MENU_BUTTON_KEY = "MENU_BUTTON_KEY";
    private final int DEFAULT_PAGE_ACTIONS_SHOWN = 2;
    private ArrayList<PageAction> mPageActionList;
    private GeckoPopupMenu mPageActionsMenu;
    private Context mContext;
    private LinearLayout mLayout;
    private int mMaxVisiblePageActions;

    public PageActionLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.mLayout = this;
        this.mPageActionList = new ArrayList();
        this.setNumberShown(2);
        this.refreshPageActionIcons();
        this.registerEventListener("PageActions:Add");
        this.registerEventListener("PageActions:Remove");
    }

    public void setNumberShown(int n) {
        this.mMaxVisiblePageActions = n;
        for (int i = 0; i < n; ++i) {
            if (this.getChildCount() - 1 >= i) continue;
            this.mLayout.addView((View)this.createImageButton());
        }
    }

    public void onDestroy() {
        this.unregisterEventListener("PageActions:Add");
        this.unregisterEventListener("PageActions:Remove");
    }

    protected void registerEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().registerEventListener(string2, (GeckoEventListener)this);
    }

    protected void unregisterEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().unregisterEventListener(string2, (GeckoEventListener)this);
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("PageActions:Add")) {
                String string3 = jSONObject.getString("id");
                String string4 = jSONObject.getString("title");
                String string5 = jSONObject.optString("icon");
                boolean bl = jSONObject.getBoolean("important");
                this.addPageAction(string3, string4, string5, new OnPageActionClickListeners(){

                    public void onClick(String string2) {
                        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("PageActions:Clicked", string2));
                    }

                    public boolean onLongClick(String string2) {
                        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("PageActions:LongClicked", string2));
                        return true;
                    }
                }, bl);
            } else if (string2.equals("PageActions:Remove")) {
                String string6 = jSONObject.getString("id");
                this.removePageAction(string6);
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)"GeckoPageActionLayout", (String)"Error deocding", (Throwable)jSONException);
        }
    }

    public void addPageAction(String string2, String string3, String string4, OnPageActionClickListeners onPageActionClickListeners, boolean bl) {
        int n;
        final PageAction pageAction = new PageAction(string2, string3, null, onPageActionClickListeners, bl);
        for (n = this.mPageActionList.size(); n > 0 && this.mPageActionList.get(n - 1).isImportant(); --n) {
        }
        this.mPageActionList.add(n, pageAction);
        BitmapUtils.getDrawable(this.mContext, string4, new BitmapUtils.BitmapLoader(){

            public void onBitmapFound(Drawable drawable2) {
                if (PageActionLayout.this.mPageActionList.contains(pageAction)) {
                    pageAction.setDrawable(drawable2);
                    PageActionLayout.this.refreshPageActionIcons();
                }
            }
        });
    }

    public void removePageAction(String string2) {
        for (int i = 0; i < this.mPageActionList.size(); ++i) {
            if (!this.mPageActionList.get(i).getID().equals(string2)) continue;
            this.mPageActionList.remove(i);
            this.refreshPageActionIcons();
            return;
        }
    }

    private ImageButton createImageButton() {
        ImageButton imageButton = new ImageButton(this.mContext, null, R.style.UrlBar_ImageButton_Icon);
        imageButton.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mContext.getResources().getDimensionPixelSize(R.dimen.page_action_button_width), -1));
        imageButton.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        imageButton.setOnClickListener((View.OnClickListener)this);
        imageButton.setOnLongClickListener((View.OnLongClickListener)this);
        return imageButton;
    }

    public void onClick(View view) {
        String string2 = (String)view.getTag();
        if (string2 != null) {
            if (string2.equals("MENU_BUTTON_KEY")) {
                this.showMenu(view, this.mPageActionList.size() - this.mMaxVisiblePageActions + 1);
            } else {
                this.getPageActionWithId(string2).onClick();
            }
        }
    }

    public boolean onLongClick(View view) {
        String string2 = (String)view.getTag();
        if (string2.equals("MENU_BUTTON_KEY")) {
            this.showMenu(view, this.mPageActionList.size() - this.mMaxVisiblePageActions + 1);
            return true;
        }
        return this.getPageActionWithId(string2).onLongClick();
    }

    private void setActionForView(final ImageButton imageButton, final PageAction pageAction) {
        if (pageAction == null) {
            imageButton.setTag(null);
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                public void run() {
                    imageButton.setImageDrawable(null);
                    imageButton.setVisibility(8);
                    imageButton.setContentDescription(null);
                }
            });
            return;
        }
        imageButton.setTag((Object)pageAction.getID());
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            public void run() {
                imageButton.setImageDrawable(pageAction.getDrawable());
                imageButton.setVisibility(0);
                imageButton.setContentDescription((CharSequence)pageAction.getTitle());
            }
        });
    }

    private void refreshPageActionIcons() {
        final Resources resources = this.mContext.getResources();
        for (int i = 0; i < this.getChildCount(); ++i) {
            final ImageButton imageButton = (ImageButton)this.getChildAt(i);
            final PageAction pageAction = this.getPageActionForViewAt(i);
            if (i == this.getChildCount() - 1 && this.mPageActionList.size() > this.mMaxVisiblePageActions) {
                imageButton.setTag((Object)"MENU_BUTTON_KEY");
                ThreadUtils.postToUiThread((Runnable)new Runnable(){

                    public void run() {
                        imageButton.setImageDrawable(resources.getDrawable(R.drawable.icon_pageaction));
                        imageButton.setVisibility(pageAction != null ? 0 : 8);
                        imageButton.setContentDescription((CharSequence)resources.getString(R.string.page_action_dropmarker_description));
                    }
                });
                continue;
            }
            this.setActionForView(imageButton, pageAction);
        }
    }

    private PageAction getPageActionForViewAt(int n) {
        int n2;
        int n3 = this.getChildCount() - 1 - n;
        int n4 = n2 = this.mPageActionList.size() < this.getChildCount() ? this.mPageActionList.size() : this.getChildCount();
        if (this.mPageActionList.size() > n3) {
            return this.mPageActionList.get(this.mPageActionList.size() - n2 + n3);
        }
        return null;
    }

    private PageAction getPageActionWithId(String string2) {
        for (int i = 0; i < this.mPageActionList.size(); ++i) {
            PageAction pageAction = this.mPageActionList.get(i);
            if (!pageAction.getID().equals(string2)) continue;
            return pageAction;
        }
        return null;
    }

    private void showMenu(View view, int n) {
        if (this.mPageActionsMenu == null) {
            this.mPageActionsMenu = new GeckoPopupMenu(view.getContext(), view);
            this.mPageActionsMenu.inflate(0);
            this.mPageActionsMenu.setOnMenuItemClickListener(new GeckoPopupMenu.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem menuItem) {
                    int n = menuItem.getItemId();
                    for (int i = 0; i < PageActionLayout.this.mPageActionList.size(); ++i) {
                        PageAction pageAction = (PageAction)PageActionLayout.this.mPageActionList.get(i);
                        if (pageAction.key() != n) continue;
                        pageAction.onClick();
                        return true;
                    }
                    return false;
                }
            });
        }
        Menu menu2 = this.mPageActionsMenu.getMenu();
        menu2.clear();
        for (int i = 0; i < this.mPageActionList.size(); ++i) {
            if (i >= n) continue;
            PageAction pageAction = this.mPageActionList.get(i);
            MenuItem menuItem = menu2.add(0, pageAction.key(), 0, (CharSequence)pageAction.getTitle());
            menuItem.setIcon(pageAction.getDrawable());
        }
        this.mPageActionsMenu.show();
    }

    private static class PageAction {
        private OnPageActionClickListeners mOnPageActionClickListeners;
        private Drawable mDrawable;
        private String mTitle;
        private String mId;
        private int key;
        private boolean mImportant;

        public PageAction(String string2, String string3, Drawable drawable2, OnPageActionClickListeners onPageActionClickListeners, boolean bl) {
            this.mId = string2;
            this.mTitle = string3;
            this.mDrawable = drawable2;
            this.mOnPageActionClickListeners = onPageActionClickListeners;
            this.mImportant = bl;
            this.key = UUID.fromString(((Object)this.mId.subSequence(1, this.mId.length() - 2)).toString()).hashCode();
        }

        public Drawable getDrawable() {
            return this.mDrawable;
        }

        public void setDrawable(Drawable drawable2) {
            this.mDrawable = drawable2;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String getID() {
            return this.mId;
        }

        public int key() {
            return this.key;
        }

        public boolean isImportant() {
            return this.mImportant;
        }

        public void onClick() {
            if (this.mOnPageActionClickListeners != null) {
                this.mOnPageActionClickListeners.onClick(this.mId);
            }
        }

        public boolean onLongClick() {
            if (this.mOnPageActionClickListeners != null) {
                return this.mOnPageActionClickListeners.onLongClick(this.mId);
            }
            return false;
        }
    }

    public static interface OnPageActionClickListeners {
        public void onClick(String var1);

        public boolean onLongClick(String var1);
    }
}

