/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.widget.ViewSwitcher;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.Rotate3DAnimation;
import org.mozilla.gecko.widget.GeckoTextSwitcher;

public class TabCounter
extends GeckoTextSwitcher
implements ViewSwitcher.ViewFactory {
    private static final float CENTER_X = 0.5f;
    private static final float CENTER_Y = 1.25f;
    private static final int DURATION = 500;
    private static final float Z_DISTANCE = 200.0f;
    private final AnimationSet mFlipInForward;
    private final AnimationSet mFlipInBackward;
    private final AnimationSet mFlipOutForward;
    private final AnimationSet mFlipOutBackward;
    private final LayoutInflater mInflater;
    private int mCount = 0;

    public TabCounter(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mInflater = LayoutInflater.from((Context)context);
        this.mFlipInForward = this.createAnimation(-90.0f, 0.0f, FadeMode.FADE_IN, -200.0f, false);
        this.mFlipInBackward = this.createAnimation(90.0f, 0.0f, FadeMode.FADE_IN, 200.0f, false);
        this.mFlipOutForward = this.createAnimation(0.0f, -90.0f, FadeMode.FADE_OUT, -200.0f, true);
        this.mFlipOutBackward = this.createAnimation(0.0f, 90.0f, FadeMode.FADE_OUT, 200.0f, true);
        this.removeAllViews();
        this.setFactory(this);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setImportantForAccessibility(1);
            this.setAccessibilityDelegate(new View.AccessibilityDelegate(){

                public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfo accessibilityNodeInfo) {
                }
            });
        }
    }

    public void setCountWithAnimation(int n) {
        if (this.mCount == 0) {
            this.setCount(n);
            return;
        }
        if (this.mCount == n) {
            return;
        }
        if (n < this.mCount) {
            this.setInAnimation((Animation)this.mFlipInBackward);
            this.setOutAnimation((Animation)this.mFlipOutForward);
        } else {
            this.setInAnimation((Animation)this.mFlipInForward);
            this.setOutAnimation((Animation)this.mFlipOutBackward);
        }
        this.setDisplayedChild(0);
        this.setCurrentText(String.valueOf(this.mCount));
        this.setText(String.valueOf(n));
        this.mCount = n;
    }

    public void setCount(int n) {
        this.setCurrentText(String.valueOf(n));
        this.mCount = n;
    }

    void onEnterEditingMode() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.getChildAt(i).clearAnimation();
        }
    }

    private AnimationSet createAnimation(float f, float f2, FadeMode fadeMode, float f3, boolean bl) {
        Context context = this.getContext();
        AnimationSet animationSet = new AnimationSet(context, null);
        animationSet.addAnimation((Animation)new Rotate3DAnimation(f, f2, 0.5f, 1.25f, f3, bl));
        animationSet.addAnimation((Animation)(fadeMode == FadeMode.FADE_IN ? new AlphaAnimation(0.0f, 1.0f) : new AlphaAnimation(1.0f, 0.0f)));
        animationSet.setDuration(500L);
        animationSet.setInterpolator(context, 17432581);
        return animationSet;
    }

    public View makeView() {
        return this.mInflater.inflate(R.layout.tabs_counter, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FadeMode {
        FADE_IN,
        FADE_OUT;

    }
}

