/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.toolbar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.widget.ImageView;

public class ToolbarProgressView
extends ImageView {
    public static final int MAX_PROGRESS = 10000;
    private static final int MSG_UPDATE = 42;
    private static final int STEPS = 10;
    private static final int DELAY = 40;
    private int mTargetProgress;
    private int mIncrement;
    private Rect mBounds;
    private Handler mHandler;
    private int mCurrentProgress;

    public ToolbarProgressView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    public ToolbarProgressView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public ToolbarProgressView(Context context) {
        super(context);
        this.init(context);
    }

    private void init(Context context) {
        this.mBounds = new Rect(0, 0, 0, 0);
        this.mTargetProgress = 0;
        this.mHandler = new Handler(){

            public void handleMessage(Message message) {
                if (message.what == 42) {
                    int n = Math.min(ToolbarProgressView.this.mTargetProgress, ToolbarProgressView.this.mCurrentProgress + ToolbarProgressView.this.mIncrement);
                    ToolbarProgressView.this.mCurrentProgress = n;
                    ToolbarProgressView.this.updateBounds();
                    if (n < ToolbarProgressView.this.mTargetProgress) {
                        this.sendMessageDelayed(ToolbarProgressView.this.mHandler.obtainMessage(42), 40L);
                    }
                }
            }
        };
    }

    public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.mBounds.left = 0;
        this.mBounds.right = (n3 - n) * this.mCurrentProgress / 10000;
        this.mBounds.top = 0;
        this.mBounds.bottom = n4 - n2;
    }

    public void onDraw(Canvas canvas) {
        Drawable drawable2 = this.getDrawable();
        drawable2.setBounds(this.mBounds);
        drawable2.draw(canvas);
    }

    void setProgress(int n) {
        this.mCurrentProgress = this.mTargetProgress = this.getAbsoluteProgress(n);
        this.updateBounds();
        this.mHandler.removeMessages(42);
    }

    void animateProgress(int n) {
        int n2 = this.getAbsoluteProgress(n);
        if (n2 == this.mTargetProgress) {
            return;
        }
        this.mCurrentProgress = this.mTargetProgress;
        this.mTargetProgress = n2;
        this.mIncrement = (this.mTargetProgress - this.mCurrentProgress) / 10;
        this.mHandler.removeMessages(42);
        this.mHandler.sendEmptyMessage(42);
    }

    private int getAbsoluteProgress(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 100) {
            return 100;
        }
        return n * 10000 / 100;
    }

    private void updateBounds() {
        this.mBounds.right = this.getWidth() * this.mCurrentProgress / 10000;
        this.invalidate();
    }
}

