/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.webapp;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Process;
import android.util.Log;
import java.io.File;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.WebAppAllocator;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.util.ActivityResultHandler;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.webapp.Allocator;
import org.mozilla.gecko.webapp.InstallListener;

public class EventListener
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoWebAppEventListener";
    private static EventListener mEventListener;

    private EventListener() {
    }

    private static EventListener getEventListener() {
        if (mEventListener == null) {
            mEventListener = new EventListener();
        }
        return mEventListener;
    }

    private static void registerEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().registerEventListener(string2, (GeckoEventListener)EventListener.getEventListener());
    }

    private static void unregisterEventListener(String string2) {
        GeckoAppShell.getEventDispatcher().unregisterEventListener(string2, (GeckoEventListener)EventListener.getEventListener());
    }

    public static void registerEvents() {
        EventListener.registerEventListener("WebApps:PreInstall");
        EventListener.registerEventListener("WebApps:InstallApk");
        EventListener.registerEventListener("WebApps:PostInstall");
        EventListener.registerEventListener("WebApps:Open");
        EventListener.registerEventListener("WebApps:Uninstall");
    }

    public static void unregisterEvents() {
        EventListener.unregisterEventListener("WebApps:PreInstall");
        EventListener.unregisterEventListener("WebApps:InstallApk");
        EventListener.unregisterEventListener("WebApps:PostInstall");
        EventListener.unregisterEventListener("WebApps:Open");
        EventListener.unregisterEventListener("WebApps:Uninstall");
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        try {
            if (string2.equals("WebApps:InstallApk")) {
                EventListener.installApk(GeckoAppShell.getGeckoInterface().getActivity(), jSONObject.getString("filePath"), jSONObject.getString("data"));
            } else if (string2.equals("WebApps:PostInstall")) {
                EventListener.postInstallWebApp(jSONObject.getString("apkPackageName"), jSONObject.getString("origin"));
            } else if (string2.equals("WebApps:Open")) {
                Intent intent = GeckoAppShell.getWebAppIntent(jSONObject.getString("manifestURL"), jSONObject.getString("origin"), "", null);
                if (intent == null) {
                    return;
                }
                GeckoAppShell.getGeckoInterface().getActivity().startActivity(intent);
            }
        }
        catch (Exception exception) {
            Log.e((String)LOGTAG, (String)("Exception handling message \"" + string2 + "\":"), (Throwable)exception);
        }
    }

    public static File preInstallWebApp(String string2, String string3, String string4) {
        int n = WebAppAllocator.getInstance(GeckoAppShell.getContext()).findAndAllocateIndex(string4, string2, (String)null);
        GeckoProfile geckoProfile = GeckoProfile.get(GeckoAppShell.getContext(), "webapp" + n);
        return geckoProfile.getDir();
    }

    public static void postInstallWebApp(String string2, String string3, String string4, String string5, String string6) {
        WebAppAllocator webAppAllocator = WebAppAllocator.getInstance(GeckoAppShell.getContext());
        int n = webAppAllocator.getIndexForApp(string6);
        assert (string5 != null);
        Bitmap bitmap = BitmapUtils.getBitmapFromDataURI(string5);
        assert (string4 != null && n != -1);
        webAppAllocator.updateAppAllocation(string4, n, bitmap);
        GeckoAppShell.createShortcut(string2, string3, string4, bitmap, "webapp");
    }

    public static void postInstallWebApp(String string2, String string3) {
        Allocator allocator = Allocator.getInstance(GeckoAppShell.getContext());
        int n = allocator.findOrAllocatePackage(string2);
        allocator.putOrigin(n, string3);
    }

    public static void uninstallWebApp(final String string2) {
        ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

            public void run() {
                int n = Allocator.getInstance(GeckoAppShell.getContext()).releaseIndexForApp(string2);
                if (n == -1) {
                    return;
                }
                String string22 = GeckoAppShell.getContext().getPackageName();
                string22 = string22 + ":" + string22 + ".WebApp" + n;
                ActivityManager activityManager = (ActivityManager)GeckoAppShell.getContext().getSystemService("activity");
                List list = activityManager.getRunningAppProcesses();
                if (list != null) {
                    for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                        if (!runningAppProcessInfo.processName.equals(string22)) continue;
                        Process.killProcess((int)runningAppProcessInfo.pid);
                        break;
                    }
                }
                GeckoProfile.removeProfile(GeckoAppShell.getContext(), "webapp" + n);
            }
        });
    }

    public static void installApk(final Activity activity, String string2, String string3) {
        JSONObject jSONObject = null;
        String string4 = null;
        try {
            jSONObject = new JSONObject(string3);
            string4 = jSONObject.getJSONObject("app").getString("manifestURL");
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"can't get manifest URL from JSON data", (Throwable)jSONException);
            return;
        }
        final InstallListener installListener = new InstallListener(string4, jSONObject);
        IntentFilter intentFilter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        intentFilter.addDataScheme("package");
        activity.registerReceiver((BroadcastReceiver)installListener, intentFilter);
        File file = new File(string2);
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
        GeckoAppShell.sActivityHelper.startIntentForActivity(activity, intent, new ActivityResultHandler(){

            public void onActivityResult(int n, Intent intent) {
                if (n == 0) {
                    try {
                        activity.unregisterReceiver((BroadcastReceiver)installListener);
                        installListener.cleanup();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Log.e((String)EventListener.LOGTAG, (String)"error unregistering install receiver: ", (Throwable)illegalArgumentException);
                    }
                }
            }
        });
    }
}

