/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.webapp;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.webapp.Allocator;

public class UninstallListener
extends BroadcastReceiver {
    private static String LOGTAG = "GeckoWebAppUninstallListener";

    public void onReceive(Context context, Intent intent) {
        String string2 = intent.getData().getSchemeSpecificPart();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.i((String)LOGTAG, (String)"No package name defined in intent");
            return;
        }
        Allocator allocator = Allocator.getInstance(context);
        ArrayList<String> arrayList = allocator.getInstalledPackageNames();
        if (arrayList.contains(string2)) {
            JSONObject jSONObject = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            try {
                jSONArray.put((Object)string2);
                jSONObject.put("apkPackageNames", (Object)jSONArray);
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Webapps:AutoUninstall", jSONObject.toString()));
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)("JSON EXCEPTION " + (Object)((Object)jSONException)));
            }
        }
    }

    public static void initUninstallPackageScan(Context context) {
        Allocator allocator = Allocator.getInstance(context);
        ArrayList<String> arrayList = allocator.getInstalledPackageNames();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.getInstalledApplications(128);
        HashSet<String> hashSet = new HashSet<String>();
        for (ApplicationInfo object : list) {
            hashSet.add(object.packageName);
        }
        for (String string2 : arrayList) {
            if (hashSet.contains(string2)) continue;
            arrayList2.add(string2);
        }
        if (arrayList2.size() > 0) {
            Iterator<Object> iterator = new JSONObject();
            JSONArray jSONArray = new JSONArray();
            try {
                for (String string3 : arrayList2) {
                    jSONArray.put((Object)string3);
                }
                iterator.put("apkPackageNames", jSONArray);
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Webapps:AutoUninstall", iterator.toString()));
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)("JSON EXCEPTION " + (Object)((Object)jSONException)));
            }
        }
    }
}

