/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.mozilla.gecko.mozglue.WebRTCJNITarget;

class WebRTCAudioDevice {
    private AudioTrack _audioTrack = null;
    private AudioRecord _audioRecord = null;
    @WebRTCJNITarget
    private Context _context;
    private AudioManager _audioManager;
    private ByteBuffer _playBuffer;
    private ByteBuffer _recBuffer;
    private byte[] _tempBufPlay;
    private byte[] _tempBufRec;
    private final ReentrantLock _playLock = new ReentrantLock();
    private final ReentrantLock _recLock = new ReentrantLock();
    private boolean _doPlayInit = true;
    private boolean _doRecInit = true;
    private boolean _isRecording = false;
    private boolean _isPlaying = false;
    private int _bufferedRecSamples = 0;
    private int _bufferedPlaySamples = 0;
    private int _playPosition = 0;
    final String logTag = "WebRTC AD java";

    @WebRTCJNITarget
    WebRTCAudioDevice() {
        try {
            this._playBuffer = ByteBuffer.allocateDirect(960);
            this._recBuffer = ByteBuffer.allocateDirect(960);
        }
        catch (Exception exception) {
            this.DoLog(exception.getMessage());
        }
        this._tempBufPlay = new byte[960];
        this._tempBufRec = new byte[960];
    }

    @WebRTCJNITarget
    private int InitRecording(int n, int n2) {
        int n3 = AudioRecord.getMinBufferSize((int)n2, (int)16, (int)2);
        int n4 = n3 * 2;
        this._bufferedRecSamples = 5 * n2 / 200;
        if (this._audioRecord != null) {
            this._audioRecord.release();
            this._audioRecord = null;
        }
        try {
            this._audioRecord = new AudioRecord(n, n2, 16, 2, n4);
        }
        catch (Exception exception) {
            this.DoLog(exception.getMessage());
            return -1;
        }
        if (this._audioRecord.getState() != 1) {
            return -1;
        }
        return this._bufferedRecSamples;
    }

    @WebRTCJNITarget
    private int StartRecording() {
        if (!this._isPlaying) {
            this.SetAudioMode(true);
        }
        try {
            this._audioRecord.startRecording();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return -1;
        }
        this._isRecording = true;
        return 0;
    }

    @WebRTCJNITarget
    private int InitPlayback(int n) {
        int n2 = AudioTrack.getMinBufferSize((int)n, (int)4, (int)2);
        int n3 = n2;
        if (n3 < 6000) {
            n3 *= 2;
        }
        this._bufferedPlaySamples = 0;
        if (this._audioTrack != null) {
            this._audioTrack.release();
            this._audioTrack = null;
        }
        try {
            this._audioTrack = new AudioTrack(0, n, 4, 2, n3, 1);
        }
        catch (Exception exception) {
            this.DoLog(exception.getMessage());
            return -1;
        }
        if (this._audioTrack.getState() != 1) {
            return -1;
        }
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            return 0;
        }
        return this._audioManager.getStreamMaxVolume(0);
    }

    @WebRTCJNITarget
    private int StartPlayback() {
        if (!this._isRecording) {
            this.SetAudioMode(true);
        }
        try {
            this._audioTrack.play();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return -1;
        }
        this._isPlaying = true;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebRTCJNITarget
    private int StopRecording() {
        this._recLock.lock();
        try {
            if (this._audioRecord.getRecordingState() == 3) {
                try {
                    this._audioRecord.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                    int n = -1;
                    this._doRecInit = true;
                    this._recLock.unlock();
                    return n;
                }
            }
            this._audioRecord.release();
            this._audioRecord = null;
        }
        finally {
            this._doRecInit = true;
            this._recLock.unlock();
        }
        if (!this._isPlaying) {
            this.SetAudioMode(false);
        }
        this._isRecording = false;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebRTCJNITarget
    private int StopPlayback() {
        this._playLock.lock();
        try {
            if (this._audioTrack.getPlayState() == 3) {
                try {
                    this._audioTrack.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                    int n = -1;
                    this._doPlayInit = true;
                    this._playLock.unlock();
                    return n;
                }
                this._audioTrack.flush();
            }
            this._audioTrack.release();
            this._audioTrack = null;
        }
        finally {
            this._doPlayInit = true;
            this._playLock.unlock();
        }
        if (!this._isRecording) {
            this.SetAudioMode(false);
        }
        this._isPlaying = false;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebRTCJNITarget
    private int PlayAudio(int n) {
        int n2 = 0;
        this._playLock.lock();
        try {
            if (this._audioTrack == null) {
                int n3 = -2;
                return n3;
            }
            if (this._doPlayInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception exception) {
                    this.DoLog("Set play thread priority failed: " + exception.getMessage());
                }
                this._doPlayInit = false;
            }
            int n4 = 0;
            this._playBuffer.get(this._tempBufPlay);
            n4 = this._audioTrack.write(this._tempBufPlay, 0, n);
            this._playBuffer.rewind();
            this._bufferedPlaySamples += n4 >> 1;
            int n5 = this._audioTrack.getPlaybackHeadPosition();
            if (n5 < this._playPosition) {
                this._playPosition = 0;
            }
            this._bufferedPlaySamples -= n5 - this._playPosition;
            this._playPosition = n5;
            if (!this._isRecording) {
                n2 = this._bufferedPlaySamples;
            }
            if (n4 != n) {
                int n6 = -1;
                return n6;
            }
        }
        finally {
            this._playLock.unlock();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebRTCJNITarget
    private int RecordAudio(int n) {
        this._recLock.lock();
        try {
            if (this._audioRecord == null) {
                int n2 = -2;
                return n2;
            }
            if (this._doRecInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception exception) {
                    this.DoLog("Set rec thread priority failed: " + exception.getMessage());
                }
                this._doRecInit = false;
            }
            int n3 = 0;
            this._recBuffer.rewind();
            n3 = this._audioRecord.read(this._tempBufRec, 0, n);
            this._recBuffer.put(this._tempBufRec);
            if (n3 != n) {
                int n4 = -1;
                return n4;
            }
        }
        catch (Exception exception) {
            this.DoLogErr("RecordAudio try failed: " + exception.getMessage());
        }
        finally {
            this._recLock.unlock();
        }
        return this._bufferedPlaySamples;
    }

    @WebRTCJNITarget
    private int SetPlayoutSpeaker(boolean bl) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            this.DoLogErr("Could not change audio routing - no audio manager");
            return -1;
        }
        int n = Build.VERSION.SDK_INT;
        if (3 == n || 4 == n) {
            if (bl) {
                this._audioManager.setMode(0);
            } else {
                this._audioManager.setMode(2);
            }
        } else if ((Build.BRAND.equals("Samsung") || Build.BRAND.equals("samsung")) && (5 == n || 6 == n || 7 == n)) {
            if (bl) {
                this._audioManager.setMode(2);
                this._audioManager.setSpeakerphoneOn(bl);
            } else {
                this._audioManager.setSpeakerphoneOn(bl);
                this._audioManager.setMode(0);
            }
        } else {
            this._audioManager.setSpeakerphoneOn(bl);
        }
        return 0;
    }

    @WebRTCJNITarget
    private int SetPlayoutVolume(int n) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n2 = -1;
        if (this._audioManager != null) {
            this._audioManager.setStreamVolume(0, n, 0);
            n2 = 0;
        }
        return n2;
    }

    @WebRTCJNITarget
    private int GetPlayoutVolume() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n = -1;
        if (this._audioManager != null) {
            n = this._audioManager.getStreamVolume(0);
        }
        return n;
    }

    private void SetAudioMode(boolean bl) {
        int n = Build.VERSION.SDK_INT;
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            this.DoLogErr("Could not set audio mode - no audio manager");
            return;
        }
        if ((Build.BRAND.equals("Samsung") || Build.BRAND.equals("samsung")) && 8 == n) {
            int n2 = bl ? 4 : 0;
            this._audioManager.setMode(n2);
            if (this._audioManager.getMode() != n2) {
                this.DoLogErr("Could not set audio mode for Samsung device");
            }
        }
    }

    private void DoLog(String string) {
        Log.d((String)"WebRTC AD java", (String)string);
    }

    private void DoLogErr(String string) {
        Log.e((String)"WebRTC AD java", (String)string);
    }
}

