/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.util.concurrent.SynchronousQueue;
import org.mozilla.gecko.mozglue.generatorannotations.WrapElementForJNI;
import org.mozilla.gecko.util.ThreadUtils;

public final class Clipboard {
    private static Context mContext;
    private static final String LOGTAG = "GeckoClipboard";
    private static final SynchronousQueue<String> sClipboardQueue;

    private Clipboard() {
    }

    public static void init(Context context) {
        if (mContext != null) {
            Log.w((String)LOGTAG, (String)"Clipboard.init() called twice!");
            return;
        }
        mContext = context;
    }

    @WrapElementForJNI(stubName="GetClipboardTextWrapper")
    public static String getText() {
        if (ThreadUtils.isOnUiThread() || ThreadUtils.isOnBackgroundThread()) {
            return Clipboard.getClipboardTextImpl();
        }
        ThreadUtils.postToBackgroundThread(new Runnable(){

            public void run() {
                String string = Clipboard.getClipboardTextImpl();
                try {
                    sClipboardQueue.put(string != null ? string : "");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        try {
            return sClipboardQueue.take();
        }
        catch (InterruptedException interruptedException) {
            return "";
        }
    }

    @WrapElementForJNI(stubName="SetClipboardText")
    public static void setText(final CharSequence charSequence) {
        ThreadUtils.postToBackgroundThread(new Runnable(){

            public void run() {
                if (Build.VERSION.SDK_INT >= 11) {
                    ClipboardManager clipboardManager = Clipboard.getClipboardManager(mContext);
                    ClipData clipData = ClipData.newPlainText((CharSequence)"Text", (CharSequence)charSequence);
                    try {
                        clipboardManager.setPrimaryClip(clipData);
                    }
                    catch (NullPointerException nullPointerException) {}
                } else {
                    android.text.ClipboardManager clipboardManager = Clipboard.getDeprecatedClipboardManager(mContext);
                    clipboardManager.setText(charSequence);
                }
            }
        });
    }

    @WrapElementForJNI
    public static boolean hasText() {
        if (Build.VERSION.SDK_INT >= 11) {
            ClipboardManager clipboardManager = Clipboard.getClipboardManager(mContext);
            return clipboardManager.hasPrimaryClip();
        }
        android.text.ClipboardManager clipboardManager = Clipboard.getDeprecatedClipboardManager(mContext);
        return clipboardManager.hasText();
    }

    @WrapElementForJNI
    public static void clearText() {
        Clipboard.setText(null);
    }

    private static ClipboardManager getClipboardManager(Context context) {
        return (ClipboardManager)mContext.getSystemService("clipboard");
    }

    private static android.text.ClipboardManager getDeprecatedClipboardManager(Context context) {
        return (android.text.ClipboardManager)mContext.getSystemService("clipboard");
    }

    private static String getClipboardTextImpl() {
        if (Build.VERSION.SDK_INT >= 11) {
            ClipData clipData;
            ClipboardManager clipboardManager = Clipboard.getClipboardManager(mContext);
            if (clipboardManager.hasPrimaryClip() && (clipData = clipboardManager.getPrimaryClip()) != null) {
                ClipData.Item item = clipData.getItemAt(0);
                return ((Object)item.coerceToText(mContext)).toString();
            }
        } else {
            android.text.ClipboardManager clipboardManager = Clipboard.getDeprecatedClipboardManager(mContext);
            if (clipboardManager.hasText()) {
                return ((Object)clipboardManager.getText()).toString();
            }
        }
        return null;
    }

    static {
        sClipboardQueue = new SynchronousQueue();
    }
}

