/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.graphics.PointF;

public final class FloatUtils {
    private FloatUtils() {
    }

    public static boolean fuzzyEquals(float f, float f2) {
        return (double)Math.abs(f - f2) < 1.0E-6;
    }

    public static boolean fuzzyEquals(PointF pointF, PointF pointF2) {
        return FloatUtils.fuzzyEquals(pointF.x, pointF2.x) && FloatUtils.fuzzyEquals(pointF.y, pointF2.y);
    }

    public static float interpolate(float f, float f2, float f3) {
        return f + (f2 - f) * f3;
    }

    public static float clamp(float f, float f2, float f3) {
        if (f3 < f2) {
            throw new IllegalArgumentException("clamp called with invalid parameters (" + f3 + " < " + f2 + ")");
        }
        return Math.max(f2, Math.min(f3, f));
    }
}

