/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.ViewConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HardwareUtils {
    private static final String LOGTAG = "GeckoHardwareUtils";
    private static final int LOW_MEMORY_THRESHOLD_MB = 384;
    private static volatile int sTotalRAM = -1;
    private static Context sContext;
    private static Boolean sIsLargeTablet;
    private static Boolean sIsSmallTablet;
    private static Boolean sIsTelevision;
    private static Boolean sHasMenuButton;

    private HardwareUtils() {
    }

    public static void init(Context context) {
        if (sContext != null) {
            Log.w((String)LOGTAG, (String)"HardwareUtils.init called twice!");
        }
        sContext = context;
    }

    public static boolean isTablet() {
        return HardwareUtils.isLargeTablet() || HardwareUtils.isSmallTablet();
    }

    public static boolean isLargeTablet() {
        if (sIsLargeTablet == null) {
            int n = HardwareUtils.sContext.getResources().getConfiguration().screenLayout;
            sIsLargeTablet = Build.VERSION.SDK_INT >= 11 && (n & 0xF) == 4;
        }
        return sIsLargeTablet;
    }

    public static boolean isSmallTablet() {
        if (sIsSmallTablet == null) {
            int n = HardwareUtils.sContext.getResources().getConfiguration().screenLayout;
            sIsSmallTablet = Build.VERSION.SDK_INT >= 11 && (n & 0xF) == 3;
        }
        return sIsSmallTablet;
    }

    public static boolean isTelevision() {
        if (sIsTelevision == null) {
            sIsTelevision = sContext.getPackageManager().hasSystemFeature("android.hardware.type.television");
        }
        return sIsTelevision;
    }

    public static boolean hasMenuButton() {
        if (sHasMenuButton == null) {
            sHasMenuButton = Boolean.TRUE;
            if (Build.VERSION.SDK_INT >= 11) {
                sHasMenuButton = Boolean.FALSE;
            }
            if (Build.VERSION.SDK_INT >= 14) {
                sHasMenuButton = ViewConfiguration.get((Context)sContext).hasPermanentMenuKey();
            }
        }
        return sHasMenuButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getMemSize() {
        if (sTotalRAM >= 0) {
            return sTotalRAM;
        }
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile("/proc/meminfo", "r");
            try {
                String string;
                int n = 0;
                String string2 = null;
                while (n++ < 3 && (string2 = randomAccessFile.readLine()) != null && !string2.startsWith("MemTotal: ")) {
                    string2 = null;
                }
                if (string2 == null) {
                    sTotalRAM = 0;
                    int n2 = 0;
                    return n2;
                }
                Matcher matcher = Pattern.compile("^MemTotal:\\s+([0-9]+) kB\\s*$").matcher(string2);
                if (matcher.matches() && (string = matcher.group(1)) != null) {
                    sTotalRAM = Integer.parseInt(string) / 1024;
                    Log.d((String)LOGTAG, (String)("System memory: " + sTotalRAM + "MB."));
                    int n3 = sTotalRAM;
                    return n3;
                }
                Log.w((String)LOGTAG, (String)("Got unexpected MemTotal line: " + string2));
                sTotalRAM = 0;
                int n4 = 0;
                return n4;
            }
            finally {
                randomAccessFile.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            sTotalRAM = 0;
            return 0;
        }
        catch (IOException iOException) {
            sTotalRAM = 0;
            return 0;
        }
    }

    public static boolean isLowMemoryPlatform() {
        int n = HardwareUtils.getMemSize();
        if (n == 0) {
            Log.w((String)LOGTAG, (String)"Could not compute system memory. Falling back to isLowMemoryPlatform = false.");
            return false;
        }
        return n < 384;
    }
}

