/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import java.net.InetSocketAddress;
import java.net.Proxy;

public class ProxySelector {
    public Proxy select(String string, String string2) {
        int n = -1;
        Proxy proxy = null;
        String string3 = null;
        boolean bl = true;
        if ("http".equalsIgnoreCase(string)) {
            n = 80;
            string3 = "http.nonProxyHosts";
            proxy = this.lookupProxy("http.proxyHost", "http.proxyPort", Proxy.Type.HTTP, n);
        } else if ("https".equalsIgnoreCase(string)) {
            n = 443;
            string3 = "https.nonProxyHosts";
            proxy = this.lookupProxy("https.proxyHost", "https.proxyPort", Proxy.Type.HTTP, n);
        } else if ("ftp".equalsIgnoreCase(string)) {
            n = 80;
            string3 = "ftp.nonProxyHosts";
            proxy = this.lookupProxy("ftp.proxyHost", "ftp.proxyPort", Proxy.Type.HTTP, n);
        } else if ("socket".equalsIgnoreCase(string)) {
            bl = false;
        } else {
            return Proxy.NO_PROXY;
        }
        if (string3 != null && this.isNonProxyHost(string2, System.getProperty(string3))) {
            return Proxy.NO_PROXY;
        }
        if (proxy != null) {
            return proxy;
        }
        if (bl && (proxy = this.lookupProxy("proxyHost", "proxyPort", Proxy.Type.HTTP, n)) != null) {
            return proxy;
        }
        proxy = this.lookupProxy("socksProxyHost", "socksProxyPort", Proxy.Type.SOCKS, 1080);
        if (proxy != null) {
            return proxy;
        }
        return Proxy.NO_PROXY;
    }

    private Proxy lookupProxy(String string, String string2, Proxy.Type type, int n) {
        String string3 = System.getProperty(string);
        if (string3 == null || string3.isEmpty()) {
            return null;
        }
        int n2 = this.getSystemPropertyInt(string2, n);
        return new Proxy(type, InetSocketAddress.createUnresolved(string3, n2));
    }

    private int getSystemPropertyInt(String string, int n) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    private boolean isNonProxyHost(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        block4: for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            switch (c) {
                case '.': {
                    stringBuilder.append("\\.");
                    continue block4;
                }
                case '*': {
                    stringBuilder.append(".*");
                    continue block4;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        String string3 = stringBuilder.toString();
        return string.matches(string3);
    }
}

