/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.client.protocol;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpException;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.HttpRequestInterceptor;
import ch.boye.httpclientandroidlib.androidextra.HttpClientAndroidLog;
import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.auth.AuthScheme;
import ch.boye.httpclientandroidlib.auth.AuthState;
import ch.boye.httpclientandroidlib.auth.AuthenticationException;
import ch.boye.httpclientandroidlib.auth.ContextAwareAuthScheme;
import ch.boye.httpclientandroidlib.auth.Credentials;
import ch.boye.httpclientandroidlib.conn.HttpRoutedConnection;
import ch.boye.httpclientandroidlib.conn.routing.HttpRoute;
import ch.boye.httpclientandroidlib.protocol.HttpContext;
import java.io.IOException;

@Immutable
public class RequestProxyAuthentication
implements HttpRequestInterceptor {
    public HttpClientAndroidLog log = new HttpClientAndroidLog(this.getClass());

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        block11: {
            if (httpRequest == null) {
                throw new IllegalArgumentException("HTTP request may not be null");
            }
            if (httpContext == null) {
                throw new IllegalArgumentException("HTTP context may not be null");
            }
            if (httpRequest.containsHeader("Proxy-Authorization")) {
                return;
            }
            HttpRoutedConnection httpRoutedConnection = (HttpRoutedConnection)httpContext.getAttribute("http.connection");
            if (httpRoutedConnection == null) {
                this.log.debug("HTTP connection not set in the context");
                return;
            }
            HttpRoute httpRoute = httpRoutedConnection.getRoute();
            if (httpRoute.isTunnelled()) {
                return;
            }
            AuthState authState = (AuthState)httpContext.getAttribute("http.auth.proxy-scope");
            if (authState == null) {
                this.log.debug("Proxy auth state not set in the context");
                return;
            }
            AuthScheme authScheme = authState.getAuthScheme();
            if (authScheme == null) {
                return;
            }
            Credentials credentials = authState.getCredentials();
            if (credentials == null) {
                this.log.debug("User credentials not available");
                return;
            }
            if (authState.getAuthScope() != null || !authScheme.isConnectionBased()) {
                try {
                    Header header = authScheme instanceof ContextAwareAuthScheme ? ((ContextAwareAuthScheme)authScheme).authenticate(credentials, httpRequest, httpContext) : authScheme.authenticate(credentials, httpRequest);
                    httpRequest.addHeader(header);
                }
                catch (AuthenticationException authenticationException) {
                    if (!this.log.isErrorEnabled()) break block11;
                    this.log.error("Proxy authentication error: " + authenticationException.getMessage());
                }
            }
        }
    }
}

