/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.entity;

import ch.boye.httpclientandroidlib.entity.AbstractHttpEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BasicHttpEntity
extends AbstractHttpEntity {
    private InputStream content;
    private long length = -1L;

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() throws IllegalStateException {
        if (this.content == null) {
            throw new IllegalStateException("Content has not been provided");
        }
        return this.content;
    }

    public boolean isRepeatable() {
        return false;
    }

    public void setContentLength(long l) {
        this.length = l;
    }

    public void setContent(InputStream inputStream) {
        this.content = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        InputStream inputStream = this.getContent();
        try {
            int n;
            byte[] byArray = new byte[2048];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
        }
    }

    public boolean isStreaming() {
        return this.content != null;
    }

    public void consumeContent() throws IOException {
        if (this.content != null) {
            this.content.close();
        }
    }
}

