/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.entity;

import ch.boye.httpclientandroidlib.entity.AbstractHttpEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamEntity
extends AbstractHttpEntity {
    private static final int BUFFER_SIZE = 2048;
    private final InputStream content;
    private final long length;

    public InputStreamEntity(InputStream inputStream, long l) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Source input stream may not be null");
        }
        this.content = inputStream;
        this.length = l;
    }

    public boolean isRepeatable() {
        return false;
    }

    public long getContentLength() {
        return this.length;
    }

    public InputStream getContent() throws IOException {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        block8: {
            if (outputStream == null) {
                throw new IllegalArgumentException("Output stream may not be null");
            }
            InputStream inputStream = this.content;
            try {
                int n;
                byte[] byArray = new byte[2048];
                if (this.length < 0L) {
                    int n2;
                    while ((n2 = inputStream.read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n2);
                    }
                    break block8;
                }
                for (long i = this.length; i > 0L; i -= (long)n) {
                    n = inputStream.read(byArray, 0, (int)Math.min(2048L, i));
                    if (n == -1) {
                        break;
                    }
                    outputStream.write(byArray, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
        }
    }

    public boolean isStreaming() {
        return true;
    }

    public void consumeContent() throws IOException {
        this.content.close();
    }
}

