/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl;

import ch.boye.httpclientandroidlib.ConnectionReuseStrategy;
import ch.boye.httpclientandroidlib.HeaderIterator;
import ch.boye.httpclientandroidlib.HttpConnection;
import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.HttpVersion;
import ch.boye.httpclientandroidlib.ParseException;
import ch.boye.httpclientandroidlib.ProtocolVersion;
import ch.boye.httpclientandroidlib.TokenIterator;
import ch.boye.httpclientandroidlib.message.BasicTokenIterator;
import ch.boye.httpclientandroidlib.protocol.HttpContext;

public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public boolean keepAlive(HttpResponse httpResponse, HttpContext httpContext) {
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null.");
        }
        if (httpContext == null) {
            throw new IllegalArgumentException("HTTP context may not be null.");
        }
        HttpConnection httpConnection = (HttpConnection)httpContext.getAttribute("http.connection");
        if (httpConnection != null && !httpConnection.isOpen()) {
            return false;
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        ProtocolVersion protocolVersion = httpResponse.getStatusLine().getProtocolVersion();
        if (httpEntity != null && httpEntity.getContentLength() < 0L && (!httpEntity.isChunked() || protocolVersion.lessEquals(HttpVersion.HTTP_1_0))) {
            return false;
        }
        HeaderIterator headerIterator = httpResponse.headerIterator("Connection");
        if (!headerIterator.hasNext()) {
            headerIterator = httpResponse.headerIterator("Proxy-Connection");
        }
        if (headerIterator.hasNext()) {
            try {
                TokenIterator tokenIterator = this.createTokenIterator(headerIterator);
                boolean bl = false;
                while (tokenIterator.hasNext()) {
                    String string = tokenIterator.nextToken();
                    if ("Close".equalsIgnoreCase(string)) {
                        return false;
                    }
                    if (!"Keep-Alive".equalsIgnoreCase(string)) continue;
                    bl = true;
                }
                if (bl) {
                    return true;
                }
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return !protocolVersion.lessEquals(HttpVersion.HTTP_1_0);
    }

    protected TokenIterator createTokenIterator(HeaderIterator headerIterator) {
        return new BasicTokenIterator(headerIterator);
    }
}

