/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.auth;

import ch.boye.httpclientandroidlib.Header;
import ch.boye.httpclientandroidlib.HttpRequest;
import ch.boye.httpclientandroidlib.annotation.NotThreadSafe;
import ch.boye.httpclientandroidlib.auth.AuthenticationException;
import ch.boye.httpclientandroidlib.auth.Credentials;
import ch.boye.httpclientandroidlib.auth.MalformedChallengeException;
import ch.boye.httpclientandroidlib.auth.params.AuthParams;
import ch.boye.httpclientandroidlib.impl.auth.RFC2617Scheme;
import ch.boye.httpclientandroidlib.message.BufferedHeader;
import ch.boye.httpclientandroidlib.util.CharArrayBuffer;
import ch.boye.httpclientandroidlib.util.EncodingUtils;
import org.mozilla.apache.commons.codec.binary.Base64;

@NotThreadSafe
public class BasicScheme
extends RFC2617Scheme {
    private boolean complete = false;

    public String getSchemeName() {
        return "basic";
    }

    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isConnectionBased() {
        return false;
    }

    public Header authenticate(Credentials credentials, HttpRequest httpRequest) throws AuthenticationException {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (httpRequest == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String string = AuthParams.getCredentialCharset(httpRequest.getParams());
        return BasicScheme.authenticate(credentials, string, this.isProxy());
    }

    public static Header authenticate(Credentials credentials, String string, boolean bl) {
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("charset may not be null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(credentials.getUserPrincipal().getName());
        stringBuilder.append(":");
        stringBuilder.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        byte[] byArray = Base64.encodeBase64(EncodingUtils.getBytes(stringBuilder.toString(), string));
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(32);
        if (bl) {
            charArrayBuffer.append("Proxy-Authorization");
        } else {
            charArrayBuffer.append("Authorization");
        }
        charArrayBuffer.append(": Basic ");
        charArrayBuffer.append(byArray, 0, byArray.length);
        return new BufferedHeader(charArrayBuffer);
    }
}

