/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.auth;

import ch.boye.httpclientandroidlib.impl.auth.NTLMEngine;
import ch.boye.httpclientandroidlib.impl.auth.NTLMEngineException;
import ch.boye.httpclientandroidlib.util.EncodingUtils;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.mozilla.apache.commons.codec.binary.Base64;

final class NTLMEngineImpl
implements NTLMEngine {
    protected static final int FLAG_UNICODE_ENCODING = 1;
    protected static final int FLAG_TARGET_DESIRED = 4;
    protected static final int FLAG_NEGOTIATE_SIGN = 16;
    protected static final int FLAG_NEGOTIATE_SEAL = 32;
    protected static final int FLAG_NEGOTIATE_NTLM = 512;
    protected static final int FLAG_NEGOTIATE_ALWAYS_SIGN = 32768;
    protected static final int FLAG_NEGOTIATE_NTLM2 = 524288;
    protected static final int FLAG_NEGOTIATE_128 = 0x20000000;
    protected static final int FLAG_NEGOTIATE_KEY_EXCH = 0x40000000;
    private static final SecureRandom RND_GEN;
    static final String DEFAULT_CHARSET = "ASCII";
    private String credentialCharset = "ASCII";
    private static byte[] SIGNATURE;

    NTLMEngineImpl() {
    }

    final String getResponseFor(String string, String string2, String string3, String string4, String string5) throws NTLMEngineException {
        String string6;
        if (string == null || string.trim().equals("")) {
            string6 = this.getType1Message(string4, string5);
        } else {
            Type2Message type2Message = new Type2Message(string);
            string6 = this.getType3Message(string2, string3, string4, string5, type2Message.getChallenge(), type2Message.getFlags(), type2Message.getTarget(), type2Message.getTargetInfo());
        }
        return string6;
    }

    String getType1Message(String string, String string2) throws NTLMEngineException {
        return new Type1Message(string2, string).getResponse();
    }

    String getType3Message(String string, String string2, String string3, String string4, byte[] byArray, int n, String string5, byte[] byArray2) throws NTLMEngineException {
        return new Type3Message(string4, string3, string, string2, byArray, n, string5, byArray2).getResponse();
    }

    String getCredentialCharset() {
        return this.credentialCharset;
    }

    void setCredentialCharset(String string) {
        this.credentialCharset = string;
    }

    private static String stripDotSuffix(String string) {
        int n = string.indexOf(".");
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private static String convertHost(String string) {
        return NTLMEngineImpl.stripDotSuffix(string);
    }

    private static String convertDomain(String string) {
        return NTLMEngineImpl.stripDotSuffix(string);
    }

    private static int readULong(byte[] byArray, int n) throws NTLMEngineException {
        if (byArray.length < n + 4) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for DWORD");
        }
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private static int readUShort(byte[] byArray, int n) throws NTLMEngineException {
        if (byArray.length < n + 2) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for WORD");
        }
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static byte[] readSecurityBuffer(byte[] byArray, int n) throws NTLMEngineException {
        int n2 = NTLMEngineImpl.readUShort(byArray, n);
        int n3 = NTLMEngineImpl.readULong(byArray, n + 4);
        if (byArray.length < n3 + n2) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for data item");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n3, byArray2, 0, n2);
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeRandomChallenge() throws NTLMEngineException {
        if (RND_GEN == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        byte[] byArray = new byte[8];
        SecureRandom secureRandom = RND_GEN;
        synchronized (secureRandom) {
            RND_GEN.nextBytes(byArray);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] makeNTLM2RandomChallenge() throws NTLMEngineException {
        if (RND_GEN == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        byte[] byArray = new byte[24];
        SecureRandom secureRandom = RND_GEN;
        synchronized (secureRandom) {
            RND_GEN.nextBytes(byArray);
        }
        Arrays.fill(byArray, 8, 24, (byte)0);
        return byArray;
    }

    static byte[] getLMResponse(String string, byte[] byArray) throws NTLMEngineException {
        byte[] byArray2 = NTLMEngineImpl.lmHash(string);
        return NTLMEngineImpl.lmResponse(byArray2, byArray);
    }

    static byte[] getNTLMResponse(String string, byte[] byArray) throws NTLMEngineException {
        byte[] byArray2 = NTLMEngineImpl.ntlmHash(string);
        return NTLMEngineImpl.lmResponse(byArray2, byArray);
    }

    static byte[] getNTLMv2Response(String string, String string2, String string3, byte[] byArray, byte[] byArray2, byte[] byArray3) throws NTLMEngineException {
        byte[] byArray4 = NTLMEngineImpl.ntlmv2Hash(string, string2, string3);
        byte[] byArray5 = NTLMEngineImpl.createBlob(byArray2, byArray3);
        return NTLMEngineImpl.lmv2Response(byArray4, byArray, byArray5);
    }

    static byte[] getLMv2Response(String string, String string2, String string3, byte[] byArray, byte[] byArray2) throws NTLMEngineException {
        byte[] byArray3 = NTLMEngineImpl.ntlmv2Hash(string, string2, string3);
        return NTLMEngineImpl.lmv2Response(byArray3, byArray, byArray2);
    }

    static byte[] getNTLM2SessionResponse(String string, byte[] byArray, byte[] byArray2) throws NTLMEngineException {
        try {
            byte[] byArray3 = NTLMEngineImpl.ntlmHash(string);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            byte[] byArray4 = messageDigest.digest();
            byte[] byArray5 = new byte[8];
            System.arraycopy(byArray4, 0, byArray5, 0, 8);
            return NTLMEngineImpl.lmResponse(byArray3, byArray5);
        }
        catch (Exception exception) {
            if (exception instanceof NTLMEngineException) {
                throw (NTLMEngineException)exception;
            }
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] lmHash(String string) throws NTLMEngineException {
        try {
            byte[] byArray = string.toUpperCase().getBytes("US-ASCII");
            int n = Math.min(byArray.length, 14);
            byte[] byArray2 = new byte[14];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            Key key = NTLMEngineImpl.createDESKey(byArray2, 0);
            Key key2 = NTLMEngineImpl.createDESKey(byArray2, 7);
            byte[] byArray3 = "KGS!@#$%".getBytes("US-ASCII");
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] byArray4 = cipher.doFinal(byArray3);
            cipher.init(1, key2);
            byte[] byArray5 = cipher.doFinal(byArray3);
            byte[] byArray6 = new byte[16];
            System.arraycopy(byArray4, 0, byArray6, 0, 8);
            System.arraycopy(byArray5, 0, byArray6, 8, 8);
            return byArray6;
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] ntlmHash(String string) throws NTLMEngineException {
        try {
            byte[] byArray = string.getBytes("UnicodeLittleUnmarked");
            MD4 mD4 = new MD4();
            mD4.update(byArray);
            return mD4.getOutput();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NTLMEngineException("Unicode not supported: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private static byte[] ntlmv2Hash(String string, String string2, String string3) throws NTLMEngineException {
        try {
            byte[] byArray = NTLMEngineImpl.ntlmHash(string3);
            HMACMD5 hMACMD5 = new HMACMD5(byArray);
            hMACMD5.update(string2.toUpperCase().getBytes("UnicodeLittleUnmarked"));
            hMACMD5.update(string.getBytes("UnicodeLittleUnmarked"));
            return hMACMD5.getOutput();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new NTLMEngineException("Unicode not supported! " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private static byte[] lmResponse(byte[] byArray, byte[] byArray2) throws NTLMEngineException {
        try {
            byte[] byArray3 = new byte[21];
            System.arraycopy(byArray, 0, byArray3, 0, 16);
            Key key = NTLMEngineImpl.createDESKey(byArray3, 0);
            Key key2 = NTLMEngineImpl.createDESKey(byArray3, 7);
            Key key3 = NTLMEngineImpl.createDESKey(byArray3, 14);
            Cipher cipher = Cipher.getInstance("DES/ECB/NoPadding");
            cipher.init(1, key);
            byte[] byArray4 = cipher.doFinal(byArray2);
            cipher.init(1, key2);
            byte[] byArray5 = cipher.doFinal(byArray2);
            cipher.init(1, key3);
            byte[] byArray6 = cipher.doFinal(byArray2);
            byte[] byArray7 = new byte[24];
            System.arraycopy(byArray4, 0, byArray7, 0, 8);
            System.arraycopy(byArray5, 0, byArray7, 8, 8);
            System.arraycopy(byArray6, 0, byArray7, 16, 8);
            return byArray7;
        }
        catch (Exception exception) {
            throw new NTLMEngineException(exception.getMessage(), exception);
        }
    }

    private static byte[] lmv2Response(byte[] byArray, byte[] byArray2, byte[] byArray3) throws NTLMEngineException {
        HMACMD5 hMACMD5 = new HMACMD5(byArray);
        hMACMD5.update(byArray2);
        hMACMD5.update(byArray3);
        byte[] byArray4 = hMACMD5.getOutput();
        byte[] byArray5 = new byte[byArray4.length + byArray3.length];
        System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
        System.arraycopy(byArray3, 0, byArray5, byArray4.length, byArray3.length);
        return byArray5;
    }

    private static byte[] createBlob(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[]{1, 1, 0, 0};
        byte[] byArray4 = new byte[]{0, 0, 0, 0};
        byte[] byArray5 = new byte[]{0, 0, 0, 0};
        long l = System.currentTimeMillis();
        l += 11644473600000L;
        l *= 10000L;
        byte[] byArray6 = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray6[i] = (byte)l;
            l >>>= 8;
        }
        byte[] byArray7 = new byte[byArray3.length + byArray4.length + byArray6.length + 8 + byArray5.length + byArray2.length];
        int n = 0;
        System.arraycopy(byArray3, 0, byArray7, n, byArray3.length);
        System.arraycopy(byArray4, 0, byArray7, n += byArray3.length, byArray4.length);
        System.arraycopy(byArray6, 0, byArray7, n += byArray4.length, byArray6.length);
        System.arraycopy(byArray, 0, byArray7, n += byArray6.length, 8);
        System.arraycopy(byArray5, 0, byArray7, n += 8, byArray5.length);
        System.arraycopy(byArray2, 0, byArray7, n += byArray5.length, byArray2.length);
        return byArray7;
    }

    private static Key createDESKey(byte[] byArray, int n) {
        byte[] byArray2 = new byte[7];
        System.arraycopy(byArray, n, byArray2, 0, 7);
        byte[] byArray3 = new byte[]{byArray2[0], (byte)(byArray2[0] << 7 | (byArray2[1] & 0xFF) >>> 1), (byte)(byArray2[1] << 6 | (byArray2[2] & 0xFF) >>> 2), (byte)(byArray2[2] << 5 | (byArray2[3] & 0xFF) >>> 3), (byte)(byArray2[3] << 4 | (byArray2[4] & 0xFF) >>> 4), (byte)(byArray2[4] << 3 | (byArray2[5] & 0xFF) >>> 5), (byte)(byArray2[5] << 2 | (byArray2[6] & 0xFF) >>> 6), (byte)(byArray2[6] << 1)};
        NTLMEngineImpl.oddParity(byArray3);
        return new SecretKeySpec(byArray3, "DES");
    }

    private static void oddParity(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            boolean bl;
            byte by = byArray[i];
            boolean bl2 = bl = ((by >>> 7 ^ by >>> 6 ^ by >>> 5 ^ by >>> 4 ^ by >>> 3 ^ by >>> 2 ^ by >>> 1) & 1) == 0;
            if (bl) {
                int n = i;
                byArray[n] = (byte)(byArray[n] | 1);
                continue;
            }
            int n = i;
            byArray[n] = (byte)(byArray[n] & 0xFFFFFFFE);
        }
    }

    static void writeULong(byte[] byArray, int n, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 24 & 0xFF);
    }

    static int F(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    static int G(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    static int H(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    static int rotintlft(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    public String generateType1Msg(String string, String string2) throws NTLMEngineException {
        return this.getType1Message(string2, string);
    }

    public String generateType3Msg(String string, String string2, String string3, String string4, String string5) throws NTLMEngineException {
        Type2Message type2Message = new Type2Message(string5);
        return this.getType3Message(string, string2, string4, string3, type2Message.getChallenge(), type2Message.getFlags(), type2Message.getTarget(), type2Message.getTargetInfo());
    }

    static {
        Object object = null;
        try {
            object = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RND_GEN = object;
        object = EncodingUtils.getBytes("NTLMSSP", DEFAULT_CHARSET);
        SIGNATURE = new byte[((Object)object).length + 1];
        System.arraycopy(object, 0, SIGNATURE, 0, ((Object)object).length);
        NTLMEngineImpl.SIGNATURE[((Object)object).length] = 0;
    }

    static class HMACMD5 {
        protected byte[] ipad;
        protected byte[] opad;
        protected MessageDigest md5;

        HMACMD5(byte[] byArray) throws NTLMEngineException {
            int n;
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (Exception exception) {
                throw new NTLMEngineException("Error getting md5 message digest implementation: " + exception.getMessage(), exception);
            }
            this.ipad = new byte[64];
            this.opad = new byte[64];
            int n2 = byArray.length;
            if (n2 > 64) {
                this.md5.update(byArray);
                byArray = this.md5.digest();
                n2 = byArray.length;
            }
            for (n = 0; n < n2; ++n) {
                this.ipad[n] = (byte)(byArray[n] ^ 0x36);
                this.opad[n] = (byte)(byArray[n] ^ 0x5C);
            }
            while (n < 64) {
                this.ipad[n] = 54;
                this.opad[n] = 92;
                ++n;
            }
            this.md5.reset();
            this.md5.update(this.ipad);
        }

        byte[] getOutput() {
            byte[] byArray = this.md5.digest();
            this.md5.update(this.opad);
            return this.md5.digest(byArray);
        }

        void update(byte[] byArray) {
            this.md5.update(byArray);
        }

        void update(byte[] byArray, int n, int n2) {
            this.md5.update(byArray, n, n2);
        }
    }

    static class MD4 {
        protected int A = 1732584193;
        protected int B = -271733879;
        protected int C = -1732584194;
        protected int D = 271733878;
        protected long count = 0L;
        protected byte[] dataBuffer = new byte[64];

        MD4() {
        }

        void update(byte[] byArray) {
            int n;
            int n2 = (int)(this.count & 0x3FL);
            int n3 = 0;
            while (byArray.length - n3 + n2 >= this.dataBuffer.length) {
                n = this.dataBuffer.length - n2;
                System.arraycopy(byArray, n3, this.dataBuffer, n2, n);
                this.count += (long)n;
                n2 = 0;
                n3 += n;
                this.processBuffer();
            }
            if (n3 < byArray.length) {
                n = byArray.length - n3;
                System.arraycopy(byArray, n3, this.dataBuffer, n2, n);
                this.count += (long)n;
                n2 += n;
            }
        }

        byte[] getOutput() {
            int n = (int)(this.count & 0x3FL);
            int n2 = n < 56 ? 56 - n : 120 - n;
            byte[] byArray = new byte[n2 + 8];
            byArray[0] = -128;
            for (int i = 0; i < 8; ++i) {
                byArray[n2 + i] = (byte)(this.count * 8L >>> 8 * i);
            }
            this.update(byArray);
            byte[] byArray2 = new byte[16];
            NTLMEngineImpl.writeULong(byArray2, this.A, 0);
            NTLMEngineImpl.writeULong(byArray2, this.B, 4);
            NTLMEngineImpl.writeULong(byArray2, this.C, 8);
            NTLMEngineImpl.writeULong(byArray2, this.D, 12);
            return byArray2;
        }

        protected void processBuffer() {
            int n;
            int[] nArray = new int[16];
            for (n = 0; n < 16; ++n) {
                nArray[n] = (this.dataBuffer[n * 4] & 0xFF) + ((this.dataBuffer[n * 4 + 1] & 0xFF) << 8) + ((this.dataBuffer[n * 4 + 2] & 0xFF) << 16) + ((this.dataBuffer[n * 4 + 3] & 0xFF) << 24);
            }
            n = this.A;
            int n2 = this.B;
            int n3 = this.C;
            int n4 = this.D;
            this.round1(nArray);
            this.round2(nArray);
            this.round3(nArray);
            this.A += n;
            this.B += n2;
            this.C += n3;
            this.D += n4;
        }

        protected void round1(int[] nArray) {
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.F(this.B, this.C, this.D) + nArray[0], 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.F(this.A, this.B, this.C) + nArray[1], 7);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.F(this.D, this.A, this.B) + nArray[2], 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.F(this.C, this.D, this.A) + nArray[3], 19);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.F(this.B, this.C, this.D) + nArray[4], 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.F(this.A, this.B, this.C) + nArray[5], 7);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.F(this.D, this.A, this.B) + nArray[6], 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.F(this.C, this.D, this.A) + nArray[7], 19);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.F(this.B, this.C, this.D) + nArray[8], 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.F(this.A, this.B, this.C) + nArray[9], 7);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.F(this.D, this.A, this.B) + nArray[10], 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.F(this.C, this.D, this.A) + nArray[11], 19);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.F(this.B, this.C, this.D) + nArray[12], 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.F(this.A, this.B, this.C) + nArray[13], 7);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.F(this.D, this.A, this.B) + nArray[14], 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.F(this.C, this.D, this.A) + nArray[15], 19);
        }

        protected void round2(int[] nArray) {
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.G(this.B, this.C, this.D) + nArray[0] + 1518500249, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.G(this.A, this.B, this.C) + nArray[4] + 1518500249, 5);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.G(this.D, this.A, this.B) + nArray[8] + 1518500249, 9);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.G(this.C, this.D, this.A) + nArray[12] + 1518500249, 13);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.G(this.B, this.C, this.D) + nArray[1] + 1518500249, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.G(this.A, this.B, this.C) + nArray[5] + 1518500249, 5);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.G(this.D, this.A, this.B) + nArray[9] + 1518500249, 9);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.G(this.C, this.D, this.A) + nArray[13] + 1518500249, 13);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.G(this.B, this.C, this.D) + nArray[2] + 1518500249, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.G(this.A, this.B, this.C) + nArray[6] + 1518500249, 5);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.G(this.D, this.A, this.B) + nArray[10] + 1518500249, 9);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.G(this.C, this.D, this.A) + nArray[14] + 1518500249, 13);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.G(this.B, this.C, this.D) + nArray[3] + 1518500249, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.G(this.A, this.B, this.C) + nArray[7] + 1518500249, 5);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.G(this.D, this.A, this.B) + nArray[11] + 1518500249, 9);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.G(this.C, this.D, this.A) + nArray[15] + 1518500249, 13);
        }

        protected void round3(int[] nArray) {
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.H(this.B, this.C, this.D) + nArray[0] + 1859775393, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.H(this.A, this.B, this.C) + nArray[8] + 1859775393, 9);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.H(this.D, this.A, this.B) + nArray[4] + 1859775393, 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.H(this.C, this.D, this.A) + nArray[12] + 1859775393, 15);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.H(this.B, this.C, this.D) + nArray[2] + 1859775393, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.H(this.A, this.B, this.C) + nArray[10] + 1859775393, 9);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.H(this.D, this.A, this.B) + nArray[6] + 1859775393, 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.H(this.C, this.D, this.A) + nArray[14] + 1859775393, 15);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.H(this.B, this.C, this.D) + nArray[1] + 1859775393, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.H(this.A, this.B, this.C) + nArray[9] + 1859775393, 9);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.H(this.D, this.A, this.B) + nArray[5] + 1859775393, 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.H(this.C, this.D, this.A) + nArray[13] + 1859775393, 15);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.H(this.B, this.C, this.D) + nArray[3] + 1859775393, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.H(this.A, this.B, this.C) + nArray[11] + 1859775393, 9);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.H(this.D, this.A, this.B) + nArray[7] + 1859775393, 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.H(this.C, this.D, this.A) + nArray[15] + 1859775393, 15);
        }
    }

    static class Type3Message
    extends NTLMMessage {
        protected int type2Flags;
        protected byte[] domainBytes;
        protected byte[] hostBytes;
        protected byte[] userBytes;
        protected byte[] lmResp;
        protected byte[] ntResp;

        Type3Message(String string, String string2, String string3, String string4, byte[] byArray, int n, String string5, byte[] byArray2) throws NTLMEngineException {
            this.type2Flags = n;
            string2 = NTLMEngineImpl.convertHost(string2);
            string = NTLMEngineImpl.convertDomain(string);
            try {
                byte[] byArray3;
                if (byArray2 != null && string5 != null) {
                    byArray3 = NTLMEngineImpl.makeRandomChallenge();
                    this.ntResp = NTLMEngineImpl.getNTLMv2Response(string5, string3, string4, byArray, byArray3, byArray2);
                    this.lmResp = NTLMEngineImpl.getLMv2Response(string5, string3, string4, byArray, byArray3);
                } else if ((n & 0x80000) != 0) {
                    byArray3 = NTLMEngineImpl.makeNTLM2RandomChallenge();
                    this.ntResp = NTLMEngineImpl.getNTLM2SessionResponse(string4, byArray, byArray3);
                    this.lmResp = byArray3;
                } else {
                    this.ntResp = NTLMEngineImpl.getNTLMResponse(string4, byArray);
                    this.lmResp = NTLMEngineImpl.getLMResponse(string4, byArray);
                }
            }
            catch (NTLMEngineException nTLMEngineException) {
                this.ntResp = new byte[0];
                this.lmResp = NTLMEngineImpl.getLMResponse(string4, byArray);
            }
            try {
                this.domainBytes = string.toUpperCase().getBytes("UnicodeLittleUnmarked");
                this.hostBytes = string2.getBytes("UnicodeLittleUnmarked");
                this.userBytes = string3.getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new NTLMEngineException("Unicode not supported: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }

        String getResponse() {
            int n = this.ntResp.length;
            int n2 = this.lmResp.length;
            int n3 = this.domainBytes.length;
            int n4 = this.hostBytes.length;
            int n5 = this.userBytes.length;
            int n6 = 64;
            int n7 = n6 + n2;
            int n8 = n7 + n;
            int n9 = n8 + n3;
            int n10 = n9 + n5;
            int n11 = n10 + n4;
            int n12 = n11 + 0;
            this.prepareResponse(n12, 3);
            this.addUShort(n2);
            this.addUShort(n2);
            this.addULong(n6);
            this.addUShort(n);
            this.addUShort(n);
            this.addULong(n7);
            this.addUShort(n3);
            this.addUShort(n3);
            this.addULong(n8);
            this.addUShort(n5);
            this.addUShort(n5);
            this.addULong(n9);
            this.addUShort(n4);
            this.addUShort(n4);
            this.addULong(n10);
            this.addULong(0);
            this.addULong(n12);
            this.addULong(0x20000205 | this.type2Flags & 0x80000 | this.type2Flags & 0x10 | this.type2Flags & 0x20 | this.type2Flags & 0x40000000 | this.type2Flags & 0x8000);
            this.addBytes(this.lmResp);
            this.addBytes(this.ntResp);
            this.addBytes(this.domainBytes);
            this.addBytes(this.userBytes);
            this.addBytes(this.hostBytes);
            return super.getResponse();
        }
    }

    static class Type2Message
    extends NTLMMessage {
        protected byte[] challenge = new byte[8];
        protected String target;
        protected byte[] targetInfo;
        protected int flags;

        Type2Message(String string) throws NTLMEngineException {
            super(string, 2);
            byte[] byArray;
            this.readBytes(this.challenge, 24);
            this.flags = this.readULong(20);
            if ((this.flags & 1) == 0) {
                throw new NTLMEngineException("NTLM type 2 message has flags that make no sense: " + Integer.toString(this.flags));
            }
            this.target = null;
            if (this.getMessageLength() >= 20 && (byArray = this.readSecurityBuffer(12)).length != 0) {
                try {
                    this.target = new String(byArray, "UnicodeLittleUnmarked");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new NTLMEngineException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                }
            }
            this.targetInfo = null;
            if (this.getMessageLength() >= 48 && (byArray = this.readSecurityBuffer(40)).length != 0) {
                this.targetInfo = byArray;
            }
        }

        byte[] getChallenge() {
            return this.challenge;
        }

        String getTarget() {
            return this.target;
        }

        byte[] getTargetInfo() {
            return this.targetInfo;
        }

        int getFlags() {
            return this.flags;
        }
    }

    static class Type1Message
    extends NTLMMessage {
        protected byte[] hostBytes;
        protected byte[] domainBytes;

        Type1Message(String string, String string2) throws NTLMEngineException {
            try {
                string2 = NTLMEngineImpl.convertHost(string2);
                string = NTLMEngineImpl.convertDomain(string);
                this.hostBytes = string2.getBytes("UnicodeLittleUnmarked");
                this.domainBytes = string.toUpperCase().getBytes("UnicodeLittleUnmarked");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new NTLMEngineException("Unicode unsupported: " + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        }

        String getResponse() {
            int n = 32 + this.hostBytes.length + this.domainBytes.length;
            this.prepareResponse(n, 1);
            this.addULong(537395765);
            this.addUShort(this.domainBytes.length);
            this.addUShort(this.domainBytes.length);
            this.addULong(this.hostBytes.length + 32);
            this.addUShort(this.hostBytes.length);
            this.addUShort(this.hostBytes.length);
            this.addULong(32);
            this.addBytes(this.hostBytes);
            this.addBytes(this.domainBytes);
            return super.getResponse();
        }
    }

    static class NTLMMessage {
        private byte[] messageContents = null;
        private int currentOutputPosition = 0;

        NTLMMessage() {
        }

        NTLMMessage(String string, int n) throws NTLMEngineException {
            this.messageContents = Base64.decodeBase64(EncodingUtils.getBytes(string, NTLMEngineImpl.DEFAULT_CHARSET));
            if (this.messageContents.length < SIGNATURE.length) {
                throw new NTLMEngineException("NTLM message decoding error - packet too short");
            }
            for (int i = 0; i < SIGNATURE.length; ++i) {
                if (this.messageContents[i] == SIGNATURE[i]) continue;
                throw new NTLMEngineException("NTLM message expected - instead got unrecognized bytes");
            }
            int n2 = this.readULong(SIGNATURE.length);
            if (n2 != n) {
                throw new NTLMEngineException("NTLM type " + Integer.toString(n) + " message expected - instead got type " + Integer.toString(n2));
            }
            this.currentOutputPosition = this.messageContents.length;
        }

        protected int getPreambleLength() {
            return SIGNATURE.length + 4;
        }

        protected int getMessageLength() {
            return this.currentOutputPosition;
        }

        protected byte readByte(int n) throws NTLMEngineException {
            if (this.messageContents.length < n + 1) {
                throw new NTLMEngineException("NTLM: Message too short");
            }
            return this.messageContents[n];
        }

        protected void readBytes(byte[] byArray, int n) throws NTLMEngineException {
            if (this.messageContents.length < n + byArray.length) {
                throw new NTLMEngineException("NTLM: Message too short");
            }
            System.arraycopy(this.messageContents, n, byArray, 0, byArray.length);
        }

        protected int readUShort(int n) throws NTLMEngineException {
            return NTLMEngineImpl.readUShort(this.messageContents, n);
        }

        protected int readULong(int n) throws NTLMEngineException {
            return NTLMEngineImpl.readULong(this.messageContents, n);
        }

        protected byte[] readSecurityBuffer(int n) throws NTLMEngineException {
            return NTLMEngineImpl.readSecurityBuffer(this.messageContents, n);
        }

        protected void prepareResponse(int n, int n2) {
            this.messageContents = new byte[n];
            this.currentOutputPosition = 0;
            this.addBytes(SIGNATURE);
            this.addULong(n2);
        }

        protected void addByte(byte by) {
            this.messageContents[this.currentOutputPosition] = by;
            ++this.currentOutputPosition;
        }

        protected void addBytes(byte[] byArray) {
            for (int i = 0; i < byArray.length; ++i) {
                this.messageContents[this.currentOutputPosition] = byArray[i];
                ++this.currentOutputPosition;
            }
        }

        protected void addUShort(int n) {
            this.addByte((byte)(n & 0xFF));
            this.addByte((byte)(n >> 8 & 0xFF));
        }

        protected void addULong(int n) {
            this.addByte((byte)(n & 0xFF));
            this.addByte((byte)(n >> 8 & 0xFF));
            this.addByte((byte)(n >> 16 & 0xFF));
            this.addByte((byte)(n >> 24 & 0xFF));
        }

        String getResponse() {
            byte[] byArray;
            if (this.messageContents.length > this.currentOutputPosition) {
                byte[] byArray2 = new byte[this.currentOutputPosition];
                for (int i = 0; i < this.currentOutputPosition; ++i) {
                    byArray2[i] = this.messageContents[i];
                }
                byArray = byArray2;
            } else {
                byArray = this.messageContents;
            }
            return EncodingUtils.getAsciiString(Base64.encodeBase64(byArray));
        }
    }
}

