/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.io;

import ch.boye.httpclientandroidlib.io.SessionOutputBuffer;
import java.io.IOException;
import java.io.OutputStream;

public class ChunkedOutputStream
extends OutputStream {
    private final SessionOutputBuffer out;
    private byte[] cache;
    private int cachePosition = 0;
    private boolean wroteLastChunk = false;
    private boolean closed = false;

    public ChunkedOutputStream(SessionOutputBuffer sessionOutputBuffer, int n) throws IOException {
        this.cache = new byte[n];
        this.out = sessionOutputBuffer;
    }

    public ChunkedOutputStream(SessionOutputBuffer sessionOutputBuffer) throws IOException {
        this(sessionOutputBuffer, 2048);
    }

    protected void flushCache() throws IOException {
        if (this.cachePosition > 0) {
            this.out.writeLine(Integer.toHexString(this.cachePosition));
            this.out.write(this.cache, 0, this.cachePosition);
            this.out.writeLine("");
            this.cachePosition = 0;
        }
    }

    protected void flushCacheWithAppend(byte[] byArray, int n, int n2) throws IOException {
        this.out.writeLine(Integer.toHexString(this.cachePosition + n2));
        this.out.write(this.cache, 0, this.cachePosition);
        this.out.write(byArray, n, n2);
        this.out.writeLine("");
        this.cachePosition = 0;
    }

    protected void writeClosingChunk() throws IOException {
        this.out.writeLine("0");
        this.out.writeLine("");
    }

    public void finish() throws IOException {
        if (!this.wroteLastChunk) {
            this.flushCache();
            this.writeClosingChunk();
            this.wroteLastChunk = true;
        }
    }

    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        this.cache[this.cachePosition] = (byte)n;
        ++this.cachePosition;
        if (this.cachePosition == this.cache.length) {
            this.flushCache();
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Attempted write to closed stream.");
        }
        if (n2 >= this.cache.length - this.cachePosition) {
            this.flushCacheWithAppend(byArray, n, n2);
        } else {
            System.arraycopy(byArray, n, this.cache, this.cachePosition, n2);
            this.cachePosition += n2;
        }
    }

    public void flush() throws IOException {
        this.flushCache();
        this.out.flush();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.finish();
            this.out.flush();
        }
    }
}

