/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.apache.commons.codec.language;

import java.util.Locale;
import org.mozilla.apache.commons.codec.EncoderException;
import org.mozilla.apache.commons.codec.StringEncoder;

public class ColognePhonetic
implements StringEncoder {
    private static final char[][] PREPROCESS_MAP = new char[][]{{'\u00c4', 'A'}, {'\u00dc', 'U'}, {'\u00d6', 'O'}, {'\u00df', 'S'}};

    private static boolean arrayContains(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != c) continue;
            return true;
        }
        return false;
    }

    public String colognePhonetic(String string) {
        if (string == null) {
            return null;
        }
        string = this.preprocess(string);
        CologneOutputBuffer cologneOutputBuffer = new CologneOutputBuffer(string.length() * 2);
        CologneInputBuffer cologneInputBuffer = new CologneInputBuffer(string.toCharArray());
        char c = '-';
        int n = 47;
        int n2 = cologneInputBuffer.length();
        while (n2 > 0) {
            int n3;
            char c2 = cologneInputBuffer.removeNext();
            n2 = cologneInputBuffer.length();
            char c3 = n2 > 0 ? (char)cologneInputBuffer.getNextChar() : (char)'-';
            if (ColognePhonetic.arrayContains(new char[]{'A', 'E', 'I', 'J', 'O', 'U', 'Y'}, c2)) {
                n3 = 48;
            } else if (c2 == 'H' || c2 < 'A' || c2 > 'Z') {
                if (n == 47) continue;
                n3 = 45;
            } else if (c2 == 'B' || c2 == 'P' && c3 != 'H') {
                n3 = 49;
            } else if (!(c2 != 'D' && c2 != 'T' || ColognePhonetic.arrayContains(new char[]{'S', 'C', 'Z'}, c3))) {
                n3 = 50;
            } else if (ColognePhonetic.arrayContains(new char[]{'W', 'F', 'P', 'V'}, c2)) {
                n3 = 51;
            } else if (ColognePhonetic.arrayContains(new char[]{'G', 'K', 'Q'}, c2)) {
                n3 = 52;
            } else if (c2 == 'X' && !ColognePhonetic.arrayContains(new char[]{'C', 'K', 'Q'}, c)) {
                n3 = 52;
                cologneInputBuffer.addLeft('S');
                ++n2;
            } else {
                n3 = c2 == 'S' || c2 == 'Z' ? 56 : (c2 == 'C' ? (n == 47 ? (ColognePhonetic.arrayContains(new char[]{'A', 'H', 'K', 'L', 'O', 'Q', 'R', 'U', 'X'}, c3) ? 52 : 56) : (ColognePhonetic.arrayContains(new char[]{'S', 'Z'}, c) || !ColognePhonetic.arrayContains(new char[]{'A', 'H', 'O', 'U', 'K', 'Q', 'X'}, c3) ? 56 : 52)) : (ColognePhonetic.arrayContains(new char[]{'T', 'D', 'X'}, c2) ? 56 : (c2 == 'R' ? 55 : (c2 == 'L' ? 53 : (c2 == 'M' || c2 == 'N' ? 54 : (int)c2)))));
            }
            if (n3 != 45 && (n != n3 && (n3 != 48 || n == 47) || n3 < 48 || n3 > 56)) {
                cologneOutputBuffer.addRight((char)n3);
            }
            c = c2;
            n = n3;
        }
        return cologneOutputBuffer.toString();
    }

    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("This method\u2019s parameter was expected to be of the type " + String.class.getName() + ". But actually it was of the type " + object.getClass().getName() + ".");
        }
        return this.encode((String)object);
    }

    public String encode(String string) {
        return this.colognePhonetic(string);
    }

    public boolean isEncodeEqual(String string, String string2) {
        return this.colognePhonetic(string).equals(this.colognePhonetic(string2));
    }

    private String preprocess(String string) {
        string = string.toUpperCase(Locale.GERMAN);
        char[] cArray = string.toCharArray();
        block0: for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] <= 'Z') continue;
            for (int j = 0; j < PREPROCESS_MAP.length; ++j) {
                if (cArray[i] != PREPROCESS_MAP[j][0]) continue;
                cArray[i] = PREPROCESS_MAP[j][1];
                continue block0;
            }
        }
        return new String(cArray);
    }

    private class CologneInputBuffer
    extends CologneBuffer {
        public CologneInputBuffer(char[] cArray) {
            super(cArray);
        }

        public void addLeft(char c) {
            ++this.length;
            this.data[this.getNextPos()] = c;
        }

        protected char[] copyData(int n, int n2) {
            char[] cArray = new char[n2];
            System.arraycopy(this.data, this.data.length - this.length + n, cArray, 0, n2);
            return cArray;
        }

        public char getNextChar() {
            return this.data[this.getNextPos()];
        }

        protected int getNextPos() {
            return this.data.length - this.length;
        }

        public char removeNext() {
            char c = this.getNextChar();
            --this.length;
            return c;
        }
    }

    private class CologneOutputBuffer
    extends CologneBuffer {
        public CologneOutputBuffer(int n) {
            super(n);
        }

        public void addRight(char c) {
            this.data[this.length] = c;
            ++this.length;
        }

        protected char[] copyData(int n, int n2) {
            char[] cArray = new char[n2];
            System.arraycopy(this.data, n, cArray, 0, n2);
            return cArray;
        }
    }

    private abstract class CologneBuffer {
        protected final char[] data;
        protected int length = 0;

        public CologneBuffer(char[] cArray) {
            this.data = cArray;
            this.length = cArray.length;
        }

        public CologneBuffer(int n) {
            this.data = new char[n];
            this.length = 0;
        }

        protected abstract char[] copyData(int var1, int var2);

        public int length() {
            return this.length;
        }

        public String toString() {
            return new String(this.copyData(0, this.length));
        }
    }
}

