/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.apache.commons.codec.language;

import java.util.Locale;
import org.mozilla.apache.commons.codec.EncoderException;
import org.mozilla.apache.commons.codec.StringEncoder;

public class Metaphone
implements StringEncoder {
    private static final String VOWELS = "AEIOU";
    private static final String FRONTV = "EIY";
    private static final String VARSON = "CSPTG";
    private int maxCodeLen = 4;

    public String metaphone(String string) {
        boolean bl = false;
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.length() == 1) {
            return string.toUpperCase(Locale.ENGLISH);
        }
        char[] cArray = string.toUpperCase(Locale.ENGLISH).toCharArray();
        StringBuffer stringBuffer = new StringBuffer(40);
        StringBuffer stringBuffer2 = new StringBuffer(10);
        switch (cArray[0]) {
            case 'G': 
            case 'K': 
            case 'P': {
                if (cArray[1] == 'N') {
                    stringBuffer.append(cArray, 1, cArray.length - 1);
                    break;
                }
                stringBuffer.append(cArray);
                break;
            }
            case 'A': {
                if (cArray[1] == 'E') {
                    stringBuffer.append(cArray, 1, cArray.length - 1);
                    break;
                }
                stringBuffer.append(cArray);
                break;
            }
            case 'W': {
                if (cArray[1] == 'R') {
                    stringBuffer.append(cArray, 1, cArray.length - 1);
                    break;
                }
                if (cArray[1] == 'H') {
                    stringBuffer.append(cArray, 1, cArray.length - 1);
                    stringBuffer.setCharAt(0, 'W');
                    break;
                }
                stringBuffer.append(cArray);
                break;
            }
            case 'X': {
                cArray[0] = 83;
                stringBuffer.append(cArray);
                break;
            }
            default: {
                stringBuffer.append(cArray);
            }
        }
        int n = stringBuffer.length();
        int n2 = 0;
        while (stringBuffer2.length() < this.getMaxCodeLen() && n2 < n) {
            char c = stringBuffer.charAt(n2);
            if (c != 'C' && this.isPreviousChar(stringBuffer, n2, c)) {
                ++n2;
            } else {
                switch (c) {
                    case 'A': 
                    case 'E': 
                    case 'I': 
                    case 'O': 
                    case 'U': {
                        if (n2 != 0) break;
                        stringBuffer2.append(c);
                        break;
                    }
                    case 'B': {
                        if (this.isPreviousChar(stringBuffer, n2, 'M') && this.isLastChar(n, n2)) break;
                        stringBuffer2.append(c);
                        break;
                    }
                    case 'C': {
                        if (this.isPreviousChar(stringBuffer, n2, 'S') && !this.isLastChar(n, n2) && FRONTV.indexOf(stringBuffer.charAt(n2 + 1)) >= 0) break;
                        if (this.regionMatch(stringBuffer, n2, "CIA")) {
                            stringBuffer2.append('X');
                            break;
                        }
                        if (!this.isLastChar(n, n2) && FRONTV.indexOf(stringBuffer.charAt(n2 + 1)) >= 0) {
                            stringBuffer2.append('S');
                            break;
                        }
                        if (this.isPreviousChar(stringBuffer, n2, 'S') && this.isNextChar(stringBuffer, n2, 'H')) {
                            stringBuffer2.append('K');
                            break;
                        }
                        if (this.isNextChar(stringBuffer, n2, 'H')) {
                            if (n2 == 0 && n >= 3 && this.isVowel(stringBuffer, 2)) {
                                stringBuffer2.append('K');
                                break;
                            }
                            stringBuffer2.append('X');
                            break;
                        }
                        stringBuffer2.append('K');
                        break;
                    }
                    case 'D': {
                        if (!this.isLastChar(n, n2 + 1) && this.isNextChar(stringBuffer, n2, 'G') && FRONTV.indexOf(stringBuffer.charAt(n2 + 2)) >= 0) {
                            stringBuffer2.append('J');
                            n2 += 2;
                            break;
                        }
                        stringBuffer2.append('T');
                        break;
                    }
                    case 'G': {
                        if (this.isLastChar(n, n2 + 1) && this.isNextChar(stringBuffer, n2, 'H') || !this.isLastChar(n, n2 + 1) && this.isNextChar(stringBuffer, n2, 'H') && !this.isVowel(stringBuffer, n2 + 2) || n2 > 0 && (this.regionMatch(stringBuffer, n2, "GN") || this.regionMatch(stringBuffer, n2, "GNED"))) break;
                        bl = this.isPreviousChar(stringBuffer, n2, 'G');
                        if (!this.isLastChar(n, n2) && FRONTV.indexOf(stringBuffer.charAt(n2 + 1)) >= 0 && !bl) {
                            stringBuffer2.append('J');
                            break;
                        }
                        stringBuffer2.append('K');
                        break;
                    }
                    case 'H': {
                        if (this.isLastChar(n, n2) || n2 > 0 && VARSON.indexOf(stringBuffer.charAt(n2 - 1)) >= 0 || !this.isVowel(stringBuffer, n2 + 1)) break;
                        stringBuffer2.append('H');
                        break;
                    }
                    case 'F': 
                    case 'J': 
                    case 'L': 
                    case 'M': 
                    case 'N': 
                    case 'R': {
                        stringBuffer2.append(c);
                        break;
                    }
                    case 'K': {
                        if (n2 > 0) {
                            if (this.isPreviousChar(stringBuffer, n2, 'C')) break;
                            stringBuffer2.append(c);
                            break;
                        }
                        stringBuffer2.append(c);
                        break;
                    }
                    case 'P': {
                        if (this.isNextChar(stringBuffer, n2, 'H')) {
                            stringBuffer2.append('F');
                            break;
                        }
                        stringBuffer2.append(c);
                        break;
                    }
                    case 'Q': {
                        stringBuffer2.append('K');
                        break;
                    }
                    case 'S': {
                        if (this.regionMatch(stringBuffer, n2, "SH") || this.regionMatch(stringBuffer, n2, "SIO") || this.regionMatch(stringBuffer, n2, "SIA")) {
                            stringBuffer2.append('X');
                            break;
                        }
                        stringBuffer2.append('S');
                        break;
                    }
                    case 'T': {
                        if (this.regionMatch(stringBuffer, n2, "TIA") || this.regionMatch(stringBuffer, n2, "TIO")) {
                            stringBuffer2.append('X');
                            break;
                        }
                        if (this.regionMatch(stringBuffer, n2, "TCH")) break;
                        if (this.regionMatch(stringBuffer, n2, "TH")) {
                            stringBuffer2.append('0');
                            break;
                        }
                        stringBuffer2.append('T');
                        break;
                    }
                    case 'V': {
                        stringBuffer2.append('F');
                        break;
                    }
                    case 'W': 
                    case 'Y': {
                        if (this.isLastChar(n, n2) || !this.isVowel(stringBuffer, n2 + 1)) break;
                        stringBuffer2.append(c);
                        break;
                    }
                    case 'X': {
                        stringBuffer2.append('K');
                        stringBuffer2.append('S');
                        break;
                    }
                    case 'Z': {
                        stringBuffer2.append('S');
                    }
                }
                ++n2;
            }
            if (stringBuffer2.length() <= this.getMaxCodeLen()) continue;
            stringBuffer2.setLength(this.getMaxCodeLen());
        }
        return stringBuffer2.toString();
    }

    private boolean isVowel(StringBuffer stringBuffer, int n) {
        return VOWELS.indexOf(stringBuffer.charAt(n)) >= 0;
    }

    private boolean isPreviousChar(StringBuffer stringBuffer, int n, char c) {
        boolean bl = false;
        if (n > 0 && n < stringBuffer.length()) {
            bl = stringBuffer.charAt(n - 1) == c;
        }
        return bl;
    }

    private boolean isNextChar(StringBuffer stringBuffer, int n, char c) {
        boolean bl = false;
        if (n >= 0 && n < stringBuffer.length() - 1) {
            bl = stringBuffer.charAt(n + 1) == c;
        }
        return bl;
    }

    private boolean regionMatch(StringBuffer stringBuffer, int n, String string) {
        boolean bl = false;
        if (n >= 0 && n + string.length() - 1 < stringBuffer.length()) {
            String string2 = stringBuffer.substring(n, n + string.length());
            bl = string2.equals(string);
        }
        return bl;
    }

    private boolean isLastChar(int n, int n2) {
        return n2 + 1 == n;
    }

    public Object encode(Object object) throws EncoderException {
        if (!(object instanceof String)) {
            throw new EncoderException("Parameter supplied to Metaphone encode is not of type java.lang.String");
        }
        return this.metaphone((String)object);
    }

    public String encode(String string) {
        return this.metaphone(string);
    }

    public boolean isMetaphoneEqual(String string, String string2) {
        return this.metaphone(string).equals(this.metaphone(string2));
    }

    public int getMaxCodeLen() {
        return this.maxCodeLen;
    }

    public void setMaxCodeLen(int n) {
        this.maxCodeLen = n;
    }
}

