/*
 * Decompiled with CFR 0.152.
 */
package com.codebutler.android_websockets;

import android.util.Log;
import com.codebutler.android_websockets.WebSocketClient;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;

public class HybiParser {
    private static final String TAG = "HybiParser";
    private WebSocketClient mClient;
    private boolean mMasking = true;
    private int mStage;
    private boolean mFinal;
    private boolean mMasked;
    private int mOpcode;
    private int mLengthSize;
    private int mLength;
    private int mMode;
    private byte[] mMask = new byte[0];
    private byte[] mPayload = new byte[0];
    private boolean mClosed = false;
    private ByteArrayOutputStream mBuffer = new ByteArrayOutputStream();
    private static final int BYTE = 255;
    private static final int FIN = 128;
    private static final int MASK = 128;
    private static final int RSV1 = 64;
    private static final int RSV2 = 32;
    private static final int RSV3 = 16;
    private static final int OPCODE = 15;
    private static final int LENGTH = 127;
    private static final int MODE_TEXT = 1;
    private static final int MODE_BINARY = 2;
    private static final int OP_CONTINUATION = 0;
    private static final int OP_TEXT = 1;
    private static final int OP_BINARY = 2;
    private static final int OP_CLOSE = 8;
    private static final int OP_PING = 9;
    private static final int OP_PONG = 10;
    private static final List<Integer> OPCODES = Arrays.asList(0, 1, 2, 8, 9, 10);
    private static final List<Integer> FRAGMENTED_OPCODES = Arrays.asList(0, 1, 2);

    public HybiParser(WebSocketClient webSocketClient) {
        this.mClient = webSocketClient;
    }

    private static byte[] mask(byte[] byArray, byte[] byArray2, int n) {
        if (byArray2.length == 0) {
            return byArray;
        }
        for (int i = 0; i < byArray.length - n; ++i) {
            byArray[n + i] = (byte)(byArray[n + i] ^ byArray2[i % 4]);
        }
        return byArray;
    }

    public void start(HappyDataInputStream happyDataInputStream) throws IOException {
        while (happyDataInputStream.available() != -1) {
            switch (this.mStage) {
                case 0: {
                    this.parseOpcode(happyDataInputStream.readByte());
                    break;
                }
                case 1: {
                    this.parseLength(happyDataInputStream.readByte());
                    break;
                }
                case 2: {
                    this.parseExtendedLength(happyDataInputStream.readBytes(this.mLengthSize));
                    break;
                }
                case 3: {
                    this.mMask = happyDataInputStream.readBytes(4);
                    this.mStage = 4;
                    break;
                }
                case 4: {
                    this.mPayload = happyDataInputStream.readBytes(this.mLength);
                    this.emitFrame();
                    this.mStage = 0;
                }
            }
        }
        this.mClient.getListener().onDisconnect(0, "EOF");
    }

    private void parseOpcode(byte by) throws ProtocolError {
        boolean bl;
        boolean bl2 = (by & 0x40) == 64;
        boolean bl3 = (by & 0x20) == 32;
        boolean bl4 = bl = (by & 0x10) == 16;
        if (bl2 || bl3 || bl) {
            throw new ProtocolError("RSV not zero");
        }
        this.mFinal = (by & 0x80) == 128;
        this.mOpcode = by & 0xF;
        this.mMask = new byte[0];
        this.mPayload = new byte[0];
        if (!OPCODES.contains(this.mOpcode)) {
            throw new ProtocolError("Bad opcode");
        }
        if (!FRAGMENTED_OPCODES.contains(this.mOpcode) && !this.mFinal) {
            throw new ProtocolError("Expected non-final packet");
        }
        this.mStage = 1;
    }

    private void parseLength(byte by) {
        this.mMasked = (by & 0x80) == 128;
        this.mLength = by & 0x7F;
        if (this.mLength >= 0 && this.mLength <= 125) {
            this.mStage = this.mMasked ? 3 : 4;
        } else {
            this.mLengthSize = this.mLength == 126 ? 2 : 8;
            this.mStage = 2;
        }
    }

    private void parseExtendedLength(byte[] byArray) throws ProtocolError {
        this.mLength = this.getInteger(byArray);
        this.mStage = this.mMasked ? 3 : 4;
    }

    public byte[] frame(String string) {
        return this.frame(string, 1, -1);
    }

    public byte[] frame(byte[] byArray) {
        return this.frame(byArray, 2, -1);
    }

    private byte[] frame(byte[] byArray, int n, int n2) {
        return this.frame((Object)byArray, n, n2);
    }

    private byte[] frame(String string, int n, int n2) {
        return this.frame((Object)string, n, n2);
    }

    private byte[] frame(Object object, int n, int n2) {
        if (this.mClosed) {
            return null;
        }
        Log.d((String)TAG, (String)("Creating frame for: " + object + " op: " + n + " err: " + n2));
        byte[] byArray = object instanceof String ? this.decode((String)object) : (byte[])object;
        int n3 = n2 > 0 ? 2 : 0;
        int n4 = byArray.length + n3;
        int n5 = n4 <= 125 ? 2 : (n4 <= 65535 ? 4 : 10);
        int n6 = n5 + (this.mMasking ? 4 : 0);
        int n7 = this.mMasking ? 128 : 0;
        byte[] byArray2 = new byte[n4 + n6];
        byArray2[0] = (byte)(0xFFFFFF80 | (byte)n);
        if (n4 <= 125) {
            byArray2[1] = (byte)(n7 | n4);
        } else if (n4 <= 65535) {
            byArray2[1] = (byte)(n7 | 0x7E);
            byArray2[2] = (byte)Math.floor(n4 / 256);
            byArray2[3] = (byte)(n4 & 0xFF);
        } else {
            byArray2[1] = (byte)(n7 | 0x7F);
            byArray2[2] = (byte)((int)Math.floor((double)n4 / Math.pow(2.0, 56.0)) & 0xFF);
            byArray2[3] = (byte)((int)Math.floor((double)n4 / Math.pow(2.0, 48.0)) & 0xFF);
            byArray2[4] = (byte)((int)Math.floor((double)n4 / Math.pow(2.0, 40.0)) & 0xFF);
            byArray2[5] = (byte)((int)Math.floor((double)n4 / Math.pow(2.0, 32.0)) & 0xFF);
            byArray2[6] = (byte)((int)Math.floor((double)n4 / Math.pow(2.0, 24.0)) & 0xFF);
            byArray2[7] = (byte)((int)Math.floor((double)n4 / Math.pow(2.0, 16.0)) & 0xFF);
            byArray2[8] = (byte)((int)Math.floor((double)n4 / Math.pow(2.0, 8.0)) & 0xFF);
            byArray2[9] = (byte)(n4 & 0xFF);
        }
        if (n2 > 0) {
            byArray2[n6] = (byte)((int)Math.floor(n2 / 256) & 0xFF);
            byArray2[n6 + 1] = (byte)(n2 & 0xFF);
        }
        System.arraycopy(byArray, 0, byArray2, n6 + n3, byArray.length);
        if (this.mMasking) {
            byte[] byArray3 = new byte[]{(byte)Math.floor(Math.random() * 256.0), (byte)Math.floor(Math.random() * 256.0), (byte)Math.floor(Math.random() * 256.0), (byte)Math.floor(Math.random() * 256.0)};
            System.arraycopy(byArray3, 0, byArray2, n5, byArray3.length);
            HybiParser.mask(byArray2, byArray3, n6);
        }
        return byArray2;
    }

    public void ping(String string) {
        this.mClient.send(this.frame(string, 9, -1));
    }

    public void close(int n, String string) {
        if (this.mClosed) {
            return;
        }
        this.mClient.send(this.frame(string, 8, n));
        this.mClosed = true;
    }

    private void emitFrame() throws IOException {
        byte[] byArray = HybiParser.mask(this.mPayload, this.mMask, 0);
        int n = this.mOpcode;
        if (n == 0) {
            if (this.mMode == 0) {
                throw new ProtocolError("Mode was not set.");
            }
            this.mBuffer.write(byArray);
            if (this.mFinal) {
                byte[] byArray2 = this.mBuffer.toByteArray();
                if (this.mMode == 1) {
                    this.mClient.getListener().onMessage(this.encode(byArray2));
                } else {
                    this.mClient.getListener().onMessage(byArray2);
                }
                this.reset();
            }
        } else if (n == 1) {
            if (this.mFinal) {
                String string = this.encode(byArray);
                this.mClient.getListener().onMessage(string);
            } else {
                this.mMode = 1;
                this.mBuffer.write(byArray);
            }
        } else if (n == 2) {
            if (this.mFinal) {
                this.mClient.getListener().onMessage(byArray);
            } else {
                this.mMode = 2;
                this.mBuffer.write(byArray);
            }
        } else if (n == 8) {
            int n2 = byArray.length >= 2 ? 256 * byArray[0] + byArray[1] : 0;
            String string = byArray.length > 2 ? this.encode(this.slice(byArray, 2)) : null;
            Log.d((String)TAG, (String)("Got close op! " + n2 + " " + string));
            this.mClient.getListener().onDisconnect(n2, string);
        } else if (n == 9) {
            if (byArray.length > 125) {
                throw new ProtocolError("Ping payload too large");
            }
            Log.d((String)TAG, (String)"Sending pong!!");
            this.mClient.sendFrame(this.frame(byArray, 10, -1));
        } else if (n == 10) {
            String string = this.encode(byArray);
            Log.d((String)TAG, (String)("Got pong! " + string));
        }
    }

    private void reset() {
        this.mMode = 0;
        this.mBuffer.reset();
    }

    private String encode(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private byte[] decode(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private int getInteger(byte[] byArray) throws ProtocolError {
        long l = HybiParser.byteArrayToLong(byArray, 0, byArray.length);
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new ProtocolError("Bad integer: " + l);
        }
        return (int)l;
    }

    private static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        int n3 = byArray.length;
        if (n < 0 || n > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = n2 - n;
        int n5 = Math.min(n4, n3 - n);
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n, byArray2, 0, n5);
        return byArray2;
    }

    private byte[] slice(byte[] byArray, int n) {
        return HybiParser.copyOfRange(byArray, n, byArray.length);
    }

    private static long byteArrayToLong(byte[] byArray, int n, int n2) {
        if (byArray.length < n2) {
            throw new IllegalArgumentException("length must be less than or equal to b.length");
        }
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            int n3 = (n2 - 1 - i) * 8;
            l += (long)((byArray[i + n] & 0xFF) << n3);
        }
        return l;
    }

    public static class HappyDataInputStream
    extends DataInputStream {
        public HappyDataInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public byte[] readBytes(int n) throws IOException {
            int n2;
            int n3;
            byte[] byArray = new byte[n];
            for (n2 = 0; n2 < n && (n3 = this.read(byArray, n2, n - n2)) != -1; n2 += n3) {
            }
            if (n2 != n) {
                throw new IOException(String.format("Read wrong number of bytes. Got: %s, Expected: %s.", n2, n));
            }
            return byArray;
        }
    }

    public static class ProtocolError
    extends IOException {
        public ProtocolError(String string) {
            super(string);
        }
    }
}

