/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.cookie;

import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.impl.cookie.DateParseException;
import java.lang.ref.SoftReference;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

@Immutable
public final class DateUtils {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final String[] DEFAULT_PATTERNS = new String[]{"EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private static final Date DEFAULT_TWO_DIGIT_YEAR_START;
    public static final TimeZone GMT;

    public static Date parseDate(String string) throws DateParseException {
        return DateUtils.parseDate(string, null, null);
    }

    public static Date parseDate(String string, String[] stringArray) throws DateParseException {
        return DateUtils.parseDate(string, stringArray, null);
    }

    public static Date parseDate(String string, String[] stringArray, Date date) throws DateParseException {
        if (string == null) {
            throw new IllegalArgumentException("dateValue is null");
        }
        if (stringArray == null) {
            stringArray = DEFAULT_PATTERNS;
        }
        if (date == null) {
            date = DEFAULT_TWO_DIGIT_YEAR_START;
        }
        if (string.length() > 1 && string.startsWith("'") && string.endsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        for (String string2 : stringArray) {
            SimpleDateFormat simpleDateFormat = DateFormatHolder.formatFor(string2);
            simpleDateFormat.set2DigitYearStart(date);
            try {
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
            }
        }
        throw new DateParseException("Unable to parse the date " + string);
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDate(date, PATTERN_RFC1123);
    }

    public static String formatDate(Date date, String string) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        SimpleDateFormat simpleDateFormat = DateFormatHolder.formatFor(string);
        return simpleDateFormat.format(date);
    }

    private DateUtils() {
    }

    static {
        GMT = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(GMT);
        calendar.set(2000, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
    }

    static final class DateFormatHolder {
        private static final ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>> THREADLOCAL_FORMATS = new ThreadLocal<SoftReference<Map<String, SimpleDateFormat>>>(){

            @Override
            protected SoftReference<Map<String, SimpleDateFormat>> initialValue() {
                return new SoftReference<Map<String, SimpleDateFormat>>(new HashMap());
            }
        };

        DateFormatHolder() {
        }

        public static SimpleDateFormat formatFor(String string) {
            SimpleDateFormat simpleDateFormat;
            SoftReference<Map<String, SimpleDateFormat>> softReference = THREADLOCAL_FORMATS.get();
            Map<String, SimpleDateFormat> map = softReference.get();
            if (map == null) {
                map = new HashMap<String, SimpleDateFormat>();
                THREADLOCAL_FORMATS.set(new SoftReference<Map<String, SimpleDateFormat>>(map));
            }
            if ((simpleDateFormat = map.get(string)) == null) {
                simpleDateFormat = new SimpleDateFormat(string, Locale.US);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                map.put(string, simpleDateFormat);
            }
            return simpleDateFormat;
        }
    }
}

