/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.message;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.ProtocolVersion;
import ch.boye.httpclientandroidlib.ReasonPhraseCatalog;
import ch.boye.httpclientandroidlib.StatusLine;
import ch.boye.httpclientandroidlib.message.AbstractHttpMessage;
import ch.boye.httpclientandroidlib.message.BasicStatusLine;
import java.util.Locale;

public class BasicHttpResponse
extends AbstractHttpMessage
implements HttpResponse {
    private StatusLine statusline;
    private HttpEntity entity;
    private ReasonPhraseCatalog reasonCatalog;
    private Locale locale;

    public BasicHttpResponse(StatusLine statusLine, ReasonPhraseCatalog reasonPhraseCatalog, Locale locale) {
        if (statusLine == null) {
            throw new IllegalArgumentException("Status line may not be null.");
        }
        this.statusline = statusLine;
        this.reasonCatalog = reasonPhraseCatalog;
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    public BasicHttpResponse(StatusLine statusLine) {
        this(statusLine, null, null);
    }

    public BasicHttpResponse(ProtocolVersion protocolVersion, int n, String string) {
        this(new BasicStatusLine(protocolVersion, n, string), null, null);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.statusline.getProtocolVersion();
    }

    public StatusLine getStatusLine() {
        return this.statusline;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setStatusLine(StatusLine statusLine) {
        if (statusLine == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        this.statusline = statusLine;
    }

    public void setStatusLine(ProtocolVersion protocolVersion, int n) {
        this.statusline = new BasicStatusLine(protocolVersion, n, this.getReason(n));
    }

    public void setStatusLine(ProtocolVersion protocolVersion, int n, String string) {
        this.statusline = new BasicStatusLine(protocolVersion, n, string);
    }

    public void setStatusCode(int n) {
        ProtocolVersion protocolVersion = this.statusline.getProtocolVersion();
        this.statusline = new BasicStatusLine(protocolVersion, n, this.getReason(n));
    }

    public void setReasonPhrase(String string) {
        if (string != null && (string.indexOf(10) >= 0 || string.indexOf(13) >= 0)) {
            throw new IllegalArgumentException("Line break in reason phrase.");
        }
        this.statusline = new BasicStatusLine(this.statusline.getProtocolVersion(), this.statusline.getStatusCode(), string);
    }

    public void setEntity(HttpEntity httpEntity) {
        this.entity = httpEntity;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale may not be null.");
        }
        this.locale = locale;
        int n = this.statusline.getStatusCode();
        this.statusline = new BasicStatusLine(this.statusline.getProtocolVersion(), n, this.getReason(n));
    }

    protected String getReason(int n) {
        return this.reasonCatalog == null ? null : this.reasonCatalog.getReason(n, this.locale);
    }

    public String toString() {
        return this.statusline + " " + this.headergroup;
    }
}

