/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.videoengine;

import android.content.Context;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.mozilla.gecko.mozglue.WebRTCJNITarget;
import org.webrtc.videoengine.CaptureCapabilityAndroid;
import org.webrtc.videoengine.VideoCaptureAndroid;

public class VideoCaptureDeviceInfoAndroid {
    Context context;
    private static final String TAG = "WEBRTC";
    String currentDeviceUniqueId;
    int id;
    List<AndroidVideoCaptureDevice> deviceList;

    @WebRTCJNITarget
    public static VideoCaptureDeviceInfoAndroid CreateVideoCaptureDeviceInfoAndroid(int n, Context context) {
        Log.d((String)TAG, (String)String.format(Locale.US, "VideoCaptureDeviceInfoAndroid", new Object[0]));
        VideoCaptureDeviceInfoAndroid videoCaptureDeviceInfoAndroid = new VideoCaptureDeviceInfoAndroid(n, context);
        if (videoCaptureDeviceInfoAndroid != null && videoCaptureDeviceInfoAndroid.Init() == 0) {
            return videoCaptureDeviceInfoAndroid;
        }
        Log.d((String)TAG, (String)"Failed to create VideoCaptureDeviceInfoAndroid.");
        return null;
    }

    private VideoCaptureDeviceInfoAndroid(int n, Context context) {
        this.id = n;
        this.context = context;
        this.deviceList = new ArrayList<AndroidVideoCaptureDevice>();
    }

    private int Init() {
        Camera camera = null;
        if (Build.VERSION.SDK_INT > 8) {
            for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
                AndroidVideoCaptureDevice androidVideoCaptureDevice = new AndroidVideoCaptureDevice();
                Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                androidVideoCaptureDevice.index = i;
                androidVideoCaptureDevice.orientation = cameraInfo.orientation;
                if (cameraInfo.facing == 0) {
                    androidVideoCaptureDevice.deviceUniqueName = "Camera " + i + ", Facing back, Orientation " + cameraInfo.orientation;
                    Log.d((String)TAG, (String)("Camera " + i + ", Facing back, Orientation " + cameraInfo.orientation));
                } else {
                    androidVideoCaptureDevice.deviceUniqueName = "Camera " + i + ", Facing front, Orientation " + cameraInfo.orientation;
                    androidVideoCaptureDevice.frontCameraType = FrontFacingCameraType.Android23;
                    Log.d((String)TAG, (String)("Camera " + i + ", Facing front, Orientation " + cameraInfo.orientation));
                }
                camera = Camera.open((int)i);
                Camera.Parameters parameters = camera.getParameters();
                this.AddDeviceInfo(androidVideoCaptureDevice, parameters);
                camera.release();
                camera = null;
                this.deviceList.add(androidVideoCaptureDevice);
            }
        }
        this.VerifyCapabilities();
        return 0;
    }

    private void AddDeviceInfo(AndroidVideoCaptureDevice androidVideoCaptureDevice, Camera.Parameters parameters) {
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPreviewFrameRates();
        int n = 0;
        if (list2 != null) {
            for (Integer n2 : list2) {
                if (n2 <= n) continue;
                n = n2;
            }
        }
        androidVideoCaptureDevice.captureCapabilies = new CaptureCapabilityAndroid[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer n2;
            n2 = (Camera.Size)list.get(i);
            androidVideoCaptureDevice.captureCapabilies[i] = new CaptureCapabilityAndroid();
            androidVideoCaptureDevice.captureCapabilies[i].height = ((Camera.Size)n2).height;
            androidVideoCaptureDevice.captureCapabilies[i].width = ((Camera.Size)n2).width;
            androidVideoCaptureDevice.captureCapabilies[i].maxFPS = n;
            Log.v((String)TAG, (String)("VideoCaptureDeviceInfo , maxFPS: " + n + ", width: " + ((Camera.Size)n2).width + ", height: " + ((Camera.Size)n2).height));
        }
    }

    private void VerifyCapabilities() {
        if (Build.DEVICE.equals("GT-I9000") || Build.DEVICE.equals("crespo")) {
            Object object = new CaptureCapabilityAndroid();
            ((CaptureCapabilityAndroid)object).width = 352;
            ((CaptureCapabilityAndroid)object).height = 288;
            ((CaptureCapabilityAndroid)object).maxFPS = 15;
            this.AddDeviceSpecificCapability((CaptureCapabilityAndroid)object);
            object = new CaptureCapabilityAndroid();
            ((CaptureCapabilityAndroid)object).width = 176;
            ((CaptureCapabilityAndroid)object).height = 144;
            ((CaptureCapabilityAndroid)object).maxFPS = 15;
            this.AddDeviceSpecificCapability((CaptureCapabilityAndroid)object);
            object = new CaptureCapabilityAndroid();
            ((CaptureCapabilityAndroid)object).width = 320;
            ((CaptureCapabilityAndroid)object).height = 240;
            ((CaptureCapabilityAndroid)object).maxFPS = 15;
            this.AddDeviceSpecificCapability((CaptureCapabilityAndroid)object);
        }
        if (Build.MANUFACTURER.equals("motorola") && Build.DEVICE.equals("umts_sholes")) {
            for (AndroidVideoCaptureDevice androidVideoCaptureDevice : this.deviceList) {
                for (CaptureCapabilityAndroid captureCapabilityAndroid : androidVideoCaptureDevice.captureCapabilies) {
                    captureCapabilityAndroid.maxFPS = 15;
                }
            }
        }
    }

    private void AddDeviceSpecificCapability(CaptureCapabilityAndroid captureCapabilityAndroid) {
        for (AndroidVideoCaptureDevice androidVideoCaptureDevice : this.deviceList) {
            boolean bl = false;
            for (CaptureCapabilityAndroid captureCapabilityAndroid2 : androidVideoCaptureDevice.captureCapabilies) {
                if (captureCapabilityAndroid2.width != captureCapabilityAndroid.width || captureCapabilityAndroid2.height != captureCapabilityAndroid.height) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            CaptureCapabilityAndroid[] captureCapabilityAndroidArray = new CaptureCapabilityAndroid[androidVideoCaptureDevice.captureCapabilies.length + 1];
            for (int i = 0; i < androidVideoCaptureDevice.captureCapabilies.length; ++i) {
                captureCapabilityAndroidArray[i + 1] = androidVideoCaptureDevice.captureCapabilies[i];
            }
            captureCapabilityAndroidArray[0] = captureCapabilityAndroid;
            androidVideoCaptureDevice.captureCapabilies = captureCapabilityAndroidArray;
        }
    }

    @WebRTCJNITarget
    public int NumberOfDevices() {
        return this.deviceList.size();
    }

    @WebRTCJNITarget
    public String GetDeviceUniqueName(int n) {
        if (n < 0 || n >= this.deviceList.size()) {
            return null;
        }
        return this.deviceList.get((int)n).deviceUniqueName;
    }

    @WebRTCJNITarget
    public CaptureCapabilityAndroid[] GetCapabilityArray(String string) {
        for (AndroidVideoCaptureDevice androidVideoCaptureDevice : this.deviceList) {
            if (!androidVideoCaptureDevice.deviceUniqueName.equals(string)) continue;
            return androidVideoCaptureDevice.captureCapabilies;
        }
        return null;
    }

    @WebRTCJNITarget
    public int GetOrientation(String string) {
        for (AndroidVideoCaptureDevice androidVideoCaptureDevice : this.deviceList) {
            if (!androidVideoCaptureDevice.deviceUniqueName.equals(string)) continue;
            return androidVideoCaptureDevice.orientation;
        }
        return -1;
    }

    @WebRTCJNITarget
    public VideoCaptureAndroid AllocateCamera(int n, long l, String string) {
        try {
            Log.d((String)TAG, (String)("AllocateCamera " + string));
            Camera camera = null;
            int n2 = 0;
            AndroidVideoCaptureDevice androidVideoCaptureDevice = null;
            block9: for (AndroidVideoCaptureDevice androidVideoCaptureDevice2 : this.deviceList) {
                if (!androidVideoCaptureDevice2.deviceUniqueName.equals(string)) continue;
                androidVideoCaptureDevice = androidVideoCaptureDevice2;
                switch (androidVideoCaptureDevice2.frontCameraType) {
                    case GalaxyS: {
                        camera = this.AllocateGalaxySFrontCamera();
                        continue block9;
                    }
                    case HTCEvo: {
                        camera = this.AllocateEVOFrontFacingCamera();
                        continue block9;
                    }
                }
                if (Build.VERSION.SDK_INT > 8) {
                    n2 = androidVideoCaptureDevice2.index;
                    camera = Camera.open((int)androidVideoCaptureDevice2.index);
                    continue;
                }
                camera = Camera.open();
            }
            if (camera == null) {
                return null;
            }
            Log.v((String)TAG, (String)"AllocateCamera - creating VideoCaptureAndroid");
            return new VideoCaptureAndroid(n, l, camera, androidVideoCaptureDevice, n2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e((String)TAG, (String)"AllocateCamera Failed to open camera", (Throwable)noSuchMethodException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.e((String)TAG, (String)"AllocateCamera Failed to open camera", (Throwable)classNotFoundException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)TAG, (String)"AllocateCamera Failed to open camera", (Throwable)invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)TAG, (String)"AllocateCamera Failed to open camera", (Throwable)illegalAccessException);
        }
        return null;
    }

    @WebRTCJNITarget
    private Camera.Parameters SearchOldFrontFacingCameras(AndroidVideoCaptureDevice androidVideoCaptureDevice) throws SecurityException, IllegalArgumentException, NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        Camera camera = Camera.open();
        Camera.Parameters parameters = camera.getParameters();
        String string = parameters.get("camera-id");
        if (string != null && string.equals("1")) {
            parameters.set("camera-id", 2);
            camera.setParameters(parameters);
            parameters = camera.getParameters();
            androidVideoCaptureDevice.frontCameraType = FrontFacingCameraType.GalaxyS;
            androidVideoCaptureDevice.orientation = 0;
            camera.release();
            return parameters;
        }
        camera.release();
        File file = new File("/system/framework/com.htc.hardware.twinCamDevice.jar");
        boolean bl = file.exists();
        if (!bl) {
            file = new File("/system/framework/com.sprint.hardware.twinCamDevice.jar");
            bl = file.exists();
        }
        if (bl) {
            androidVideoCaptureDevice.frontCameraType = FrontFacingCameraType.HTCEvo;
            androidVideoCaptureDevice.orientation = 0;
            Camera camera2 = this.AllocateEVOFrontFacingCamera();
            parameters = camera2.getParameters();
            camera2.release();
            return parameters;
        }
        return null;
    }

    private Camera AllocateEVOFrontFacingCamera() throws SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        File file;
        String string = null;
        File file2 = new File("/system/framework/com.htc.hardware.twinCamDevice.jar");
        string = "com.htc.hardware.twinCamDevice.FrontFacingCamera";
        boolean bl = file2.exists();
        if (!bl) {
            file2 = new File("/system/framework/com.sprint.hardware.twinCamDevice.jar");
            string = "com.sprint.hardware.twinCamDevice.FrontFacingCamera";
            bl = file2.exists();
        }
        if (!bl) {
            return null;
        }
        String string2 = "";
        if (this.context == null || (file = new File(string2 = this.context.getFilesDir().getAbsolutePath(), "dexfiles")).exists() || !file.mkdirs()) {
            // empty if block
        }
        string2 = string2 + "/dexfiles";
        file = new DexClassLoader(file2.getAbsolutePath(), string2, null, ClassLoader.getSystemClassLoader());
        Method method = file.loadClass(string).getDeclaredMethod("getFrontFacingCamera", null);
        Camera camera = (Camera)method.invoke((Object)null, (Object[])null);
        return camera;
    }

    private Camera AllocateGalaxySFrontCamera() {
        Camera camera = Camera.open();
        Camera.Parameters parameters = camera.getParameters();
        parameters.set("camera-id", 2);
        camera.setParameters(parameters);
        return camera;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FrontFacingCameraType {
        None,
        GalaxyS,
        HTCEvo,
        Android23;

    }

    @WebRTCJNITarget
    public class AndroidVideoCaptureDevice {
        public String deviceUniqueName;
        public CaptureCapabilityAndroid[] captureCapabilies;
        public FrontFacingCameraType frontCameraType = FrontFacingCameraType.None;
        public int orientation;
        public int index = 0;

        AndroidVideoCaptureDevice() {
        }
    }
}

