/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.mozglue.JNITarget;

public class GeckoNetworkManager
extends BroadcastReceiver {
    private static final String LOGTAG = "GeckoNetworkManager";
    private static final GeckoNetworkManager sInstance = new GeckoNetworkManager();
    private static final double kDefaultBandwidth = -1.0;
    private static final boolean kDefaultCanBeMetered = false;
    private static final double kMaxBandwidth = 20.0;
    private static final double kNetworkSpeedEthernet = 20.0;
    private static final double kNetworkSpeedWifi = 20.0;
    private static final double kNetworkSpeedWiMax = 40.0;
    private static final double kNetworkSpeed_2_G = 0.0146484375;
    private static final double kNetworkSpeed_2_5_G = 0.05859375;
    private static final double kNetworkSpeed_2_75_G = 0.1953125;
    private static final double kNetworkSpeed_3_G = 0.29296875;
    private static final double kNetworkSpeed_3_5_G = 7.0;
    private static final double kNetworkSpeed_3_75_G = 20.0;
    private static final double kNetworkSpeed_3_9_G = 50.0;
    private Context mApplicationContext;
    private NetworkType mNetworkType = NetworkType.NETWORK_NONE;
    private IntentFilter mNetworkFilter = new IntentFilter();
    private boolean mShouldBeListening = false;
    private boolean mShouldNotify = false;

    public static GeckoNetworkManager getInstance() {
        return sInstance;
    }

    public void onReceive(Context context, Intent intent) {
        this.updateNetworkType();
    }

    public void init(Context context) {
        this.mApplicationContext = context.getApplicationContext();
        this.mNetworkFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mNetworkType = GeckoNetworkManager.getNetworkType();
    }

    public void start() {
        this.mShouldBeListening = true;
        this.updateNetworkType();
        if (this.mShouldNotify) {
            this.startListening();
        }
    }

    private void startListening() {
        this.mApplicationContext.registerReceiver((BroadcastReceiver)sInstance, this.mNetworkFilter);
    }

    public void stop() {
        this.mShouldBeListening = false;
        if (this.mShouldNotify) {
            this.stopListening();
        }
    }

    private void stopListening() {
        this.mApplicationContext.unregisterReceiver((BroadcastReceiver)sInstance);
    }

    private int wifiDhcpGatewayAddress() {
        if (this.mNetworkType != NetworkType.NETWORK_WIFI) {
            return 0;
        }
        try {
            WifiManager wifiManager = (WifiManager)GeckoNetworkManager.sInstance.mApplicationContext.getSystemService("wifi");
            DhcpInfo dhcpInfo = wifiManager.getDhcpInfo();
            if (dhcpInfo == null) {
                return 0;
            }
            return dhcpInfo.gateway;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void updateNetworkType() {
        NetworkType networkType = this.mNetworkType;
        this.mNetworkType = GeckoNetworkManager.getNetworkType();
        if (this.mNetworkType == networkType || !this.mShouldNotify) {
            return;
        }
        GeckoAppShell.sendEventToGecko(GeckoEvent.createNetworkEvent(GeckoNetworkManager.getNetworkSpeed(this.mNetworkType), GeckoNetworkManager.isNetworkUsuallyMetered(this.mNetworkType), this.mNetworkType == NetworkType.NETWORK_WIFI, this.wifiDhcpGatewayAddress()));
    }

    public double[] getCurrentInformation() {
        return new double[]{GeckoNetworkManager.getNetworkSpeed(this.mNetworkType), GeckoNetworkManager.isNetworkUsuallyMetered(this.mNetworkType) ? 1.0 : 0.0, this.mNetworkType == NetworkType.NETWORK_WIFI ? 1.0 : 0.0, this.wifiDhcpGatewayAddress()};
    }

    public void enableNotifications() {
        this.mNetworkType = NetworkType.NETWORK_NONE;
        this.updateNetworkType();
        this.mShouldNotify = true;
        if (this.mShouldBeListening) {
            this.startListening();
        }
    }

    public void disableNotifications() {
        this.mShouldNotify = false;
        if (this.mShouldBeListening) {
            this.stopListening();
        }
    }

    private static NetworkType getNetworkType() {
        ConnectivityManager connectivityManager = (ConnectivityManager)GeckoNetworkManager.sInstance.mApplicationContext.getSystemService("connectivity");
        if (connectivityManager == null) {
            Log.e((String)LOGTAG, (String)"Connectivity service does not exist");
            return NetworkType.NETWORK_NONE;
        }
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (networkInfo == null) {
            return NetworkType.NETWORK_NONE;
        }
        switch (networkInfo.getType()) {
            case 9: {
                return NetworkType.NETWORK_ETHERNET;
            }
            case 1: {
                return NetworkType.NETWORK_WIFI;
            }
            case 6: {
                return NetworkType.NETWORK_WIMAX;
            }
            case 0: {
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)"Ignoring the current network type.");
                return NetworkType.NETWORK_UNKNOWN;
            }
        }
        TelephonyManager telephonyManager = (TelephonyManager)GeckoNetworkManager.sInstance.mApplicationContext.getSystemService("phone");
        if (telephonyManager == null) {
            Log.e((String)LOGTAG, (String)"Telephony service does not exist");
            return NetworkType.NETWORK_UNKNOWN;
        }
        switch (telephonyManager.getNetworkType()) {
            case 4: 
            case 11: {
                return NetworkType.NETWORK_2_G;
            }
            case 1: 
            case 7: {
                return NetworkType.NETWORK_2_5_G;
            }
            case 2: {
                return NetworkType.NETWORK_2_75_G;
            }
            case 3: 
            case 5: {
                return NetworkType.NETWORK_3_G;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: {
                return NetworkType.NETWORK_3_5_G;
            }
            case 15: {
                return NetworkType.NETWORK_3_75_G;
            }
            case 13: {
                return NetworkType.NETWORK_3_9_G;
            }
        }
        Log.w((String)LOGTAG, (String)"Connected to an unknown mobile network!");
        return NetworkType.NETWORK_UNKNOWN;
    }

    private static double getNetworkSpeed(NetworkType networkType) {
        switch (networkType) {
            case NETWORK_NONE: {
                return 0.0;
            }
            case NETWORK_ETHERNET: {
                return 20.0;
            }
            case NETWORK_WIFI: {
                return 20.0;
            }
            case NETWORK_WIMAX: {
                return 40.0;
            }
            case NETWORK_2_G: {
                return 0.0146484375;
            }
            case NETWORK_2_5_G: {
                return 0.05859375;
            }
            case NETWORK_2_75_G: {
                return 0.1953125;
            }
            case NETWORK_3_G: {
                return 0.29296875;
            }
            case NETWORK_3_5_G: {
                return 7.0;
            }
            case NETWORK_3_75_G: {
                return 20.0;
            }
            case NETWORK_3_9_G: {
                return 50.0;
            }
        }
        return -1.0;
    }

    private static boolean isNetworkUsuallyMetered(NetworkType networkType) {
        switch (networkType) {
            case NETWORK_NONE: 
            case NETWORK_ETHERNET: 
            case NETWORK_WIFI: 
            case NETWORK_WIMAX: 
            case NETWORK_UNKNOWN: {
                return false;
            }
            case NETWORK_2_G: 
            case NETWORK_2_5_G: 
            case NETWORK_2_75_G: 
            case NETWORK_3_G: 
            case NETWORK_3_5_G: 
            case NETWORK_3_75_G: 
            case NETWORK_3_9_G: {
                return true;
            }
        }
        Log.e((String)LOGTAG, (String)"Got an unexpected network type!");
        return false;
    }

    private static int getNetworkOperator(InfoType infoType) {
        TelephonyManager telephonyManager = (TelephonyManager)GeckoNetworkManager.sInstance.mApplicationContext.getSystemService("phone");
        if (telephonyManager == null) {
            Log.e((String)LOGTAG, (String)"Telephony service does not exist");
            return -1;
        }
        String string2 = telephonyManager.getNetworkOperator();
        if (string2 == null || string2.length() <= 3) {
            return -1;
        }
        if (infoType == InfoType.MNC) {
            return Integer.parseInt(string2.substring(3));
        }
        if (infoType == InfoType.MCC) {
            return Integer.parseInt(string2.substring(0, 3));
        }
        return -1;
    }

    @JNITarget
    public static int getMCC() {
        return GeckoNetworkManager.getNetworkOperator(InfoType.MCC);
    }

    @JNITarget
    public static int getMNC() {
        return GeckoNetworkManager.getNetworkOperator(InfoType.MNC);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum InfoType {
        MCC,
        MNC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NetworkType {
        NETWORK_NONE,
        NETWORK_ETHERNET,
        NETWORK_WIFI,
        NETWORK_WIMAX,
        NETWORK_2_G,
        NETWORK_2_5_G,
        NETWORK_2_75_G,
        NETWORK_3_G,
        NETWORK_3_5_G,
        NETWORK_3_75_G,
        NETWORK_3_9_G,
        NETWORK_UNKNOWN;

    }
}

