/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.fxa;

import ch.boye.httpclientandroidlib.HttpEntity;
import ch.boye.httpclientandroidlib.HttpResponse;
import ch.boye.httpclientandroidlib.client.ClientProtocolException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.Executor;
import javax.crypto.Mac;
import org.json.simple.JSONObject;
import org.mozilla.gecko.background.fxa.FxAccount10AuthDelegate;
import org.mozilla.gecko.background.fxa.FxAccount10CreateDelegate;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.background.fxa.SkewHandler;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.HKDF;
import org.mozilla.gecko.sync.net.AuthHeaderProvider;
import org.mozilla.gecko.sync.net.BaseResource;
import org.mozilla.gecko.sync.net.BaseResourceDelegate;
import org.mozilla.gecko.sync.net.HawkAuthHeaderProvider;
import org.mozilla.gecko.sync.net.Resource;
import org.mozilla.gecko.sync.net.SyncResponse;
import org.mozilla.gecko.sync.net.SyncStorageResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FxAccountClient10 {
    protected static final String LOG_TAG = FxAccountClient10.class.getSimpleName();
    protected static final String VERSION_FRAGMENT = "v1/";
    public static final String JSON_KEY_EMAIL = "email";
    public static final String JSON_KEY_KEYFETCHTOKEN = "keyFetchToken";
    public static final String JSON_KEY_SESSIONTOKEN = "sessionToken";
    public static final String JSON_KEY_UID = "uid";
    public static final String JSON_KEY_VERIFIED = "verified";
    public static final String JSON_KEY_ERROR = "error";
    public static final String JSON_KEY_MESSAGE = "message";
    public static final String JSON_KEY_INFO = "info";
    public static final String JSON_KEY_CODE = "code";
    public static final String JSON_KEY_ERRNO = "errno";
    protected static final String[] requiredErrorStringFields = new String[]{"error", "message", "info"};
    protected static final String[] requiredErrorLongFields = new String[]{"code", "errno"};
    protected final String serverURI;
    protected final Executor executor;

    public FxAccountClient10(String string2, Executor executor) {
        if (string2 == null) {
            throw new IllegalArgumentException("Must provide a server URI.");
        }
        if (executor == null) {
            throw new IllegalArgumentException("Must provide a non-null executor.");
        }
        this.serverURI = (string2.endsWith("/") ? string2 : string2 + "/") + VERSION_FRAGMENT;
        this.executor = executor;
    }

    protected <T> void invokeHandleError(final RequestDelegate<T> requestDelegate, final Exception exception) {
        this.executor.execute(new Runnable(){

            public void run() {
                requestDelegate.handleError(exception);
            }
        });
    }

    protected <T> void post(BaseResource baseResource, JSONObject jSONObject, RequestDelegate<T> requestDelegate) {
        try {
            if (jSONObject == null) {
                baseResource.post((HttpEntity)null);
            } else {
                baseResource.post(jSONObject);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.invokeHandleError(requestDelegate, unsupportedEncodingException);
            return;
        }
    }

    public long now() {
        return System.currentTimeMillis();
    }

    public static int validateResponse(HttpResponse httpResponse) throws FxAccountClientException.FxAccountClientRemoteException {
        String string2;
        String string3;
        String string4;
        int n;
        int n2;
        int n3 = httpResponse.getStatusLine().getStatusCode();
        if (n3 == 200) {
            return n3;
        }
        try {
            ExtendedJSONObject extendedJSONObject = new SyncStorageResponse(httpResponse).jsonObjectBody();
            extendedJSONObject.throwIfFieldsMissingOrMisTyped(requiredErrorStringFields, String.class);
            extendedJSONObject.throwIfFieldsMissingOrMisTyped(requiredErrorLongFields, Long.class);
            n2 = extendedJSONObject.getLong(JSON_KEY_CODE).intValue();
            n = extendedJSONObject.getLong(JSON_KEY_ERRNO).intValue();
            string4 = extendedJSONObject.getString(JSON_KEY_ERROR);
            string3 = extendedJSONObject.getString(JSON_KEY_MESSAGE);
            string2 = extendedJSONObject.getString(JSON_KEY_INFO);
        }
        catch (Exception exception) {
            throw new FxAccountClientException.FxAccountClientMalformedResponseException(httpResponse);
        }
        throw new FxAccountClientException.FxAccountClientRemoteException(httpResponse, n2, n, string4, string3, string2);
    }

    public void createAccount(String string2, byte[] byArray, String string3, String string4, RequestDelegate<String> requestDelegate) {
        try {
            this.createAccount(new FxAccount10CreateDelegate(string2, byArray, string3, string4), requestDelegate);
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
    }

    protected void createAccount(CreateDelegate createDelegate, RequestDelegate<String> requestDelegate) {
        BaseResource baseResource;
        JSONObject jSONObject = null;
        try {
            jSONObject = createDelegate.getCreateBody();
        }
        catch (FxAccountClientException fxAccountClientException) {
            this.invokeHandleError(requestDelegate, fxAccountClientException);
            return;
        }
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "account/create"));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.invokeHandleError(requestDelegate, uRISyntaxException);
            return;
        }
        baseResource.delegate = new ResourceDelegate<String>((Resource)baseResource, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                String string2 = extendedJSONObject.getString(FxAccountClient10.JSON_KEY_UID);
                if (string2 == null) {
                    this.delegate.handleError(new FxAccountClientException("uid must be a non-null string"));
                    return;
                }
                this.delegate.handleSuccess(string2);
            }
        };
        this.post(baseResource, jSONObject, requestDelegate);
    }

    protected void authStart(final AuthDelegate authDelegate, RequestDelegate<AuthDelegate> requestDelegate) {
        BaseResource baseResource;
        JSONObject jSONObject;
        try {
            jSONObject = authDelegate.getAuthStartBody();
        }
        catch (FxAccountClientException fxAccountClientException) {
            this.invokeHandleError(requestDelegate, fxAccountClientException);
            return;
        }
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "auth/start"));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.invokeHandleError(requestDelegate, uRISyntaxException);
            return;
        }
        baseResource.delegate = new ResourceDelegate<AuthDelegate>((Resource)baseResource, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    authDelegate.onAuthStartResponse(extendedJSONObject);
                    this.delegate.handleSuccess(authDelegate);
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        this.post(baseResource, jSONObject, requestDelegate);
    }

    protected void authFinish(final AuthDelegate authDelegate, RequestDelegate<byte[]> requestDelegate) {
        BaseResource baseResource;
        JSONObject jSONObject;
        try {
            jSONObject = authDelegate.getAuthFinishBody();
        }
        catch (FxAccountClientException fxAccountClientException) {
            this.invokeHandleError(requestDelegate, fxAccountClientException);
            return;
        }
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "auth/finish"));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.invokeHandleError(requestDelegate, uRISyntaxException);
            return;
        }
        baseResource.delegate = new ResourceDelegate<byte[]>((Resource)baseResource, requestDelegate){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    byte[] byArray = new byte[32];
                    FxAccountClient10.this.unbundleBody(extendedJSONObject, authDelegate.getSharedBytes(), FxAccountUtils.KW("auth/finish"), new byte[][]{byArray});
                    this.delegate.handleSuccess(byArray);
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        this.post(baseResource, jSONObject, requestDelegate);
    }

    public void login(String string2, byte[] byArray, RequestDelegate<byte[]> requestDelegate) {
        this.login(new FxAccount10AuthDelegate(string2, byArray), requestDelegate);
    }

    protected void login(AuthDelegate authDelegate, final RequestDelegate<byte[]> requestDelegate) {
        this.authStart(authDelegate, new RequestDelegate<AuthDelegate>(){

            @Override
            public void handleSuccess(AuthDelegate authDelegate) {
                FxAccountClient10.this.authFinish(authDelegate, requestDelegate);
            }

            @Override
            public void handleError(Exception exception) {
                FxAccountClient10.this.invokeHandleError(requestDelegate, exception);
            }

            @Override
            public void handleFailure(final FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
                FxAccountClient10.this.executor.execute(new Runnable(){

                    public void run() {
                        requestDelegate.handleFailure(fxAccountClientRemoteException);
                    }
                });
            }
        });
    }

    public void sessionCreate(byte[] byArray, RequestDelegate<TwoTokens> requestDelegate) {
        BaseResource baseResource;
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        final byte[] byArray4 = new byte[32];
        try {
            HKDF.deriveMany(byArray, new byte[0], FxAccountUtils.KW("authToken"), byArray2, byArray3, byArray4);
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "session/create"));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.invokeHandleError(requestDelegate, uRISyntaxException);
            return;
        }
        baseResource.delegate = new ResourceDelegate<TwoTokens>((Resource)baseResource, requestDelegate, byArray2, byArray3, false){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    byte[] byArray = new byte[32];
                    byte[] byArray2 = new byte[32];
                    FxAccountClient10.this.unbundleBody(extendedJSONObject, byArray4, FxAccountUtils.KW("session/create"), byArray, byArray2);
                    this.delegate.handleSuccess(new TwoTokens(byArray, byArray2));
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        this.post(baseResource, null, requestDelegate);
    }

    public void sessionDestroy(byte[] byArray, RequestDelegate<Void> requestDelegate) {
        BaseResource baseResource;
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        try {
            HKDF.deriveMany(byArray, new byte[0], FxAccountUtils.KW(JSON_KEY_SESSIONTOKEN), byArray2, byArray3);
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "session/destroy"));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.invokeHandleError(requestDelegate, uRISyntaxException);
            return;
        }
        baseResource.delegate = new ResourceDelegate<Void>((Resource)baseResource, requestDelegate, byArray2, byArray3, false){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                this.delegate.handleSuccess(null);
            }
        };
        this.post(baseResource, null, requestDelegate);
    }

    protected void unbundleBytes(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] ... byArray4) throws InvalidKeyException, NoSuchAlgorithmException, FxAccountClientException {
        byte[] byArray52;
        if (byArray.length < 32) {
            throw new IllegalArgumentException("input bundle must include HMAC");
        }
        int n = byArray3.length;
        if (byArray.length != n + 32) {
            throw new IllegalArgumentException("input bundle and XOR key with HMAC have different lengths");
        }
        int n2 = n;
        for (byte[] byArray52 : byArray4) {
            n2 -= byArray52.length;
        }
        if (n2 != 0) {
            throw new IllegalArgumentException("XOR key and total output arrays have different lengths");
        }
        byte[] byArray6 = new byte[n];
        byte[] byArray7 = new byte[32];
        System.arraycopy(byArray, 0, byArray6, 0, n);
        System.arraycopy(byArray, n, byArray7, 0, 32);
        Mac mac = HKDF.makeHMACHasher(byArray2);
        byArray52 = mac.doFinal(byArray6);
        if (!Arrays.equals(byArray52, byArray7)) {
            throw new FxAccountClientException("Bad message HMAC");
        }
        int n3 = 0;
        for (byte[] byArray8 : byArray4) {
            for (int i = 0; i < byArray8.length; ++i) {
                byArray8[i] = (byte)(byArray3[n3 + i] ^ byArray6[n3 + i]);
            }
            n3 += byArray8.length;
        }
    }

    protected void unbundleBody(ExtendedJSONObject extendedJSONObject, byte[] byArray, byte[] byArray2, byte[] ... byArray3) throws Exception {
        byte[] byArray42;
        int n = 0;
        for (byte[] byArray42 : byArray3) {
            n += byArray42.length;
        }
        if (extendedJSONObject == null) {
            throw new FxAccountClientException("body must be non-null");
        }
        String string2 = extendedJSONObject.getString("bundle");
        if (string2 == null) {
            throw new FxAccountClientException("bundle must be a non-null string");
        }
        byte[] byArray5 = Utils.hex2Byte(string2);
        byte[] byArray6 = new byte[32];
        byArray42 = new byte[n];
        HKDF.deriveMany(byArray, new byte[0], byArray2, byArray6, byArray42);
        this.unbundleBytes(byArray5, byArray6, byArray42, byArray3);
    }

    public void keys(byte[] byArray, RequestDelegate<TwoKeys> requestDelegate) {
        BaseResource baseResource;
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        final byte[] byArray4 = new byte[32];
        try {
            HKDF.deriveMany(byArray, new byte[0], FxAccountUtils.KW(JSON_KEY_KEYFETCHTOKEN), byArray2, byArray3, byArray4);
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "account/keys"));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.invokeHandleError(requestDelegate, uRISyntaxException);
            return;
        }
        baseResource.delegate = new ResourceDelegate<TwoKeys>((Resource)baseResource, requestDelegate, byArray2, byArray3, false){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    byte[] byArray = new byte[32];
                    byte[] byArray2 = new byte[32];
                    FxAccountClient10.this.unbundleBody(extendedJSONObject, byArray4, FxAccountUtils.KW("account/keys"), byArray, byArray2);
                    this.delegate.handleSuccess(new TwoKeys(byArray, byArray2));
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        baseResource.get();
    }

    public void status(byte[] byArray, RequestDelegate<StatusResponse> requestDelegate) {
        BaseResource baseResource;
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32];
        try {
            HKDF.deriveMany(byArray, new byte[0], FxAccountUtils.KW(JSON_KEY_SESSIONTOKEN), byArray2, byArray3, byArray4);
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "recovery_email/status"));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.invokeHandleError(requestDelegate, uRISyntaxException);
            return;
        }
        baseResource.delegate = new ResourceDelegate<StatusResponse>((Resource)baseResource, requestDelegate, byArray2, byArray3, false){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    String[] stringArray = new String[]{FxAccountClient10.JSON_KEY_EMAIL};
                    extendedJSONObject.throwIfFieldsMissingOrMisTyped(stringArray, String.class);
                    String string2 = extendedJSONObject.getString(FxAccountClient10.JSON_KEY_EMAIL);
                    Boolean bl = extendedJSONObject.getBoolean(FxAccountClient10.JSON_KEY_VERIFIED);
                    this.delegate.handleSuccess(new StatusResponse(string2, bl));
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        baseResource.get();
    }

    public void sign(byte[] byArray, ExtendedJSONObject extendedJSONObject, long l, RequestDelegate<String> requestDelegate) {
        BaseResource baseResource;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)"publicKey", (Object)extendedJSONObject);
        jSONObject.put((Object)"duration", (Object)l);
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        try {
            HKDF.deriveMany(byArray, new byte[0], FxAccountUtils.KW(JSON_KEY_SESSIONTOKEN), byArray2, byArray3);
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "certificate/sign"));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.invokeHandleError(requestDelegate, uRISyntaxException);
            return;
        }
        baseResource.delegate = new ResourceDelegate<String>((Resource)baseResource, requestDelegate, byArray2, byArray3, true){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                String string2 = extendedJSONObject.getString("cert");
                if (string2 == null) {
                    this.delegate.handleError(new FxAccountClientException("cert must be a non-null string"));
                    return;
                }
                this.delegate.handleSuccess(string2);
            }
        };
        this.post(baseResource, jSONObject, requestDelegate);
    }

    public void resendCode(byte[] byArray, RequestDelegate<Void> requestDelegate) {
        BaseResource baseResource;
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[32];
        byte[] byArray4 = new byte[32];
        try {
            HKDF.deriveMany(byArray, new byte[0], FxAccountUtils.KW(JSON_KEY_SESSIONTOKEN), byArray2, byArray3, byArray4);
        }
        catch (Exception exception) {
            this.invokeHandleError(requestDelegate, exception);
            return;
        }
        try {
            baseResource = new BaseResource(new URI(this.serverURI + "recovery_email/resend_code"));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.invokeHandleError(requestDelegate, uRISyntaxException);
            return;
        }
        baseResource.delegate = new ResourceDelegate<Void>((Resource)baseResource, requestDelegate, byArray2, byArray3, false){

            @Override
            public void handleSuccess(int n, HttpResponse httpResponse, ExtendedJSONObject extendedJSONObject) {
                try {
                    this.delegate.handleSuccess(null);
                    return;
                }
                catch (Exception exception) {
                    this.delegate.handleError(exception);
                    return;
                }
            }
        };
        this.post(baseResource, new JSONObject(), requestDelegate);
    }

    public static class StatusResponse {
        public final String email;
        public final boolean verified;

        public StatusResponse(String string2, boolean bl) {
            this.email = string2;
            this.verified = bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class ResourceDelegate<T>
    extends BaseResourceDelegate {
        protected final RequestDelegate<T> delegate;
        protected final byte[] tokenId;
        protected final byte[] reqHMACKey;
        protected final boolean payload;
        protected final SkewHandler skewHandler;

        protected abstract void handleSuccess(int var1, HttpResponse var2, ExtendedJSONObject var3);

        public ResourceDelegate(Resource resource, RequestDelegate<T> requestDelegate) {
            this(resource, requestDelegate, null, null, false);
        }

        public ResourceDelegate(Resource resource, RequestDelegate<T> requestDelegate, byte[] byArray, byte[] byArray2, boolean bl) {
            super(resource);
            this.delegate = requestDelegate;
            this.reqHMACKey = byArray2;
            this.tokenId = byArray;
            this.payload = bl;
            this.skewHandler = SkewHandler.getSkewHandlerForResource(resource);
        }

        @Override
        public AuthHeaderProvider getAuthHeaderProvider() {
            if (this.tokenId != null && this.reqHMACKey != null) {
                return new HawkAuthHeaderProvider(Utils.byte2Hex(this.tokenId), this.reqHMACKey, this.payload, this.skewHandler.getSkewInSeconds());
            }
            return super.getAuthHeaderProvider();
        }

        @Override
        public void handleHttpResponse(HttpResponse httpResponse) {
            try {
                int n = FxAccountClient10.validateResponse(httpResponse);
                this.skewHandler.updateSkew(httpResponse, FxAccountClient10.this.now());
                this.invokeHandleSuccess(n, httpResponse);
            }
            catch (FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
                if (!this.skewHandler.updateSkew(httpResponse, FxAccountClient10.this.now())) {
                    this.skewHandler.resetSkew();
                }
                this.invokeHandleFailure(fxAccountClientRemoteException);
            }
        }

        protected void invokeHandleFailure(final FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
            FxAccountClient10.this.executor.execute(new Runnable(){

                public void run() {
                    ResourceDelegate.this.delegate.handleFailure(fxAccountClientRemoteException);
                }
            });
        }

        protected void invokeHandleSuccess(final int n, final HttpResponse httpResponse) {
            FxAccountClient10.this.executor.execute(new Runnable(){

                public void run() {
                    try {
                        ExtendedJSONObject extendedJSONObject = new SyncResponse(httpResponse).jsonObjectBody();
                        ResourceDelegate.this.handleSuccess(n, httpResponse, extendedJSONObject);
                    }
                    catch (Exception exception) {
                        ResourceDelegate.this.delegate.handleError(exception);
                    }
                }
            });
        }

        @Override
        public void handleHttpProtocolException(ClientProtocolException clientProtocolException) {
            FxAccountClient10.this.invokeHandleError(this.delegate, (Exception)((Object)clientProtocolException));
        }

        @Override
        public void handleHttpIOException(IOException iOException) {
            FxAccountClient10.this.invokeHandleError(this.delegate, iOException);
        }

        @Override
        public void handleTransportException(GeneralSecurityException generalSecurityException) {
            FxAccountClient10.this.invokeHandleError(this.delegate, generalSecurityException);
        }
    }

    public static class TwoKeys {
        public final byte[] kA;
        public final byte[] wrapkB;

        public TwoKeys(byte[] byArray, byte[] byArray2) {
            this.kA = byArray;
            this.wrapkB = byArray2;
        }
    }

    public static class TwoTokens {
        public final byte[] keyFetchToken;
        public final byte[] sessionToken;

        public TwoTokens(byte[] byArray, byte[] byArray2) {
            this.keyFetchToken = byArray;
            this.sessionToken = byArray2;
        }
    }

    public static interface AuthDelegate {
        public JSONObject getAuthStartBody() throws FxAccountClientException;

        public void onAuthStartResponse(ExtendedJSONObject var1) throws FxAccountClientException;

        public JSONObject getAuthFinishBody() throws FxAccountClientException;

        public byte[] getSharedBytes() throws FxAccountClientException;
    }

    public static interface CreateDelegate {
        public JSONObject getCreateBody() throws FxAccountClientException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RequestDelegate<T> {
        public void handleError(Exception var1);

        public void handleFailure(FxAccountClientException.FxAccountClientRemoteException var1);

        public void handleSuccess(T var1);
    }
}

