/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.cache;

import android.graphics.Bitmap;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import org.mozilla.gecko.favicons.cache.FaviconCacheElement;
import org.mozilla.gecko.gfx.BitmapUtils;

public class FaviconsForURL {
    private static final String LOGTAG = "FaviconForURL";
    private volatile int mDominantColor = -1;
    final long mDownloadTimestamp;
    final ArrayList<FaviconCacheElement> mFavicons;
    public final boolean mHasFailed;

    public FaviconsForURL(int n) {
        this(n, false);
    }

    public FaviconsForURL(int n, boolean bl) {
        this.mHasFailed = bl;
        this.mDownloadTimestamp = System.currentTimeMillis();
        this.mFavicons = new ArrayList(n);
    }

    public FaviconCacheElement addSecondary(Bitmap bitmap, int n) {
        return this.addInternal(bitmap, false, n);
    }

    public FaviconCacheElement addPrimary(Bitmap bitmap) {
        return this.addInternal(bitmap, true, bitmap.getWidth());
    }

    private FaviconCacheElement addInternal(Bitmap bitmap, boolean bl, int n) {
        FaviconCacheElement faviconCacheElement = new FaviconCacheElement(bitmap, bl, n, this);
        int n2 = Collections.binarySearch(this.mFavicons, faviconCacheElement);
        if (n2 < 0) {
            ++n2;
            n2 = -n2;
        }
        this.mFavicons.add(n2, faviconCacheElement);
        return faviconCacheElement;
    }

    public int getNextHighestIndex(int n) {
        FaviconCacheElement faviconCacheElement = new FaviconCacheElement(null, false, n, null);
        int n2 = Collections.binarySearch(this.mFavicons, faviconCacheElement);
        if (n2 < 0) {
            ++n2;
            n2 = -n2;
        }
        if (n2 == this.mFavicons.size()) {
            n2 = -1;
        }
        return n2;
    }

    public FaviconCacheElement getNextPrimary(int n) {
        FaviconCacheElement faviconCacheElement;
        int n2;
        int n3 = this.mFavicons.size();
        for (n2 = n; n2 < n3; ++n2) {
            faviconCacheElement = this.mFavicons.get(n2);
            if (!faviconCacheElement.mIsPrimary) continue;
            if (faviconCacheElement.mInvalidated) {
                return null;
            }
            return faviconCacheElement;
        }
        for (n2 = n - 1; n2 >= 0; --n2) {
            faviconCacheElement = this.mFavicons.get(n2);
            if (!faviconCacheElement.mIsPrimary) continue;
            if (faviconCacheElement.mInvalidated) {
                return null;
            }
            return faviconCacheElement;
        }
        Log.e((String)LOGTAG, (String)"No primaries found in Favicon cache structure. This is madness!");
        return null;
    }

    public int ensureDominantColor() {
        if (this.mDominantColor == -1) {
            for (FaviconCacheElement faviconCacheElement : this.mFavicons) {
                if (faviconCacheElement.mInvalidated) continue;
                this.mDominantColor = BitmapUtils.getDominantColor(faviconCacheElement.mFaviconPayload);
                return this.mDominantColor;
            }
            this.mDominantColor = 0xFFFFFF;
        }
        return this.mDominantColor;
    }
}

