/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.decoders;

import android.graphics.Bitmap;
import android.util.SparseArray;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.mozilla.gecko.favicons.Favicons;
import org.mozilla.gecko.favicons.decoders.IconDirectoryEntry;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;
import org.mozilla.gecko.gfx.BitmapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICODecoder
implements Iterable<Bitmap> {
    public static final int COMPACT_THRESHOLD = 4000;
    public static final int ICO_HEADER_LENGTH_BYTES = 6;
    public static final int ICO_ICONDIRENTRY_LENGTH_BYTES = 16;
    private byte[] mDecodand;
    private int mOffset;
    private int mLen;
    private IconDirectoryEntry[] mIconDirectory;
    private boolean mIsValid;
    private boolean mHasDecoded;

    public ICODecoder(byte[] byArray, int n, int n2) {
        this.mDecodand = byArray;
        this.mOffset = n;
        this.mLen = n2;
    }

    private boolean decodeIconDirectoryAndPossiblyPrune() {
        this.mHasDecoded = true;
        if (this.mOffset + this.mLen > this.mDecodand.length) {
            return false;
        }
        if (this.mLen < 6) {
            return false;
        }
        if (this.mDecodand[this.mOffset] != 0 || this.mDecodand[this.mOffset + 1] != 0 || this.mDecodand[this.mOffset + 2] != 1 || this.mDecodand[this.mOffset + 3] != 0) {
            return false;
        }
        int n = this.mDecodand[this.mOffset + 4] & 0xFF | (this.mDecodand[this.mOffset + 5] & 0xFF) << 8;
        if (n <= 0) {
            return false;
        }
        int n2 = 6 + n * 16;
        if (this.mLen < n2) {
            return false;
        }
        int n3 = this.mOffset + 6;
        int n4 = Integer.MAX_VALUE;
        SparseArray sparseArray = new SparseArray();
        int n5 = 0;
        while (n5 < n) {
            block15: {
                IconDirectoryEntry iconDirectoryEntry;
                IconDirectoryEntry iconDirectoryEntry2;
                block16: {
                    iconDirectoryEntry2 = IconDirectoryEntry.createFromBuffer(this.mDecodand, this.mOffset, this.mLen, n3);
                    iconDirectoryEntry2.mIndex = n5;
                    if (iconDirectoryEntry2.mIsErroneous) break block15;
                    if (iconDirectoryEntry2.mWidth <= Favicons.sLargestFaviconSize) break block16;
                    if (iconDirectoryEntry2.mWidth >= n4) break block15;
                    sparseArray.delete(n4);
                    n4 = iconDirectoryEntry2.mWidth;
                }
                if ((iconDirectoryEntry = (IconDirectoryEntry)sparseArray.get(iconDirectoryEntry2.mWidth)) == null) {
                    sparseArray.put(iconDirectoryEntry2.mWidth, (Object)iconDirectoryEntry2);
                } else if (iconDirectoryEntry.compareTo(iconDirectoryEntry2) < 0) {
                    sparseArray.put(iconDirectoryEntry2.mWidth, (Object)iconDirectoryEntry2);
                }
            }
            ++n5;
            n3 += 16;
        }
        n5 = sparseArray.size();
        if (n5 == 0) {
            return false;
        }
        this.mIconDirectory = new IconDirectoryEntry[n5];
        int n6 = 6;
        for (int i = 0; i < n5; ++i) {
            IconDirectoryEntry iconDirectoryEntry = (IconDirectoryEntry)sparseArray.valueAt(i);
            n6 += 16 + iconDirectoryEntry.mPayloadSize;
            this.mIconDirectory[i] = iconDirectoryEntry;
        }
        this.mIsValid = true;
        this.mDecodand[this.mOffset + 4] = (byte)this.mIconDirectory.length;
        this.mDecodand[this.mOffset + 5] = (byte)(this.mIconDirectory.length >>> 8);
        if (this.mLen - n6 > 4000) {
            this.compactingCopy(n6);
        }
        return true;
    }

    private void compactingCopy(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.mDecodand, this.mOffset, byArray, 0, 6);
        int n2 = 6;
        int n3 = 6 + this.mIconDirectory.length * 16;
        int n4 = 0;
        for (IconDirectoryEntry iconDirectoryEntry : this.mIconDirectory) {
            System.arraycopy(this.mDecodand, this.mOffset + iconDirectoryEntry.getOffset(), byArray, n2, 16);
            System.arraycopy(this.mDecodand, this.mOffset + iconDirectoryEntry.mPayloadOffset, byArray, n3, iconDirectoryEntry.mPayloadSize);
            byArray[n2 + 12] = (byte)n3;
            byArray[n2 + 13] = (byte)(n3 >>> 8);
            byArray[n2 + 14] = (byte)(n3 >>> 16);
            byArray[n2 + 15] = (byte)(n3 >>> 24);
            iconDirectoryEntry.mPayloadOffset = n3;
            iconDirectoryEntry.mIndex = n4++;
            n3 += iconDirectoryEntry.mPayloadSize;
            n2 += 16;
        }
        this.mDecodand = byArray;
        this.mOffset = 0;
        this.mLen = n;
    }

    public Bitmap decodeBitmapAtIndex(int n) {
        IconDirectoryEntry iconDirectoryEntry = this.mIconDirectory[n];
        if (iconDirectoryEntry.mPayloadIsPNG) {
            return BitmapUtils.decodeByteArray(this.mDecodand, this.mOffset + iconDirectoryEntry.mPayloadOffset, iconDirectoryEntry.mPayloadSize);
        }
        byte[] byArray = new byte[22 + iconDirectoryEntry.mPayloadSize];
        byArray[2] = 1;
        byArray[4] = 1;
        System.arraycopy(this.mDecodand, this.mOffset + iconDirectoryEntry.getOffset(), byArray, 6, 16);
        System.arraycopy(this.mDecodand, this.mOffset + iconDirectoryEntry.mPayloadOffset, byArray, 22, iconDirectoryEntry.mPayloadSize);
        byArray[18] = 22;
        byArray[19] = 0;
        byArray[20] = 0;
        byArray[21] = 0;
        return BitmapUtils.decodeByteArray(byArray);
    }

    public ICOIterator iterator() {
        if (this.mHasDecoded && !this.mIsValid) {
            return null;
        }
        if (!this.mHasDecoded && !this.decodeIconDirectoryAndPossiblyPrune()) {
            return null;
        }
        return new ICOIterator();
    }

    public LoadFaviconResult decode() {
        ICOIterator iCOIterator = this.iterator();
        if (iCOIterator == null) {
            return null;
        }
        LoadFaviconResult loadFaviconResult = new LoadFaviconResult();
        loadFaviconResult.mBitmapsDecoded = iCOIterator;
        loadFaviconResult.mFaviconBytes = this.mDecodand;
        loadFaviconResult.mOffset = this.mOffset;
        loadFaviconResult.mLength = this.mLen;
        loadFaviconResult.mIsICO = true;
        return loadFaviconResult;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ICOIterator
    implements Iterator<Bitmap> {
        private int mIndex = 0;

        private ICOIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mIndex < ICODecoder.this.mIconDirectory.length;
        }

        @Override
        public Bitmap next() {
            if (this.mIndex > ICODecoder.this.mIconDirectory.length) {
                throw new NoSuchElementException("No more elements in this ICO.");
            }
            return ICODecoder.this.decodeBitmapAtIndex(this.mIndex++);
        }

        @Override
        public void remove() {
            if (ICODecoder.this.mIconDirectory[this.mIndex] == null) {
                throw new IllegalStateException("Remove already called for element " + this.mIndex);
            }
            ((ICODecoder)ICODecoder.this).mIconDirectory[this.mIndex] = null;
        }
    }
}

