/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.decoders;

import org.mozilla.gecko.favicons.decoders.FaviconDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconDirectoryEntry
implements Comparable<IconDirectoryEntry> {
    public static int sMaxBPP;
    int mWidth;
    int mHeight;
    int mPaletteSize;
    int mBitsPerPixel;
    int mPayloadSize;
    int mPayloadOffset;
    boolean mPayloadIsPNG;
    int mIndex;
    boolean mIsErroneous;

    public IconDirectoryEntry(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.mWidth = n;
        this.mHeight = n2;
        this.mPaletteSize = n3;
        this.mBitsPerPixel = n4;
        this.mPayloadSize = n5;
        this.mPayloadOffset = n6;
        this.mPayloadIsPNG = bl;
    }

    public static IconDirectoryEntry getErroneousEntry() {
        IconDirectoryEntry iconDirectoryEntry = new IconDirectoryEntry(-1, -1, -1, -1, -1, -1, false);
        iconDirectoryEntry.mIsErroneous = true;
        return iconDirectoryEntry;
    }

    public static IconDirectoryEntry createFromBuffer(byte[] byArray, int n, int n2, int n3) {
        int n4;
        if (byArray[n3 + 3] != 0) {
            return IconDirectoryEntry.getErroneousEntry();
        }
        int n5 = n3 + 8;
        int n6 = byArray[n5] & 0xFF | (byArray[n5 + 1] & 0xFF) << 8 | (byArray[n5 + 2] & 0xFF) << 16 | (byArray[n5 + 3] & 0xFF) << 24;
        if ((n4 = byArray[n5 += 4] & 0xFF | (byArray[n5 + 1] & 0xFF) << 8 | (byArray[n5 + 2] & 0xFF) << 16 | (byArray[n5 + 3] & 0xFF) << 24) < 0 || n6 < 0 || n4 + n6 > n + n2) {
            return IconDirectoryEntry.getErroneousEntry();
        }
        int n7 = byArray[n3] & 0xFF;
        int n8 = byArray[n3 + 1] & 0xFF;
        if (n7 == 0) {
            n7 = 256;
        }
        if (n8 == 0) {
            n8 = 256;
        }
        int n9 = byArray[n3 + 2] & 0xFF;
        int n10 = byArray[n3 + 4] & 0xFF;
        int n11 = byArray[n3 + 6] & 0xFF | (byArray[n3 + 7] & 0xFF) << 8;
        if (n10 > 1) {
            n11 *= n10;
        }
        boolean bl = FaviconDecoder.bufferStartsWith(byArray, FaviconDecoder.ImageMagicNumbers.PNG.value, n + n4);
        return new IconDirectoryEntry(n7, n8, n9, n11, n6, n4, bl);
    }

    public int getOffset() {
        return 6 + this.mIndex * 16;
    }

    @Override
    public int compareTo(IconDirectoryEntry iconDirectoryEntry) {
        if (this.mWidth > iconDirectoryEntry.mWidth) {
            return 1;
        }
        if (this.mWidth < iconDirectoryEntry.mWidth) {
            return -1;
        }
        if (this.mBitsPerPixel >= sMaxBPP && iconDirectoryEntry.mBitsPerPixel >= sMaxBPP) {
            if (this.mBitsPerPixel < iconDirectoryEntry.mBitsPerPixel) {
                return 1;
            }
            if (this.mBitsPerPixel > iconDirectoryEntry.mBitsPerPixel) {
                return -1;
            }
        }
        if (this.mBitsPerPixel > iconDirectoryEntry.mBitsPerPixel) {
            return 1;
        }
        if (this.mBitsPerPixel < iconDirectoryEntry.mBitsPerPixel) {
            return -1;
        }
        if (this.mPaletteSize > iconDirectoryEntry.mPaletteSize) {
            return 1;
        }
        if (this.mPaletteSize < iconDirectoryEntry.mPaletteSize) {
            return -1;
        }
        if (this.mPayloadSize < iconDirectoryEntry.mPayloadSize) {
            return 1;
        }
        if (this.mPayloadSize > iconDirectoryEntry.mPayloadSize) {
            return -1;
        }
        if (this.mPayloadIsPNG && !iconDirectoryEntry.mPayloadIsPNG) {
            return 1;
        }
        if (!this.mPayloadIsPNG && iconDirectoryEntry.mPayloadIsPNG) {
            return -1;
        }
        return 0;
    }

    public static void setMaxBPP(int n) {
        sMaxBPP = n;
    }

    public String toString() {
        return "IconDirectoryEntry{\nmWidth=" + this.mWidth + ", \nmHeight=" + this.mHeight + ", \nmPaletteSize=" + this.mPaletteSize + ", \nmBitsPerPixel=" + this.mBitsPerPixel + ", \nmPayloadSize=" + this.mPayloadSize + ", \nmPayloadOffset=" + this.mPayloadOffset + ", \nmPayloadIsPNG=" + this.mPayloadIsPNG + ", \nmIndex=" + this.mIndex + '}';
    }
}

