/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.favicons.decoders;

import android.graphics.Bitmap;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.mozilla.gecko.favicons.decoders.FaviconDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFaviconResult {
    private static final String LOGTAG = "LoadFaviconResult";
    byte[] mFaviconBytes;
    int mOffset;
    int mLength;
    boolean mIsICO;
    Iterator<Bitmap> mBitmapsDecoded;

    public Iterator<Bitmap> getBitmaps() {
        return this.mBitmapsDecoded;
    }

    public byte[] getBytesForDatabaseStorage() {
        Object object;
        if (this.mOffset != 0 || this.mLength != this.mFaviconBytes.length) {
            object = new byte[this.mLength];
            System.arraycopy(this.mFaviconBytes, this.mOffset, object, 0, this.mLength);
            this.mOffset = 0;
            this.mFaviconBytes = object;
        }
        if (!this.mIsICO) {
            object = ((FaviconDecoder.SingleBitmapIterator)this.mBitmapsDecoded).peek();
            byte[] byArray = null;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (object.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream)) {
                byArray = byteArrayOutputStream.toByteArray();
            } else {
                Log.w((String)LOGTAG, (String)"Favicon compression failed.");
            }
            return byArray;
        }
        return this.mFaviconBytes;
    }
}

