/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mozilla.gecko.R;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.fxa.FxAccountClient10;
import org.mozilla.gecko.background.fxa.FxAccountClient20;
import org.mozilla.gecko.background.fxa.FxAccountClientException;
import org.mozilla.gecko.background.fxa.FxAccountUtils;
import org.mozilla.gecko.fxa.FxAccountConstants;
import org.mozilla.gecko.fxa.activities.FxAccountAbstractSetupActivity;
import org.mozilla.gecko.fxa.activities.FxAccountConfirmAccountActivity;
import org.mozilla.gecko.fxa.activities.FxAccountCreateAccountActivity;
import org.mozilla.gecko.fxa.activities.FxAccountSetupTask;
import org.mozilla.gecko.fxa.activities.FxAccountVerifiedAccountActivity;
import org.mozilla.gecko.fxa.authenticator.AndroidFxAccount;
import org.mozilla.gecko.fxa.login.Engaged;

public class FxAccountSignInActivity
extends FxAccountAbstractSetupActivity {
    protected static final String LOG_TAG = FxAccountSignInActivity.class.getSimpleName();
    private static final int CHILD_REQUEST_CODE = 3;

    public void onCreate(Bundle bundle) {
        Logger.debug(LOG_TAG, "onCreate(" + bundle + ")");
        super.onCreate(bundle);
        this.setContentView(R.layout.fxaccount_sign_in);
        this.emailEdit = (EditText)this.ensureFindViewById(null, R.id.email, "email edit");
        this.passwordEdit = (EditText)this.ensureFindViewById(null, R.id.password, "password edit");
        this.showPasswordButton = (Button)this.ensureFindViewById(null, R.id.show_password, "show password button");
        this.remoteErrorTextView = (TextView)this.ensureFindViewById(null, R.id.remote_error, "remote error text view");
        this.button = (Button)this.ensureFindViewById(null, R.id.button, "sign in button");
        this.progressBar = (ProgressBar)this.ensureFindViewById(null, R.id.progress, "progress bar");
        this.minimumPasswordLength = 1;
        this.createSignInButton();
        this.addListeners();
        this.updateButtonState();
        this.createShowPasswordButton();
        View view = this.ensureFindViewById(null, R.id.create_account_link, "create account instead link");
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent((Context)FxAccountSignInActivity.this, FxAccountCreateAccountActivity.class);
                intent.putExtra("email", FxAccountSignInActivity.this.emailEdit.getText().toString());
                intent.putExtra("password", FxAccountSignInActivity.this.passwordEdit.getText().toString());
                intent.setFlags(65536);
                FxAccountSignInActivity.this.startActivityForResult(intent, 3);
            }
        });
        if (this.getIntent() != null && this.getIntent().getExtras() != null) {
            Bundle bundle2 = this.getIntent().getExtras();
            this.emailEdit.setText((CharSequence)bundle2.getString("email"));
            this.passwordEdit.setText((CharSequence)bundle2.getString("password"));
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        Logger.debug(LOG_TAG, "onActivityResult: " + n);
        if (n != 3 || n2 != -1) {
            super.onActivityResult(n, n2, intent);
            return;
        }
        this.setResult(n2, intent);
        this.finish();
    }

    public void signIn(String string2, String string3) {
        String string4 = "https://api-accounts.dev.lcip.org";
        SignInDelegate signInDelegate = new SignInDelegate(string2, string3, string4);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        FxAccountClient20 fxAccountClient20 = new FxAccountClient20(string4, executorService);
        try {
            this.hideRemoteError();
            new FxAccountSetupTask.FxAccountSignInTask((Context)this, this, string2, string3, fxAccountClient20, signInDelegate).execute(new Void[0]);
        }
        catch (Exception exception) {
            this.showRemoteError(exception, R.string.fxaccount_sign_in_unknown_error);
        }
    }

    protected void createSignInButton() {
        this.button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String string2 = FxAccountSignInActivity.this.emailEdit.getText().toString();
                String string3 = FxAccountSignInActivity.this.passwordEdit.getText().toString();
                FxAccountSignInActivity.this.signIn(string2, string3);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SignInDelegate
    implements FxAccountClient10.RequestDelegate<FxAccountClient20.LoginResponse> {
        public final String email;
        public final String password;
        public final String serverURI;

        public SignInDelegate(String string2, String string3, String string4) {
            this.email = string2;
            this.password = string3;
            this.serverURI = string4;
        }

        @Override
        public void handleError(Exception exception) {
            FxAccountSignInActivity.this.showRemoteError(exception, R.string.fxaccount_sign_in_unknown_error);
        }

        @Override
        public void handleFailure(FxAccountClientException.FxAccountClientRemoteException fxAccountClientRemoteException) {
            FxAccountSignInActivity.this.showRemoteError(fxAccountClientRemoteException, R.string.fxaccount_sign_in_unknown_error);
        }

        @Override
        public void handleSuccess(FxAccountClient20.LoginResponse loginResponse) {
            AndroidFxAccount androidFxAccount;
            String string2;
            FxAccountSignInActivity fxAccountSignInActivity = FxAccountSignInActivity.this;
            Logger.info(LOG_TAG, "Got success signing in.");
            try {
                string2 = FxAccountConstants.DEFAULT_TOKEN_SERVER_URI;
                byte[] byArray = FxAccountUtils.generateQuickStretchedPW(this.email.getBytes("UTF-8"), this.password.getBytes("UTF-8"));
                byte[] byArray2 = FxAccountUtils.generateUnwrapBKey(byArray);
                Engaged engaged = new Engaged(this.email, loginResponse.uid, loginResponse.verified, byArray2, loginResponse.sessionToken, loginResponse.keyFetchToken);
                androidFxAccount = AndroidFxAccount.addAndroidAccount((Context)fxAccountSignInActivity, this.email, this.password, "default", this.serverURI, string2, engaged);
                if (androidFxAccount == null) {
                    throw new RuntimeException("Could not add Android account.");
                }
            }
            catch (Exception exception) {
                this.handleError(exception);
                return;
            }
            if (FxAccountConstants.LOG_PERSONAL_INFORMATION) {
                androidFxAccount.dump();
            }
            Intent intent = new Intent();
            intent.putExtra("authAccount", this.email);
            intent.putExtra("accountType", "org.mozilla.fennec_account");
            FxAccountSignInActivity.this.setResult(-1, intent);
            FxAccountSignInActivity.this.finish();
            if (loginResponse.verified) {
                string2 = new Intent((Context)FxAccountSignInActivity.this, FxAccountVerifiedAccountActivity.class);
            } else {
                string2 = new Intent((Context)FxAccountSignInActivity.this, FxAccountConfirmAccountActivity.class);
                string2.putExtra("sessionToken", loginResponse.sessionToken);
            }
            string2.putExtra("email", this.email);
            string2.setFlags(65536);
            FxAccountSignInActivity.this.startActivity((Intent)string2);
        }
    }
}

